*
      SUBROUTINE STOPTEST2( N, R, B, BNRM2, RESID, TOL, INFO )
*
*     .. Scalar Arguments ..
      INTEGER            N, INFO
      REAL               RESID, TOL, BNRM2
*     ..
*     .. Array Arguments ..
      REAL               R( * ), B( * )
*     ..
*
*  Purpose
*  =======
*
*  Computes the stopping criterion 2.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER.
*          On entry, the dimension of the matrix.
*          Unchanged on exit.
*
*  INFO    (output) INTEGER
*          On exit, 1/0 depending on whether stopping criterion
*          was met or not.
*
*  BNRM2   (input/output) REAL            .
*          On first time entry, will be -1.0.
*          On first time exit will contain norm2(B)
*          On all subsequent entry/exit's unchanged.
*
*  RESID   (output) REAL            .
*          On exit, the computed stopping measure.
*
*  TOL     (input) REAL            .
*          On input, the allowable convergence measure.
*
*  R       (input) REAL             array, dimension N.
*          On entry, the residual.
*          Unchanged on exit.
*
*  B       (input) REAL             array, dimension N.
*          On entry, right hand side vector B.
*          Unchanged on exit.
*
*  BLAS CALLS:   SNRM2
*  ============================================================
*
*     .. Parameters ..
      REAL               ZERO, ONE
      PARAMETER        ( ZERO = 0.0E+0, ONE = 1.0E+0 )
*     ..
*     .. External Routines ..
      REAL             SNRM2
      EXTERNAL         SNRM2
*     ..
*     .. Executable Statements ..
*
      IF( INFO.EQ.-1 ) THEN
         BNRM2 = SNRM2( N, B, 1 )
         IF ( BNRM2.EQ.ZERO ) BNRM2 = ONE
      ENDIF
*
      RESID = SNRM2( N, R, 1 ) / BNRM2
*
      INFO = 0
      IF ( RESID.LE.TOL )
     $     INFO = 1
*
      RETURN
*
*     End of STOPTEST2
*
      END
