/*
    The PC (preconditioner) interface routines, callable by users.
*/
#include "parpre_pc.h"

#undef __FUNC__
#define __FUNC__ "PCHasType"
int PCHasType(PC pc,PCType type,int *flag)
{
  PCType the_type;
  int ierr; char *f;

  ierr = PCGetType(pc,&the_type); CHKERRQ(ierr);
  ierr = PetscStrstr(type,the_type,&f); CHKERRQ(ierr);
  *flag = (int) f;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCIsParallel"
int PCIsParallel(PC pc) /* VE */
{
  /*if (pc->type >= PCAdditiveSchwarz)*/ return 1;
  /*else return 0;*/
}

#undef __FUNC__
#define __FUNC__ "PCIsSchwarzMethod"
int PCIsSchwarzMethod(PC pc) /* VE */
{
  PCType type;
  int ierr; char *f1,*f2;
  
  ierr = PCGetType(pc,&type);
  ierr = PetscStrstr(type,PCAdditiveSchwarz,&f1); CHKERRQ(ierr);
  ierr = PetscStrstr(type,PCMultiplicativeSchwarz,&f2); CHKERRQ(ierr);
  if (f1||f2) return 1;
  else return 0;
}

