#ifndef __PARPRE_SUBDOMAINS_PACKAGE 
#define __PARPRE_SUBDOMAINS_PACKAGE

#include "petscpc.h"
#include "petscsles.h"
#include "parpre_pipeline.h"

typedef struct _PCParallelSubdomainStruct* PCParallelSubdomainStruct;
typedef struct PCParallelStruct {
  PCParallelSubdomainStruct subdomains;
} PCParallelStruct;

extern int PCParallelSubdomainsCreate(PC pc,int size);
extern int PCParallelDestroySubdomains(PC pc);
extern int PCParallelSetSubdomainSystem(PC pc, Mat mat, Vec vec);

extern int ParPreGenerateSLES(MPI_Comm comm,SLES *sles);
extern int ParPreSetupSLES(SLES sub_method,PCType type,Mat mat, Vec vec);

extern int PCParallelSetLocalSLES(PC pc,SLES local_sles);
extern int PCParallelGetLocalSLES(PC pc,SLES *local_sles);
extern int PCParallelSetGetLocalSLES(PC pc,int(*getlocalmethod)(PC,SLES*));

extern int PCParallelLocalSolveSetFromOptions(PC pc);

extern int PCParallelSubdomainsSetPipeline(PC pc,VecPipeline pipe);
extern int PCParallelSubdomainsGetPipeline(PC pc,VecPipeline *pipe);

extern int PCParallelSubdomainPipelineSetType
(PC pc,PipelineType pipe_type,PetscObject x);
extern int PCParallelDefaultSubdomainPipelineSetType
(PC,PipelineType,PetscObject x);
extern int PCParallelSetSubdomainPipelineSetType
(PC,int(*)(PC,PipelineType,PetscObject x));

extern int PCParallelSubdomainPipelineGetType(PC pc,PipelineType *pipe_type);
extern int PCParallelDefaultSubdomainPipelineGetType(PC pc,PipelineType*);
extern int PCParallelSetSubdomainPipelineGetType(PC,int(*)(PC,PipelineType*));

extern int PCParallelSubdomainPipelineGetObject(PC pc,PetscObject *pipe_obj);
extern int PCParallelDefaultSubdomainPipelineGetObject(PC pc,PetscObject *pipe_obj);
extern int PCParallelSetSubdomainPipelineGetObject(PC pc,int(*getobject)(PC,PetscObject*));


extern int PCSubdomainsView(PC pc,Viewer viewer);

#endif
