#include <stdio.h>
#include "./examples.h"

#undef __FUNC__
#define __FUNC__ "prec_setup"
int prec_setup(MPI_Comm comm,Mat A,PC the_pc)
{
  PCType pc_name = PCMultiLevel;
  int mytid,flg,method, ierr;

  PetscFunctionBegin;

  ierr = OptionsHasName(PETSC_NULL,"-help",&flg); CHKERRQ(ierr);
  if (flg) {
    PetscPrintf(comm,"Multilevel methods available by using -method <nn>:\n");
    PetscPrintf(comm,"    0=Identity\n    1=Jacobi\n    2=SSOR\n    3=ILU(0)\n");
    PetscPrintf(comm,"    4=ILU(k)\n    5=Multigrid\n\n");
    PetscFunctionReturn(0);
  }
 
  MPI_Comm_rank(comm,&mytid);
  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  if (!mytid) printf("Setting up AMG pc\n");
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);

  /* undocumented option */
  ierr = OptionsHasName(PETSC_NULL,"-orth",&flg);
  if (flg) {ierr = AMLorth(the_pc); CHKERRQ(ierr);}

  ierr = AMLSetTraceLevel(the_pc,AMLTraceColours | AMLTraceFill);
  /* | AMLTraceIndexSets */  CHKERRQ(ierr);

  ierr = OptionsGetInt(PETSC_NULL,"-method",&method,&flg); CHKERRQ(ierr);
  if (!flg) method=0;

  switch (method) {
  case 0:
    /****************
     * Identity preconditioner
     ****************/
    
    /* factorisation as ILU but no actual factorisation */
    ierr = AMLSetCoarseGridDependent(the_pc); CHKERRQ(ierr);
    ierr = AMLSetFillMethod(the_pc,AMLFillNone); CHKERRQ(ierr);
    
    /* solution as ILU, but no transfer,
       and PCNONE on (1,1) blocks and deepest level */
    ierr = AMLSetSolutionScheme(the_pc,AMLSolveILU); CHKERRQ(ierr);
    ierr = OptionsSetValue("-11solver_pc_type","none"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_pc_type","none"); CHKERRQ(ierr);
    ierr = AMLSetNoTransfer(the_pc); CHKERRQ(ierr);
    break;

  case 1:  
    /****************
     * Jacobi preconditioner
     ****************/

    /* factorisation as ILU but no actual factorisation */
    ierr = AMLSetCoarseGridDependent(the_pc); CHKERRQ(ierr);
    ierr = AMLSetFillMethod(the_pc,AMLFillNone); CHKERRQ(ierr);

    /* solution as ILU, but no transfer,
       and PCJACOBI on (1,1) blocks and deepest level */
    ierr = AMLSetSolutionScheme(the_pc,AMLSolveILU); CHKERRQ(ierr);
    ierr = OptionsSetValue("-11solver_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = AMLSetNoTransfer(the_pc); CHKERRQ(ierr);
    break; 

  case 2:
    /****************
     * SSOR preconditioner
     ****************/

    /* factorisation as ILU */
    ierr = AMLSetCoarseGridDependent(the_pc); CHKERRQ(ierr);
    ierr = AMLSetSchurElimination(the_pc); CHKERRQ(ierr);
    ierr = AMLSetFillMethod(the_pc,AMLFillNone); CHKERRQ(ierr);

    /* solution as ILU with PCJACOBI on (1,1) blocks and deepest level */
    ierr = AMLSetSolutionScheme(the_pc,AMLSolveILU); CHKERRQ(ierr);
    ierr = OptionsSetValue("-11solver_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);
    break;

  case 3:
    /****************
     * incomplete factorisation, ILU(0)
     ****************/
    
    /* factorisation as ILU(0) */
    ierr = AMLSetCoarseGridDependent(the_pc); CHKERRQ(ierr);
    ierr = AMLSetSchurElimination(the_pc); CHKERRQ(ierr);
    ierr = AMLSetFillMethod(the_pc,AMLFillDiag); CHKERRQ(ierr);

    /* solution as ILU with PCJACOBI on (1,1) blocks and deepest level */
    ierr = AMLSetSolutionScheme(the_pc,AMLSolveILU); CHKERRQ(ierr);
    ierr = OptionsSetValue("-11solver_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = AMLSetCutoffSize(the_pc,20); CHKERRQ(ierr);
    break;

  case 4:
    /****************
     * incomplete factorisation, ILU(k)
     ****************/

    /* factorisation as ILU(r) */
    ierr = AMLSetCoarseGridDependent(the_pc); CHKERRQ(ierr);
    ierr = AMLSetSchurElimination(the_pc); CHKERRQ(ierr);
    ierr = AMLSetFillMethod(the_pc,AMLFillStrong); CHKERRQ(ierr);
    ierr = AMLSetStrongRatio(the_pc,.15); CHKERRQ(ierr);
    ierr = AMLSetISFromStrong(the_pc); CHKERRQ(ierr);

    /* solution as ILU with PCJACOBI on (1,1) blocks and deepest level */
    ierr = AMLSetSolutionScheme(the_pc,AMLSolveILU); CHKERRQ(ierr);
    ierr = OptionsSetValue("-11solver_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = AMLSetCutoffSize(the_pc,20); CHKERRQ(ierr);
    break;

  case 5:
    /****************
     * multigrid 
     ****************/
    
    /* variational elimination */
    ierr = AMLSetISFromStrong(the_pc); CHKERRQ(ierr);
    ierr = AMLSetStrongRatio(the_pc,.15); CHKERRQ(ierr);
    ierr = AMLSetCoarseGridIndependent(the_pc); CHKERRQ(ierr);
    ierr = AMLSetSchurVariational(the_pc); CHKERRQ(ierr);
    /*ierr = AMLSetSchurElimination(the_pc); CHKERRQ(ierr);*/
    ierr = AMLSetFillMethod(the_pc,AMLFillFull); CHKERRQ(ierr);
    
    ierr = AMLSetSolutionScheme(the_pc,AMLSolveMG); CHKERRQ(ierr);
    ierr = AMLSetSmootherChoice(the_pc,AMLPrePostSmooth); CHKERRQ(ierr);
    ierr = AMLSetCutoffSize(the_pc,20); CHKERRQ(ierr);
    ierr = OptionsSetValue("-presmoother_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-postsmoother_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-11solver_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);
  }
  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  PetscFunctionReturn(0);
}

