####################################
package RIB::Class;
use strict;
use RIB::Attribute;
use RIB::Relationship;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = {
    'NAME'               => undef,
    'EXTENDS'            => undef, # the name of the class that this one extends
    'ATTRIBUTES'         => [],
    'RELATIONSHIPS'      => []
  };
  bless ($self, $class);
  return $self;
}

sub name {
  my $self = shift;
  if (@_) { $self->{'NAME'} = shift }
  return $self->{'NAME'};
}

sub extends {
  my $self = shift;
  if (@_) { $self->{'EXTENDS'} = shift }
  return $self->{'EXTENDS'};
}

sub attributes {
  my ($self) = @_;
  return $self->{'ATTRIBUTES'};
}

sub get_attribute {
  my ($self,$attrName) = @_;
  foreach my $x (@{$self->{'ATTRIBUTES'}}) {
    if ($x->name() eq $attrName) {
      return $x;
    }
  }
  return undef;
}

sub push_attribute {
  my ($self,$attribute) = @_;
  push (@{$self->{'ATTRIBUTES'}}, $attribute);
}

sub delete_attribute {
  my ($self,$to_delete) = @_;
  # first clear it out, then build it back up.
  my $tmp = [];
  my $x;
  foreach $x (@{$self->attributes}) {
    next if $x == $to_delete;
    push @{$tmp}, $x;
  }
  $self->{'ATTRIBUTES'} = $tmp;
}

sub relationships {
  my $self = shift;
  return $self->{'RELATIONSHIPS'};
}

sub get_relationship {
  my ($self,$relName) = @_;
  foreach my $x (@{$self->{'RELATIONSHIPS'}}) {
    if ($x->name() eq $relName) {
      return $x;
    }
  }
  return undef;
}

sub push_relationship {
  my ($self,$relationship) = @_;
  push (@{$self->{'RELATIONSHIPS'}}, $relationship);
}

sub delete_relationship {
  my ($self,$to_delete) = @_;
  # first clear it out, then build it back up.
  my $tmp = [];
  my $x;
  foreach $x (@{$self->relationships}) {
    next if $x == $to_delete;
    push @{$tmp}, $x;
  }
  $self->{'RELATIONSHIPS'} = $tmp;
}

sub values_of {
  my ($self,$field_name) = @_;
  my $tmp;
  foreach $tmp (@{$self->attributes}, @{$self->relationships}) {
    if ($tmp->name eq $field_name) {
      return $tmp->values;
    }
  }
  return [];
}

sub is_attribute {
  my ($self,$field_name) = @_;
  my $tmp;
  foreach $tmp (@{$self->attributes}) {
    return 1 if $tmp->name eq $field_name;
  }
  return 0;
}

sub is_relationship {
  my ($self,$field_name) = @_;
  my $tmp;
  foreach $tmp (@{$self->relationships}) {
    return 1 if $tmp->name eq $field_name;
  }
  return 0;
}

# if field has an alt name then return it, else return just
# return the field name
sub get_alt {
  my ($self,$field_name) = @_;
  my $tmp;
  foreach $tmp (@{$self->attributes}, @{$self->relationships}) {
    if ($tmp->name eq $field_name) {
      $tmp->alt ? return $tmp->alt : return $field_name;
    }
  }
}

# show or noshow in the catalog? unless specified return "SHOW"
sub get_display {
  my ($self,$field_name) = @_;
  my $tmp;
  foreach $tmp (@{$self->attributes}, @{$self->relationships}) {
    if ($tmp->name eq $field_name) {
      return $tmp->display;
    }
  }
  return "show";
}

1;
