#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;

##############################################

my $util = new RIB::Util();
my $riburl = $util->RibUrl;
$util->dbConnect();

#get the main rib password
my $sth = $util->dbh->prepare("select password from admin");
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }

my $main_rib_password = $sth->fetchrow_array;

#check the password supplied by the user
if (!defined(param('password'))) {
  print header,
        start_html('-title'=>'Change RIB password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Enter Main RIB Password')),
        p,hr,p,
        "Please enter the current main RIB password in the form below<p>\n",
        start_form,
        password_field(-name=>'password', -size=>50, -maxlength=>80),
        submit(-value=>'Submit'), end_form, end_html;
  goto FALLOFF;
}

if (param('password') ne $main_rib_password) {
  param('password',''); # setting -value=>'' doesn't seem to work
  print header,
        start_html('-title'=>'Change Main RIB Password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Enter Main RIB Password')),
        p,hr,p,
        "The password that you entered was incorrect. Please try again.<P>\n",
        "Please enter the current main RIB password in the form below<p>\n",
        start_form,
        password_field(-name=>'password', -size=>50, -maxlength=>80, -value=>''),
        submit(-value=>'Submit'), end_form, end_html;
  goto FALLOFF;
}

my $passwd_form = 
      "Please enter the new main RIB password in the form below. "
      . "Click <A HREF=$riburl/doc/top_help.html#ac>here</A> for help."
      . start_form
      . "<TABLE><TR><TD>New Password:</TD><TD>"
      . password_field(-name=>'newPasswd1', -size=>50, -maxlength=>80, -value=>'')
      . "</TD></TR><TR><TD>Retype Password:</TD><TD>"
      . password_field(-name=>'newPasswd2', -size=>50, -maxlength=>80, -value=>'')
      . "</TD></TR></TABLE>"
      . p
      . hidden(-name=>'password')
      . submit(-value=>'Submit')
      . end_form
      . end_html;

if (!defined(param('newPasswd1'))) {
  print header,
        start_html('-title'=>'Change Main RIB Password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Change Main RIB Password')),
        p,hr,p,
        $passwd_form;
  goto FALLOFF;
}

if (length(param('newPasswd1')) < 5) {
  print header,
        start_html('-title'=>'Change Main RIB Password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Change Main RIB Password')),
        p,hr,p,
        "New Password should be at least 5 characters long.",
        $passwd_form;
  goto FALLOFF;
}

if (length(param('newPasswd1')) < 5) {
  print header,
        start_html('-title'=>'Change Main RIB Password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Change Main RIB Password')),
        p,hr,p,
        "Passwords didn't match. Please retype the passwords.",
        $passwd_form;
  goto FALLOFF;
}

$sth = $util->dbh->prepare("UPDATE admin SET password="
                . $util->dbh->quote(param('newPasswd1')));

unless ($sth->execute) {
  $util->error($util->dbh->errstr);
}

param('password',param('newPasswd1'));

print header,
      start_html('-title'=>'Change Main RIB Password',-BGCOLOR=>'#FFFFFF'),
      center(h1('Change Main RIB Password')),
      p,hr,p,
      "The main RIB password was successfully changed.",
      p,
      start_form(-action=>'top.pl'),
      hidden(-name=>'password'),
      submit(-value=>'Return to the RIB management page'),
      end_form;

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
