#BANGLINE

#################################################
use strict;
use CGI qw/:standard/;
use RIB::Util;

################################################

my $util=new RIB::Util();

unless(param('rh')=~/^\d+$/) {
	$util->error("repository handle not specified in input");
}
my $rh=param('rh');

unless(param('class')=~/^[A-Za-z]+$/) {
	$util->error("class not specified in input");
}
my $class=param('class');

unless(param('oh')=~/^\d+$/) {
	$util->error("object handle not specified in input");
}
my $oh=param('oh');

unless(param('file')) {
	$util->error("file not specified in input");
}
my $file=param('file');

my $ribdir=$util->RibDir();
my $riburl=$util->RibUrl();
my $ribversion=$util->RibVersion();

$util->dbConnect();
$util->authenticate(param('repoPasswd'),$rh);

my $class_handle=$rh . "_" . $class;

# Lock the table
unless($util->dbh->do("LOCK TABLES $class_handle WRITE")) {
	$util->error("Can't get lock on $class_handle: " . $util->dbh->errstr);
}

# Update the object record
my $sth=$util->dbh->prepare("UPDATE $class_handle SET file='$file' " .
                            "WHERE handle=$oh");
eval { $sth->execute(); };
if($@) { $util->error($@); }

# Unlock the table
$util->dbh->do("UNLOCK TABLES");

print header(-type=>"text/plain"),"ok";

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
