/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.Component;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class RibUtil {
    private static String defaultInput = "";

    public static boolean alphaChars(String string) {
        if (string == null) {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string.toUpperCase());
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c < 'A' || c > 'Z') {
                return false;
            }
            c = stringCharacterIterator.next();
        }
        return true;
    }

    public static boolean alphanumericChars(String string) {
        if (string == null) {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string.toUpperCase());
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!(c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || Character.isWhitespace(c))) {
                return false;
            }
            c = stringCharacterIterator.next();
        }
        return true;
    }

    public static boolean alphanumericsymbolChars(String string) {
        if (string == null) {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string.toUpperCase());
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c < ' ' || c > '~') {
                return false;
            }
            c = stringCharacterIterator.next();
        }
        return true;
    }

    public static String collapseString(String string) {
        String string2 = new String();
        if (string == null) {
            return string2;
        }
        if (string.trim().length() == 0) {
            return string2;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string.trim());
        boolean bl = true;
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (Character.isWhitespace(c)) {
                if (bl) {
                    string2 = String.valueOf(string2) + ' ';
                }
                bl = false;
            } else {
                string2 = String.valueOf(string2) + c;
                bl = true;
            }
            c = stringCharacterIterator.next();
        }
        return string2;
    }

    public static String getAlphabeticDialogInput(String string, int n, Component component) {
        String string2;
        while (true) {
            if ((string2 = (String)JOptionPane.showInputDialog(component, string, null, 3, null, null, "")) == null) {
                return null;
            }
            if (string2.length() > n) {
                JOptionPane.showMessageDialog(component, "Input must be less than " + String.valueOf(n) + " characters.");
                continue;
            }
            if (RibUtil.alphaChars(string2)) break;
            JOptionPane.showMessageDialog(component, "Input must contain only alphabetic characters.");
        }
        return string2;
    }

    public static String getAlphanumericDialogInput(String string, int n, Component component) {
        String string2;
        while (true) {
            if ((string2 = (String)JOptionPane.showInputDialog(component, string, null, 3, null, null, "")) == null) {
                return null;
            }
            if (string2.length() > n) {
                JOptionPane.showMessageDialog(component, "Input must be less than " + String.valueOf(n) + " characters.");
                continue;
            }
            if (RibUtil.alphanumericChars(string2)) break;
            JOptionPane.showMessageDialog(component, "Input must contain only alphanumeric characters.");
        }
        return string2;
    }

    public static String getAlphanumericsymbolDialogInput(String string, int n, Component component) {
        String string2;
        while (true) {
            string2 = (String)JOptionPane.showInputDialog(component, string, null, 3, null, null, defaultInput);
            defaultInput = "";
            if (string2 == null) {
                return null;
            }
            if (string2.length() > n) {
                JOptionPane.showMessageDialog(component, "Input must be less than " + String.valueOf(n) + " characters.");
                continue;
            }
            if (string2.indexOf("!") >= 0 || string2.indexOf("\"") >= 0 || string2.indexOf("<") >= 0 || string2.indexOf(">") >= 0) {
                JOptionPane.showMessageDialog(component, "Input should not contain the !, \", <, or > characters.");
                continue;
            }
            if (RibUtil.alphanumericsymbolChars(string2)) break;
            JOptionPane.showMessageDialog(component, "Input should only contain alphanumeric and symbols on your keyboard.");
        }
        return string2;
    }

    public static String getAlphanumericsymbolDialogInput(String string, int n, Component component, String string2) {
        defaultInput = string2;
        return RibUtil.getAlphanumericsymbolDialogInput(string, n, component);
    }

    public static Hashtable getInteropIntervals() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("30 minutes", String.valueOf(1800));
        hashtable.put("1 hour", String.valueOf(3600));
        hashtable.put("2 hours", String.valueOf(7200));
        hashtable.put("3 hours", String.valueOf(10800));
        hashtable.put("6 hours", String.valueOf(21600));
        hashtable.put("12 hours", String.valueOf(43200));
        hashtable.put("1 day", String.valueOf(86400));
        hashtable.put("2 days", String.valueOf(172800));
        hashtable.put("3 days", String.valueOf(259200));
        hashtable.put("6 days", String.valueOf(518400));
        hashtable.put("12 days", String.valueOf(1036800));
        hashtable.put("1 month", String.valueOf(2592000));
        return hashtable;
    }

    public static String getRibVersion() {
        return "2.1";
    }

    public static String[] getSortedInteropIntervals() {
        String[] stringArray = new String[]{"30 minutes", "1 hour", "2 hours", "3 hours", "6 hours", "12 hours", "1 day", "2 days", "3 days", "6 days", "12 days", "1 month"};
        return stringArray;
    }

    public static Vector sortStringVector(Vector vector) {
        int n = vector.size();
        if (n == 0) {
            return vector;
        }
        Vector vector2 = new Vector();
        vector2.addElement(vector.firstElement());
        int n2 = 1;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < n2) {
                String string2 = (String)vector2.elementAt(n3);
                if (string.toLowerCase().compareTo(string2.toLowerCase()) < 1) {
                    vector2.insertElementAt(new String(string), n3);
                    break;
                }
                if (n3 == n2 - 1) {
                    vector2.addElement(new String(string));
                }
                ++n3;
            }
            ++n2;
        }
        return vector2;
    }
}

