/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibConfig;
import org.nhse.rib.RibFileChooser;
import org.nhse.rib.RibInterface;
import org.nhse.rib.TableSorter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RibObjectBrowser
extends JPanel {
    String className;
    RibComm ribComm;
    RibInterface ribInterface;
    Vector objectList = new Vector();
    Vector columnNames = new Vector();
    JTable table;
    TableSorter sorter;
    JScrollPane scrollpane;
    JComboBox classCombo;
    JButton createButton;
    JButton importButton;
    JButton refreshButton;

    public RibObjectBrowser(RibInterface ribInterface, RibComm ribComm, String string) {
        JComponent jComponent;
        this.setLayout(new FlowLayout(1, 5, 5));
        this.setBackground(Color.white);
        this.setSize(0, 0);
        this.ribInterface = ribInterface;
        this.ribComm = ribComm;
        this.className = string;
        this.setLayout(new BorderLayout());
        this.sorter = new TableSorter(new MyTableModel());
        this.table = new JTable(this.sorter);
        this.table.setShowHorizontalLines(false);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.addMouseListener(new PopupListener());
        this.scrollpane = new JScrollPane(this.table);
        this.add((Component)this.scrollpane, "Center");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(new BevelBorder(1));
        ((Container)jToolBar).setLayout(new BoxLayout(jToolBar, 0));
        jToolBar.setFloatable(false);
        RibConfig ribConfig = new RibConfig(this.ribInterface.configUrl);
        ribConfig.parse();
        JPanel jPanel = new JPanel(new FlowLayout(0));
        if (ribConfig.getClassNames(false).size() == 0) {
            this.ribInterface.showAlert("Error : Cannot parse repository configuration");
        } else {
            jPanel = new JPanel(new FlowLayout(0));
            jComponent = new JLabel("Class :");
            jPanel.add(jComponent);
            Vector vector = ribConfig.getClassNames(false);
            this.classCombo = new JComboBox(vector);
            this.classCombo.setSelectedItem(this.className);
            this.classCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RibObjectBrowser.this.classCombo.getSelectedItem() != null) {
                        RibObjectBrowser.this.ribInterface.showObjectsList((String)RibObjectBrowser.this.classCombo.getSelectedItem());
                    }
                }
            });
            this.classCombo.setBackground(Color.white);
            this.classCombo.setMaximumRowCount(this.classCombo.getItemCount());
            this.classCombo.setToolTipText("Work with another class");
            jPanel.add(this.classCombo);
        }
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        jToolBar.add(jPanel);
        this.createButton = new JButton("  Create  ");
        this.createButton.addMouseListener(new ButtonPushMouseListener(this.createButton));
        jToolBar.add(this.createButton);
        this.createButton.setToolTipText("Create a new " + this.className);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Thread(RibObjectBrowser.this){
                    private final /* synthetic */ RibObjectBrowser this$0;
                    {
                        this.this$0 = ribObjectBrowser;
                    }

                    public void run() {
                        this.this$0.ribInterface.createObject(this.this$0.className);
                    }
                });
            }
        });
        jToolBar.add(Box.createHorizontalStrut(2));
        this.importButton = new JButton("  Import  ");
        this.importButton.addMouseListener(new ButtonPushMouseListener(this.importButton));
        jToolBar.add(this.importButton);
        this.importButton.setToolTipText("Import a new " + this.className);
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)JOptionPane.showInputDialog(RibObjectBrowser.this.ribInterface, "URL : ", null, 3, null, null, null);
                if (string == null) {
                    return;
                }
                string.trim();
                if (string.length() == 0) {
                    return;
                }
                if (string.indexOf("://") == -1) {
                    string = "http://" + string;
                }
                if (string.indexOf("&html=1") != -1) {
                    int n = string.indexOf("&html=1");
                    String string2 = string.substring(0, n);
                    if (string2.length() < string.length() - 7) {
                        string2 = String.valueOf(string2) + string.substring(n + 7, string.length());
                    }
                    string = string2;
                } else if (string.indexOf("html=1") != -1) {
                    int n = string.indexOf("html=1&");
                    String string3 = string.substring(0, n);
                    string = string3 = String.valueOf(string3) + string.substring(n + 7, string.length());
                } else if (string.indexOf("/catalog/" + RibObjectBrowser.this.className + "/") != -1) {
                    int n = string.indexOf("/catalog/");
                    String string4 = string.substring(0, n);
                    string4 = String.valueOf(string4) + "/objects";
                    string = string4 = String.valueOf(string4) + string.substring(n + 8, string.length());
                }
                try {
                    new URL(string);
                }
                catch (Exception exception) {
                    RibObjectBrowser.this.ribInterface.showAlert("Improperly formatted URL");
                    return;
                }
                RibObjectBrowser.this.ribInterface.importObject(string, RibObjectBrowser.this.className);
            }
        });
        this.refreshButton = new JButton("  Refresh  ");
        this.refreshButton.addMouseListener(new ButtonPushMouseListener(this.refreshButton));
        jToolBar.add(Box.createHorizontalStrut(2));
        jToolBar.add(this.refreshButton);
        this.refreshButton.setToolTipText("Contact server to refresh the list below");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RibObjectBrowser.this.ribInterface.showStatus("Accessing network...");
                RibObjectBrowser.this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
                RibObjectBrowser.this.refresh();
                RibObjectBrowser.this.ribInterface.showStatus("");
                RibObjectBrowser.this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        jComponent = new HelpButton("object_browser.html", this.ribInterface);
        jComponent.setMaximumSize(new Dimension(jComponent.getPreferredSize().width, this.refreshButton.getPreferredSize().height));
        jComponent.setToolTipText("Display help on the object browser");
        jToolBar.add(Box.createHorizontalStrut(2));
        jToolBar.add(jComponent);
        this.createButton.setAlignmentY(0.5f);
        this.importButton.setAlignmentY(0.5f);
        this.refreshButton.setAlignmentY(0.5f);
        jPanel.setAlignmentY(0.5f);
        jComponent.setAlignmentY(0.5f);
        this.createButton.setAlignmentX(0.5f);
        this.importButton.setAlignmentX(0.5f);
        this.refreshButton.setAlignmentX(0.5f);
        jPanel.setAlignmentX(0.5f);
        jComponent.setAlignmentX(0.5f);
        this.add((Component)jToolBar, "North");
        this.refreshTable();
    }

    public void refresh() {
        this.createButton.setEnabled(true);
        this.importButton.setEnabled(true);
        RibConfig ribConfig = new RibConfig(this.ribInterface.configUrl);
        ribConfig.parse();
        this.classCombo.removeAllItems();
        Vector vector = ribConfig.getClassNames(false);
        int n = 0;
        while (n < vector.size()) {
            this.classCombo.addItem(vector.elementAt(n));
            ++n;
        }
        if (ribConfig.getClassNames(false).size() == 0) {
            this.ribInterface.showAlert("Error : Cannot parse repository configuration");
        } else {
            this.classCombo.setMaximumRowCount(this.classCombo.getItemCount());
            if (ribConfig.getClass(this.className) == null) {
                this.ribInterface.showAlert("The " + this.className + " class has been deleted from the repository configuration.\nPlease choose another class in the Class selection box.");
                this.remove(this.table);
                this.table = new JTable();
                this.table.setBackground(Color.white);
                this.add((Component)this.table, "Center");
                this.createButton.setEnabled(false);
                this.importButton.setEnabled(false);
            } else {
                this.classCombo.setSelectedItem(this.className);
            }
        }
    }

    public void refreshTable() {
        Element element;
        this.ribInterface.showStatus("Accessing network...");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
        NodeList nodeList = null;
        try {
            try {
                nodeList = this.ribComm.listObjects(this.className);
            }
            catch (Exception exception) {
                this.ribInterface.showAlert(exception.toString());
            }
            element = null;
            this.ribInterface.showStatus("");
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.ribInterface.showStatus("");
            this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
        this.objectList = new Vector(nodeList.getLength());
        int n = 0;
        while (n < nodeList.getLength()) {
            element = (Element)nodeList.item(n);
            String string = element.getAttribute("name");
            String string2 = element.getAttribute("handle");
            String string3 = element.getAttribute("last_modified");
            String string4 = element.getAttribute("approved");
            String string5 = element.getAttribute("url");
            String string6 = element.getAttribute("file");
            if (string != null && string2 != null && string3 != null && string4 != null && string5 != null) {
                Vector<String> vector = new Vector<String>(5);
                vector.addElement(string);
                try {
                    String string7 = String.valueOf(string3.substring(0, 4)) + "/" + string3.substring(4, 6) + "/" + string3.substring(6, 8) + " at " + string3.substring(8, 10) + ":" + string3.substring(10, 12);
                    vector.addElement(string7);
                }
                catch (Exception exception) {
                    System.err.println(exception.toString());
                    vector.addElement("????");
                }
                if (string4.equals("1")) {
                    vector.addElement("approved");
                } else if (string4.equals("0")) {
                    vector.addElement("not approved");
                } else {
                    vector.addElement("????");
                }
                if (string6 != null) {
                    vector.addElement(string6);
                } else {
                    vector.addElement("????");
                }
                vector.addElement(string2);
                vector.addElement(string5);
                this.objectList.addElement(vector);
            }
            ++n;
        }
        this.sorter.tableChanged(new TableModelEvent(this.table.getModel()));
        this.sorter.sortByColumn(0);
        this.table.clearSelection();
    }

    class MyTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Name", "Last Modified", "Status", "File"};

        MyTableModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return RibObjectBrowser.this.objectList.size();
        }

        public Object getValueAt(int n, int n2) {
            Vector vector = (Vector)RibObjectBrowser.this.objectList.elementAt(n);
            return vector.elementAt(n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            Vector vector = (Vector)RibObjectBrowser.this.objectList.elementAt(n);
            vector.setElementAt(object, n2);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        static /* synthetic */ RibObjectBrowser access$0(PopupListener popupListener) {
            return popupListener.RibObjectBrowser.this;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            if (mouseEvent.getClickCount() == 2) {
                int n = RibObjectBrowser.this.table.getSelectedRow();
                String string = (String)RibObjectBrowser.this.sorter.getValueAt(n, 4);
                String string2 = (String)RibObjectBrowser.this.sorter.getValueAt(n, 5);
                RibObjectBrowser.this.ribInterface.editObject(string2, string, RibObjectBrowser.this.className);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        public void showPopup(MouseEvent mouseEvent) {
            if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            int n = RibObjectBrowser.this.table.getSelectedRowCount();
            if (n < 1) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Edit");
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ PopupListener this$1;
                {
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = PopupListener.access$0((PopupListener)this.this$1).table.getSelectedRow();
                    String string = (String)PopupListener.access$0((PopupListener)this.this$1).sorter.getValueAt(n, 4);
                    String string2 = (String)PopupListener.access$0((PopupListener)this.this$1).sorter.getValueAt(n, 5);
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.editObject(string2, string, PopupListener.access$0((PopupListener)this.this$1).className);
                }
            });
            jPopupMenu.add(jMenuItem);
            if (n > 1) {
                jMenuItem.setEnabled(false);
            }
            JMenu jMenu = new JMenu("View");
            jPopupMenu.add(jMenu);
            if (n > 1) {
                jMenu.setEnabled(false);
            }
            JMenuItem jMenuItem2 = new JMenuItem("HTML");
            jMenu.add(jMenuItem2);
            jMenuItem2.addActionListener(new ActionListener(this){
                private final /* synthetic */ PopupListener this$1;
                {
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        int n = PopupListener.access$0((PopupListener)this.this$1).table.getSelectedRow();
                        String string = String.valueOf((String)PopupListener.access$0((PopupListener)this.this$1).sorter.getValueAt(n, 5)) + "&html=1";
                        URL uRL = new URL(string);
                        PopupListener.access$0((PopupListener)this.this$1).ribInterface.getAppletContext().showDocument(uRL, "_blank");
                    }
                    catch (Exception exception) {
                        PopupListener.access$0((PopupListener)this.this$1).ribInterface.showAlert(exception.toString());
                    }
                }
            });
            JMenuItem jMenuItem3 = new JMenuItem("XML");
            jMenu.add(jMenuItem3);
            jMenuItem3.addActionListener(new ActionListener(this){
                private final /* synthetic */ PopupListener this$1;
                {
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        int n = PopupListener.access$0((PopupListener)this.this$1).table.getSelectedRow();
                        String string = (String)PopupListener.access$0((PopupListener)this.this$1).sorter.getValueAt(n, 5);
                        URL uRL = new URL(string);
                        PopupListener.access$0((PopupListener)this.this$1).ribInterface.getAppletContext().showDocument(uRL, "_blank");
                    }
                    catch (Exception exception) {
                        PopupListener.access$0((PopupListener)this.this$1).ribInterface.showAlert(exception.toString());
                    }
                }
            });
            JMenuItem jMenuItem4 = new JMenuItem("Delete");
            jMenuItem4.addActionListener(new ActionListener(n, this){
                private final /* synthetic */ PopupListener this$1;
                private final /* synthetic */ int val$rowCount;
                {
                    this.val$rowCount = n;
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    String[] stringArray = new String[this.val$rowCount];
                    int[] nArray = PopupListener.access$0((PopupListener)this.this$1).table.getSelectedRows();
                    String string = "Are you sure that you want to delete the selected object?";
                    if (nArray.length > 1) {
                        string = "Are you sure that you want to delete the " + nArray.length + " selected objects?";
                    }
                    if ((n = JOptionPane.showConfirmDialog(PopupListener.access$0((PopupListener)this.this$1).ribInterface, string, "Confirm delete", 0, 3, null)) == 1) {
                        return;
                    }
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        int n3 = nArray[n2];
                        stringArray[n2] = (String)PopupListener.access$0((PopupListener)this.this$1).sorter.getValueAt(n3, 4);
                        ++n2;
                    }
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.showStatus("Accessing network...");
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.setCursor(Cursor.getPredefinedCursor(3));
                    String string2 = PopupListener.access$0((PopupListener)this.this$1).ribComm.deleteObjects(stringArray, PopupListener.access$0((PopupListener)this.this$1).className);
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.showStatus("");
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.setCursor(Cursor.getPredefinedCursor(0));
                    if (!string2.equals("ok")) {
                        PopupListener.access$0((PopupListener)this.this$1).ribInterface.showAlert(string2);
                        return;
                    }
                    PopupListener.access$0(this.this$1).refreshTable();
                }
            });
            jPopupMenu.add(jMenuItem4);
            JMenu jMenu2 = new JMenu("Set status");
            jPopupMenu.add(jMenu2);
            JMenuItem jMenuItem5 = new JMenuItem("Approved");
            jMenuItem5.addActionListener(new ActionListener(n, this){
                private final /* synthetic */ PopupListener this$1;
                private final /* synthetic */ int val$rowCount;
                {
                    this.val$rowCount = n;
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    int n;
                    String[] stringArray = new String[this.val$rowCount];
                    int[] nArray = PopupListener.access$0((PopupListener)this.this$1).table.getSelectedRows();
                    if (nArray.length > 1 && (n = JOptionPane.showConfirmDialog(PopupListener.access$0((PopupListener)this.this$1).ribInterface, string = "Are you sure that you want to approve the " + nArray.length + " selected objects?", "Confirm delete", 0, 3, null)) == 1) {
                        return;
                    }
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        n = nArray[n2];
                        stringArray[n2] = (String)PopupListener.access$0((PopupListener)this.this$1).sorter.getValueAt(n, 4);
                        ++n2;
                    }
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.showStatus("Accessing network...");
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.setCursor(Cursor.getPredefinedCursor(3));
                    String string2 = PopupListener.access$0((PopupListener)this.this$1).ribComm.approveObjects(stringArray, PopupListener.access$0((PopupListener)this.this$1).className);
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.showStatus("");
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.setCursor(Cursor.getPredefinedCursor(0));
                    if (!string2.equals("ok")) {
                        PopupListener.access$0((PopupListener)this.this$1).ribInterface.showAlert(string2);
                        return;
                    }
                    PopupListener.access$0(this.this$1).refreshTable();
                }
            });
            jMenu2.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Not Approved");
            jMenuItem6.addActionListener(new ActionListener(n, this){
                private final /* synthetic */ PopupListener this$1;
                private final /* synthetic */ int val$rowCount;
                {
                    this.val$rowCount = n;
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    int n;
                    String[] stringArray = new String[this.val$rowCount];
                    int[] nArray = PopupListener.access$0((PopupListener)this.this$1).table.getSelectedRows();
                    if (nArray.length > 1 && (n = JOptionPane.showConfirmDialog(PopupListener.access$0((PopupListener)this.this$1).ribInterface, string = "Are you sure that you want to unapprove the " + nArray.length + " selected objects?", "Confirm delete", 0, 3, null)) == 1) {
                        return;
                    }
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        n = nArray[n2];
                        stringArray[n2] = (String)PopupListener.access$0((PopupListener)this.this$1).sorter.getValueAt(n, 4);
                        ++n2;
                    }
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.showStatus("Accessing network...");
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.setCursor(Cursor.getPredefinedCursor(3));
                    String string2 = PopupListener.access$0((PopupListener)this.this$1).ribComm.unapproveObjects(stringArray, PopupListener.access$0((PopupListener)this.this$1).className);
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.showStatus("");
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.setCursor(Cursor.getPredefinedCursor(0));
                    if (!string2.equals("ok")) {
                        PopupListener.access$0((PopupListener)this.this$1).ribInterface.showAlert(string2);
                        return;
                    }
                    PopupListener.access$0(this.this$1).refreshTable();
                }
            });
            jMenu2.add(jMenuItem6);
            JMenuItem jMenuItem7 = new JMenuItem("Attach File");
            jMenuItem7.addActionListener(new ActionListener(this){
                private final /* synthetic */ PopupListener this$1;
                {
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Container container = PopupListener.access$0(this.this$1).getParent();
                    while (!(container instanceof Frame)) {
                        container = ((Component)container).getParent();
                    }
                    int n = PopupListener.access$0((PopupListener)this.this$1).table.getSelectedRow();
                    String string = (String)PopupListener.access$0((PopupListener)this.this$1).sorter.getValueAt(n, 4);
                    RibFileChooser ribFileChooser = new RibFileChooser(PopupListener.access$0((PopupListener)this.this$1).ribInterface, PopupListener.access$0((PopupListener)this.this$1).ribComm, (Frame)container, PopupListener.access$0((PopupListener)this.this$1).className, string);
                    ribFileChooser.show();
                    PopupListener.access$0(this.this$1).refreshTable();
                }
            });
            jPopupMenu.add(jMenuItem7);
            if (n > 1) {
                jMenuItem7.setEnabled(false);
            }
            jPopupMenu.pack();
            if (mouseEvent.getY() - RibObjectBrowser.this.scrollpane.getViewport().getViewPosition().y + jPopupMenu.getPreferredSize().height > RibObjectBrowser.this.scrollpane.getViewport().getHeight()) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY() - jPopupMenu.getPreferredSize().height);
            } else {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
            jPopupMenu.revalidate();
        }
    }
}

