/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.nhse.rib.RibInterface;

public class RibHelpPane
extends JPanel {
    DefaultMutableTreeNode top;
    JTree docTree;
    JEditorPane htmlDisplay = new JEditorPane();
    RibInterface ribInterface;
    String separator = "^";

    RibHelpPane(RibInterface ribInterface) {
        this.ribInterface = ribInterface;
        this.top = new DefaultMutableTreeNode(new helpInfo("Welcome!", "welcome.html"));
        this.docTree = new JTree(this.top);
        this.setLayout(new BorderLayout());
        this.htmlDisplay.setEditable(false);
        this.htmlDisplay.setCursor(Cursor.getPredefinedCursor(2));
        this.addHelpNode("Manage Objects", "manage_objects.html");
        this.addHelpNode("Manage Catalog", "manage_catalog.html");
        this.addHelpNode("Interoperation", "interoperation.html");
        this.addHelpNode("Repository Properties", "repo_properties.html");
        this.addHelpNode("Errata", "errata.html");
        String string = "Manage Objects" + this.separator;
        this.addHelpNode(String.valueOf(string) + "Object Browser", "object_browser.html");
        this.addHelpNode(String.valueOf(string) + "Object Editor", "object_editor.html");
        string = String.valueOf(string) + "Object Browser" + this.separator;
        this.addHelpNode(String.valueOf(string) + "Creating Objects", "object_browser_create.html");
        this.addHelpNode(String.valueOf(string) + "Importing Objects", "object_browser_import.html");
        this.addHelpNode(String.valueOf(string) + "Editing Objects", "object_browser_edit.html");
        this.addHelpNode(String.valueOf(string) + "Deleting Objects", "object_browser_delete.html");
        this.addHelpNode(String.valueOf(string) + "Viewing Objects", "object_browser_view.html");
        this.addHelpNode(String.valueOf(string) + "Object Status", "object_browser_status.html");
        string = "Manage Catalog" + this.separator;
        this.addHelpNode(String.valueOf(string) + "View", "catalog_view.html");
        this.addHelpNode(String.valueOf(string) + "Templates", "catalog_templates.html");
        this.addHelpNode(String.valueOf(string) + "Primary Class", "catalog_primary_class.html");
        this.addHelpNode(String.valueOf(string) + "Primary Attribute", "catalog_primary_attribute.html");
        this.addHelpNode(String.valueOf(string) + "Object Approval", "catalog_object_approval.html");
        this.addHelpNode(String.valueOf(string) + "Joins", "catalog_joins.html");
        this.addHelpNode(String.valueOf(string) + "\"What's New?\"", "catalog_whats_new.html");
        string = "Interoperation" + this.separator;
        this.addHelpNode(String.valueOf(string) + "Creating Interoperations", "interop_create.html");
        this.addHelpNode(String.valueOf(string) + "Listing Objects", "interop_list.html");
        this.addHelpNode(String.valueOf(string) + "Interoperation Logs", "interop_log.html");
        this.addHelpNode(String.valueOf(string) + "Starting Updates", "interop_update.html");
        this.addHelpNode(String.valueOf(string) + "Deleting Interoperations", "interop_delete.html");
        this.addHelpNode(String.valueOf(string) + "Setting Update Intervals", "interop_intervals.html");
        string = "Repository Properties" + this.separator;
        this.addHelpNode(String.valueOf(string) + "Data Model Editor", "properties_data_model_editor.html");
        this.addHelpNode(String.valueOf(string) + "Repository Name", "properties_name.html");
        this.addHelpNode(String.valueOf(string) + "Repository Contact", "properties_contact.html");
        this.addHelpNode(String.valueOf(string) + "Repository Password", "properties_password.html");
        this.docTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                RibHelpPane.this.ribInterface.showStatus("Accessing network...");
                RibHelpPane.this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)RibHelpPane.this.docTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Object object = defaultMutableTreeNode.getUserObject();
                helpInfo helpInfo2 = (helpInfo)object;
                try {
                    RibHelpPane.this.displayURL(helpInfo2.helpURL);
                }
                catch (Exception exception) {}
                RibHelpPane.this.ribInterface.showStatus("");
                RibHelpPane.this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.docTree.setShowsRootHandles(false);
        this.docTree.expandRow(0);
        JScrollPane jScrollPane = new JScrollPane(this.docTree);
        jScrollPane.setViewportBorder(new EtchedBorder());
        this.setBorder(new EtchedBorder());
        this.add((Component)jScrollPane, "West");
        JScrollPane jScrollPane2 = new JScrollPane(this.htmlDisplay);
        this.add((Component)jScrollPane2, "Center");
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                RibHelpPane.this.docTree.addSelectionRow(0);
            }
        });
    }

    public void addHelpNode(String string, String string2) {
        if (string.indexOf(this.separator) == -1) {
            this.top.add(new DefaultMutableTreeNode(new helpInfo(string, string2)));
        } else {
            String string3 = string.substring(0, string.lastIndexOf(this.separator));
            Enumeration<TreeNode> enumeration = this.top.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                helpInfo helpInfo2 = (helpInfo)defaultMutableTreeNode.getUserObject();
                if (!helpInfo2.name.equals(string3)) continue;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(new helpInfo(string, string2)));
                break;
            }
        }
    }

    private void displayURL(String string) {
        try {
            this.htmlDisplay.setPage(string);
        }
        catch (Exception exception) {
            this.ribInterface.showAlert(exception.toString());
        }
    }

    public void gotoURL(String string) {
        boolean bl = false;
        Enumeration<TreeNode> enumeration = this.top.breadthFirstEnumeration();
        while (enumeration.hasMoreElements() && !bl) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            helpInfo helpInfo2 = (helpInfo)defaultMutableTreeNode.getUserObject();
            if (!string.equalsIgnoreCase(helpInfo2.helpURL.toString())) continue;
            Object[] objectArray = defaultMutableTreeNode.getPath();
            TreePath treePath = new TreePath(objectArray);
            this.docTree.setSelectionPath(treePath);
            this.displayURL(helpInfo2.helpURL);
            bl = true;
        }
    }

    private class helpInfo {
        public String name;
        public String helpURL;

        public helpInfo(String string, String string2) {
            this.name = string;
            this.helpURL = String.valueOf(RibHelpPane.this.ribInterface.ribUrl) + "/doc/" + string2;
        }

        public String toString() {
            return this.name.substring(this.name.lastIndexOf(RibHelpPane.this.separator) + 1);
        }
    }
}

