/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibAttribute;
import org.nhse.rib.RibClass;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibConfig;
import org.nhse.rib.RibInterface;
import org.nhse.rib.RibObjectEditor;
import org.nhse.rib.RibRelationship;
import org.nhse.rib.RibUtil;
import org.nhse.rib.RibVocabularyTerm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RibConfigEditor
extends JPanel {
    private RibConfig ribConfig;
    private RibComm ribComm;
    private RibInterface ribInterface;
    private JTree jtree = null;
    private JScrollPane jsp = null;
    private DefaultMutableTreeNode rigObjectNode = null;
    public JButton saveButton = null;
    private JButton cancelButton = null;
    private JButton importButton = null;
    private JPanel mainPanel = this;
    private boolean _dirty;

    RibConfigEditor(RibConfig ribConfig, RibComm ribComm, RibInterface ribInterface) {
        this.ribConfig = ribConfig;
        this.ribComm = ribComm;
        this.ribInterface = ribInterface;
        this.init();
    }

    static /* synthetic */ void access$1(RibConfigEditor ribConfigEditor) {
        ribConfigEditor.saveConfiguration();
    }

    static /* synthetic */ boolean access$12(RibConfigEditor ribConfigEditor, String string) {
        return ribConfigEditor.checkFieldName(string);
    }

    static /* synthetic */ boolean access$4(RibConfigEditor ribConfigEditor) {
        return ribConfigEditor._dirty;
    }

    static /* synthetic */ RibConfig access$6(RibConfigEditor ribConfigEditor) {
        return ribConfigEditor.ribConfig;
    }

    public boolean am_dirty() {
        return this._dirty;
    }

    private boolean checkFieldName(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string.toUpperCase());
        if (!Character.isLetter(stringCharacterIterator.first())) {
            JOptionPane.showMessageDialog(this.mainPanel, "Field name must start with an alphabetic character");
            return false;
        }
        boolean bl = false;
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (Character.isWhitespace(c)) {
                bl = true;
            }
            c = stringCharacterIterator.next();
        }
        if (bl) {
            JOptionPane.showMessageDialog(this.mainPanel, "Field name should not contain any whitespace characters");
            return false;
        }
        return true;
    }

    private void init() {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.setLayout(new BorderLayout());
        this.setBorder(new EtchedBorder());
        this.removeAll();
        if (this.ribConfig.getClasses().size() == 0) {
            JLabel jLabel = new JLabel("  Error: " + this.ribConfig.errorMsg);
            this.add((Component)jLabel, "Center");
            return;
        }
        Vector<ClassTreeNode> vector = new Vector<ClassTreeNode>();
        Enumeration enumeration = this.ribConfig.getClasses(true).elements();
        while (enumeration.hasMoreElements()) {
            object5 = (RibClass)enumeration.nextElement();
            vector.addElement(new ClassTreeNode((RibClass)object5));
        }
        object5 = vector.elements();
        while (object5.hasMoreElements()) {
            object4 = (ClassTreeNode)object5.nextElement();
            object3 = this.ribConfig.getClass(((DefaultMutableTreeNode)object4).toString());
            object2 = ((RibClass)object3).getExtends();
            object = vector.elements();
            while (object.hasMoreElements()) {
                serializable = (ClassTreeNode)object.nextElement();
                if (!serializable.toString().equals(object2)) continue;
                serializable.getSubclasses().add((MutableTreeNode)object4);
            }
        }
        object4 = vector.elements();
        while (object4.hasMoreElements()) {
            object3 = (ClassTreeNode)object4.nextElement();
            if (!((DefaultMutableTreeNode)object3).toString().equals("RigObject")) continue;
            this.rigObjectNode = object3;
            break;
        }
        this.jtree = new JTree(this.rigObjectNode);
        this.jtree.addMouseListener(new PopupListener());
        this.jtree.getSelectionModel().setSelectionMode(1);
        this.jtree.setToolTipText("Right click a node to edit its properties");
        this.jtree.setModel(new DefaultTreeModel(this.rigObjectNode, true));
        object3 = vector.elements();
        while (object3.hasMoreElements()) {
            object2 = (ClassTreeNode)object3.nextElement();
            object = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent();
            if (object == null) continue;
            serializable = new TreePath(((DefaultMutableTreeNode)object).getPath());
            this.jtree.expandPath((TreePath)serializable);
        }
        this.jsp = new JScrollPane(this.jtree);
        this.jsp.setPreferredSize(new Dimension(100, 100));
        this.add((Component)this.jsp, "Center");
        this.saveButton = new JButton("  Save  ");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(RibConfigEditor.this.mainPanel, "Are you sure that you want to save this data model?", "Confirm", 0);
                if (n != 0) {
                    return;
                }
                SwingUtilities.invokeLater(new Thread(RibConfigEditor.this){
                    private final /* synthetic */ RibConfigEditor this$0;
                    {
                        this.this$0 = ribConfigEditor;
                    }

                    public void run() {
                        RibConfigEditor.access$1(this.this$0);
                    }
                });
            }
        });
        this.saveButton.addMouseListener(new ButtonPushMouseListener(this.saveButton));
        this.saveButton.setToolTipText("Save changes and exit data model editor");
        this.cancelButton = new JButton("  Cancel  ");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RibConfigEditor.this.ribInterface.initPropertiesPanel();
            }
        });
        this.cancelButton.addMouseListener(new ButtonPushMouseListener(this.cancelButton));
        this.cancelButton.setToolTipText("Cancel without saving");
        this.importButton = new JButton("  Import...  ");
        this.importButton.setToolTipText("Import a data model from a URL");
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Reader reader;
                int n = JOptionPane.showConfirmDialog(RibConfigEditor.this.mainPanel, "Importing a data model will replace the one currently being\nedited. Are you sure that you want to take this action?", "Confirm", 0);
                if (n != 0) {
                    return;
                }
                String string = (String)JOptionPane.showInputDialog(RibConfigEditor.this.mainPanel, "URL : ", null, 3, null, null, null);
                if (string == null) {
                    return;
                }
                string.trim();
                if (string.length() == 0) {
                    return;
                }
                if (string.indexOf("://") == -1) {
                    string = "http://" + string;
                }
                try {
                    new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    JOptionPane.showMessageDialog(RibConfigEditor.this.mainPanel, "The url you supplied was not formatted properly.\nProperly formatted urls have the form protocol://machine/path", "Alert", 0);
                    return;
                }
                try {
                    reader = RibConfigEditor.this.ribComm.doProxy(string);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(RibConfigEditor.this.mainPanel, exception.toString(), "Alert", 0);
                    return;
                }
                try {
                    RibConfig ribConfig = new RibConfig(reader);
                    ribConfig.parse();
                    if (ribConfig.getClasses().size() == 0) {
                        throw new Exception();
                    }
                    RibConfigEditor.this._dirty = true;
                    RibConfigEditor.this.ribConfig = ribConfig;
                    RibConfigEditor.this.init();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(RibConfigEditor.this.mainPanel, "Invalid data model.", "Alert", 0);
                    return;
                }
            }
        });
        this.importButton.addMouseListener(new ButtonPushMouseListener(this.importButton));
        object2 = new HelpButton("properties_data_model_editor.html", this.ribInterface);
        ((JComponent)object2).setMaximumSize(new Dimension(((JComponent)object2).getPreferredSize().width, this.saveButton.getPreferredSize().height));
        ((JComponent)object2).setToolTipText("Display help on the data model editor");
        object = new JToolBar();
        ((JToolBar)object).setFloatable(false);
        ((JComponent)object).setBorder(new BevelBorder(1));
        ((Container)object).add(Box.createHorizontalStrut(2));
        ((Container)object).add(this.saveButton);
        ((Container)object).add(Box.createHorizontalStrut(2));
        ((Container)object).add(this.cancelButton);
        ((Container)object).add(Box.createHorizontalStrut(2));
        ((Container)object).add(this.importButton);
        ((Container)object).add(Box.createHorizontalStrut(2));
        ((Container)object).add((Component)object2);
        this.add((Component)object, "North");
        this.jtree.revalidate();
        this.saveButton.revalidate();
        this.cancelButton.revalidate();
        this.importButton.revalidate();
    }

    private TXElement[] makeTermElements(RibVocabularyTerm ribVocabularyTerm) {
        Vector vector = ribVocabularyTerm.getChildren();
        TXElement[] tXElementArray = new TXElement[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            RibVocabularyTerm ribVocabularyTerm2 = (RibVocabularyTerm)vector.elementAt(n);
            TXElement tXElement = new TXElement("term");
            tXElement.setAttribute("value", ribVocabularyTerm2.getTerm());
            tXElementArray[n] = tXElement;
            if (ribVocabularyTerm2.getChildren().size() > 0) {
                TXElement[] tXElementArray2 = this.makeTermElements(ribVocabularyTerm2);
                int n2 = 0;
                while (n2 < tXElementArray2.length) {
                    tXElement.appendChild((Node)tXElementArray2[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return tXElementArray;
    }

    private VocabularyTreeNode[] makeVocabularyTreeNodes(Vector vector) {
        VocabularyTreeNode[] vocabularyTreeNodeArray = new VocabularyTreeNode[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            RibVocabularyTerm ribVocabularyTerm = (RibVocabularyTerm)vector.elementAt(n);
            vocabularyTreeNodeArray[n] = new VocabularyTreeNode(ribVocabularyTerm);
            VocabularyTreeNode[] vocabularyTreeNodeArray2 = this.makeVocabularyTreeNodes(ribVocabularyTerm.getChildren());
            if (vocabularyTreeNodeArray2.length > 0) {
                vocabularyTreeNodeArray[n].setAllowsChildren(true);
            }
            int n2 = 0;
            while (n2 < vocabularyTreeNodeArray2.length) {
                vocabularyTreeNodeArray[n].add(vocabularyTreeNodeArray2[n2]);
                ++n2;
            }
            ++n;
        }
        return vocabularyTreeNodeArray;
    }

    private void saveConfiguration() {
        Object object;
        JPanel jPanel = this.ribInterface.objectsPanel;
        if (jPanel.getComponentCount() > 0 && jPanel.getComponent(0) instanceof RibObjectEditor) {
            int n = JOptionPane.showConfirmDialog(this.mainPanel, "Saving this data model will cancel the object that is currently\nbeing edited in the \"Manage Objects\" tab. Are you sure that you want to proceed?", "Question", 2, 3);
            if (n != 0) {
                return;
            }
            jPanel.removeAll();
        } else if (jPanel.getComponentCount() > 0) {
            jPanel.removeAll();
        }
        TXDocument tXDocument = new TXDocument();
        try {
            tXDocument.setVersion("1.0");
            tXDocument.setStandalone("yes");
            object = tXDocument.createElement("rib");
            object.setAttribute("version", RibUtil.getRibVersion());
            tXDocument.appendChild((Node)object);
            Enumeration enumeration = this.ribConfig.getClasses().elements();
            while (enumeration.hasMoreElements()) {
                TXElement[] tXElementArray;
                Object object2;
                Object object3;
                RibClass ribClass = (RibClass)enumeration.nextElement();
                Element element = tXDocument.createElement("class");
                element.setAttribute("name", ribClass.getName());
                element.setAttribute("extends", ribClass.getExtends());
                Enumeration enumeration2 = ribClass.getNativeAttributes().elements();
                while (enumeration2.hasMoreElements()) {
                    object3 = (RibAttribute)enumeration2.nextElement();
                    object2 = new TXElement("attribute");
                    object2.setAttribute("name", ((RibAttribute)object3).getName());
                    object2.setAttribute("alt", ((RibAttribute)object3).getAlt());
                    object2.setAttribute("cardinality", ((RibAttribute)object3).getCardinality());
                    object2.setAttribute("display", ((RibAttribute)object3).getDisplay());
                    object2.setAttribute("dtype", ((RibAttribute)object3).getDtype());
                    object2.setAttribute("status", ((RibAttribute)object3).getStatus());
                    if (((RibAttribute)object3).hasVocabulary()) {
                        tXElementArray = this.makeTermElements(((RibAttribute)object3).getVocabulary());
                        int n = 0;
                        while (n < tXElementArray.length) {
                            object2.appendChild((Node)tXElementArray[n]);
                            ++n;
                        }
                    }
                    if (((RibAttribute)object3).getDesc() != null) {
                        object2.appendChild((Node)tXDocument.createTextNode(((RibAttribute)object3).getDesc()));
                    }
                    element.appendChild((Node)object2);
                }
                object3 = ribClass.getNativeRelationships().elements();
                while (object3.hasMoreElements()) {
                    object2 = (RibRelationship)object3.nextElement();
                    tXElementArray = new TXElement("relationship");
                    tXElementArray.setAttribute("name", ((RibRelationship)object2).getName());
                    tXElementArray.setAttribute("alt", ((RibRelationship)object2).getAlt());
                    tXElementArray.setAttribute("cardinality", ((RibRelationship)object2).getCardinality());
                    tXElementArray.setAttribute("display", ((RibRelationship)object2).getDisplay());
                    tXElementArray.setAttribute("status", ((RibRelationship)object2).getStatus());
                    if (((RibRelationship)object2).getDesc() != null) {
                        tXElementArray.appendChild((Node)tXDocument.createTextNode(((RibRelationship)object2).getDesc()));
                    }
                    element.appendChild((Node)tXElementArray);
                }
                object.appendChild(element);
            }
        }
        catch (Exception exception) {
            this.ribInterface.showAlert(exception.toString());
            return;
        }
        this.ribInterface.showStatus("Accessing network...");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
        try {
            object = this.ribComm.saveConfig(tXDocument);
        }
        catch (Exception exception) {
            object = exception.toString();
        }
        if (((String)object).equals("ok")) {
            this.ribInterface.initPropertiesPanel();
        } else {
            this.ribInterface.showAlert((String)object);
        }
        this.ribInterface.showStatus("");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
    }

    class ClassTreeNode
    extends DefaultMutableTreeNode {
        RibClass ribClass;
        DefaultMutableTreeNode subclasses;

        ClassTreeNode(RibClass ribClass) {
            VocabularyTreeNode[] vocabularyTreeNodeArray;
            Cloneable cloneable;
            Object object;
            this.ribClass = ribClass;
            this.setUserObject(ribClass.getName());
            AttributeListNode attributeListNode = new AttributeListNode();
            RelationshipListNode relationshipListNode = new RelationshipListNode();
            this.subclasses = new SubclassListNode();
            Enumeration enumeration = ribClass.getNativeAttributes(true).elements();
            while (enumeration.hasMoreElements()) {
                object = (RibAttribute)enumeration.nextElement();
                RibConfigEditor ribConfigEditor2 = RibConfigEditor.this;
                ribConfigEditor2.getClass();
                cloneable = ribConfigEditor2.new AttributeTreeNode((RibAttribute)object);
                if (((RibAttribute)object).hasVocabulary()) {
                    vocabularyTreeNodeArray = RibConfigEditor.this.makeVocabularyTreeNodes(((RibAttribute)object).getVocabulary().getChildren());
                    int n = 0;
                    while (n < vocabularyTreeNodeArray.length) {
                        ((DefaultMutableTreeNode)cloneable).setAllowsChildren(true);
                        ((DefaultMutableTreeNode)cloneable).add(vocabularyTreeNodeArray[n]);
                        ++n;
                    }
                }
                attributeListNode.add((MutableTreeNode)((Object)cloneable));
            }
            object = ribClass.getNativeRelationships(true).elements();
            while (object.hasMoreElements()) {
                cloneable = (RibRelationship)object.nextElement();
                RibConfigEditor ribConfigEditor3 = RibConfigEditor.this;
                ribConfigEditor3.getClass();
                vocabularyTreeNodeArray = ribConfigEditor3.new RelationshipTreeNode((RibRelationship)cloneable);
                relationshipListNode.add((MutableTreeNode)vocabularyTreeNodeArray);
            }
            this.add(attributeListNode);
            this.add(relationshipListNode);
            this.add(this.subclasses);
        }

        public RibClass getRibClass() {
            return this.ribClass;
        }

        public DefaultMutableTreeNode getSubclasses() {
            return this.subclasses;
        }
    }

    class AttributeTreeNode
    extends DefaultMutableTreeNode {
        RibAttribute ribAttribute;

        AttributeTreeNode(RibAttribute ribAttribute) {
            this.ribAttribute = ribAttribute;
            this.setUserObject(ribAttribute.getName());
            this.setAllowsChildren(false);
        }
    }

    class RelationshipTreeNode
    extends DefaultMutableTreeNode {
        RibRelationship ribRelationship;

        RelationshipTreeNode(RibRelationship ribRelationship) {
            this.ribRelationship = ribRelationship;
            this.setUserObject(ribRelationship.getName());
            this.setAllowsChildren(false);
        }
    }

    class AttributeListNode
    extends DefaultMutableTreeNode {
        AttributeListNode() {
            this.setUserObject("Attributes");
        }
    }

    class RelationshipListNode
    extends DefaultMutableTreeNode {
        RelationshipListNode() {
            this.setUserObject("Relationships");
        }
    }

    class SubclassListNode
    extends DefaultMutableTreeNode {
        SubclassListNode() {
            this.setUserObject("Subclasses");
        }
    }

    class VocabularyTreeNode
    extends DefaultMutableTreeNode {
        RibVocabularyTerm ribVocabularyTerm;

        VocabularyTreeNode(RibVocabularyTerm ribVocabularyTerm) {
            this.ribVocabularyTerm = ribVocabularyTerm;
            this.setUserObject(ribVocabularyTerm.getTerm());
            this.setAllowsChildren(false);
        }

        public RibVocabularyTerm getRibVocabularyTerm() {
            return this.ribVocabularyTerm;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        static /* synthetic */ RibConfigEditor access$0(PopupListener popupListener) {
            return popupListener.RibConfigEditor.this;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath = RibConfigEditor.this.jtree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            RibConfigEditor.this.jtree.addSelectionPath(treePath);
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TreePath treePath = RibConfigEditor.this.jtree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            TreePath treePath = RibConfigEditor.this.jtree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (defaultMutableTreeNode instanceof ClassTreeNode) {
                JMenuItem jMenuItem = new JMenuItem("Delete this class");
                if (defaultMutableTreeNode == RibConfigEditor.this.rigObjectNode) {
                    jMenuItem.setEnabled(false);
                }
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(defaultMutableTreeNode, this){
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$node = defaultMutableTreeNode;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object;
                        Object object2;
                        Object object3;
                        int n = JOptionPane.showConfirmDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Are you sure that you want to delete this class?", "Confirm Delete", 0);
                        if (n != 0) {
                            return;
                        }
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        RibClass ribClass = ((ClassTreeNode)this.val$node).ribClass;
                        Vector<String> vector = new Vector<String>();
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getModel();
                        defaultTreeModel.removeNodeFromParent(this.val$node);
                        RibConfigEditor.access$6(PopupListener.access$0(this.this$1)).removeClass(ribClass);
                        Enumeration<TreeNode> enumeration = this.val$node.depthFirstEnumeration();
                        while (enumeration.hasMoreElements()) {
                            object3 = (DefaultMutableTreeNode)enumeration.nextElement();
                            if (!(object3 instanceof ClassTreeNode)) continue;
                            object2 = ((ClassTreeNode)object3).ribClass;
                            vector.addElement(((RibClass)object2).getName());
                            RibConfigEditor.access$6(PopupListener.access$0(this.this$1)).removeClass((RibClass)object2);
                        }
                        object3 = RibConfigEditor.access$11(PopupListener.access$0(this.this$1)).depthFirstEnumeration();
                        while (object3.hasMoreElements()) {
                            object2 = (DefaultMutableTreeNode)object3.nextElement();
                            if (!(object2 instanceof RelationshipTreeNode) || vector.indexOf(((RibRelationship)(object = ((RelationshipTreeNode)object2).ribRelationship)).getDest()) == -1) continue;
                            defaultTreeModel.removeNodeFromParent((MutableTreeNode)object2);
                        }
                        object2 = RibConfigEditor.access$6(PopupListener.access$0(this.this$1)).getClasses().elements();
                        while (object2.hasMoreElements()) {
                            object = (RibClass)object2.nextElement();
                            Enumeration<E> enumeration2 = ((RibClass)object).getRelationships().elements();
                            while (enumeration2.hasMoreElements()) {
                                RibRelationship ribRelationship = (RibRelationship)enumeration2.nextElement();
                                if (vector.indexOf(ribRelationship.getDest()) == -1) continue;
                                ((RibClass)object).removeRelationship(ribRelationship);
                            }
                        }
                    }
                });
            } else if (defaultMutableTreeNode instanceof AttributeTreeNode) {
                RibAttribute ribAttribute = ((AttributeTreeNode)defaultMutableTreeNode).ribAttribute;
                JMenuItem jMenuItem = new JMenuItem("Description...");
                jMenuItem.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Container container = PopupListener.access$0(this.this$1).getParent();
                        while (!(container instanceof Frame)) {
                            container = ((Component)container).getParent();
                        }
                        JDialog jDialog = new JDialog((Frame)container, "Description of " + this.val$ra.getName(), true);
                        jDialog.getContentPane().setLayout(new BorderLayout());
                        JToolBar jToolBar = new JToolBar();
                        ((Container)jToolBar).setLayout(new FlowLayout());
                        JButton jButton = new JButton("  Ok  ");
                        jButton.setBorder(new BevelBorder(0));
                        JButton jButton2 = new JButton("  Cancel  ");
                        jButton2.setBorder(new BevelBorder(0));
                        JTextArea jTextArea = new JTextArea(3, 30);
                        jTextArea.setLineWrap(true);
                        jTextArea.setWrapStyleWord(true);
                        jButton.addActionListener(new ActionListener(jDialog, jTextArea, this.val$ra, this.this$1){
                            private final /* synthetic */ JDialog val$jd;
                            private final /* synthetic */ PopupListener this$1;
                            private final /* synthetic */ RibAttribute val$ra;
                            private final /* synthetic */ JTextArea val$jta;
                            {
                                this.val$jd = jDialog;
                                this.val$jta = jTextArea;
                                this.val$ra = ribAttribute;
                                this.this$1 = popupListener;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                String string = this.val$jta.getText();
                                string.trim();
                                if (string != null && !string.equals(this.val$ra.getDesc())) {
                                    RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                                }
                                this.val$ra.setDesc(string);
                                ((Component)this.val$jd).setVisible(false);
                                this.val$jd.dispose();
                            }
                        });
                        jButton2.addActionListener(new ActionListener(jDialog){
                            private final /* synthetic */ JDialog val$jd;
                            {
                                this.val$jd = jDialog;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                ((Component)this.val$jd).setVisible(false);
                                this.val$jd.dispose();
                            }
                        });
                        jTextArea.setText(this.val$ra.getDesc());
                        jTextArea.setCaretPosition(0);
                        jToolBar.setFloatable(false);
                        jToolBar.add(jButton);
                        jToolBar.add(jButton2);
                        JScrollPane jScrollPane = new JScrollPane(jTextArea);
                        jDialog.getContentPane().add((Component)jToolBar, "South");
                        jDialog.getContentPane().add((Component)jScrollPane, "Center");
                        jDialog.pack();
                        jDialog.setLocationRelativeTo(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                        jDialog.show();
                        jTextArea.requestFocus();
                        jDialog.addWindowListener(new WindowAdapter(jDialog){
                            private final /* synthetic */ JDialog val$jd;
                            {
                                this.val$jd = jDialog;
                            }

                            public void windowClosing(WindowEvent windowEvent) {
                                ((Component)this.val$jd).setVisible(false);
                                this.val$jd.dispose();
                            }
                        });
                    }
                });
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem("Alternate name...");
                jMenuItem2.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = (String)JOptionPane.showInputDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Alternate name to show in catalog:", null, 3, null, null, this.val$ra.getAlt());
                        if (string != null && !string.equals(this.val$ra.getAlt())) {
                            RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                            this.val$ra.setAlt(string);
                        }
                    }
                });
                jPopupMenu.add(jMenuItem2);
                JMenu jMenu = new JMenu("Status");
                ButtonGroup buttonGroup = new ButtonGroup();
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("optional");
                JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("required");
                if (ribAttribute.getStatus().equals("opt")) {
                    jRadioButtonMenuItem.setSelected(true);
                } else {
                    jRadioButtonMenuItem2.setSelected(true);
                }
                buttonGroup.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem);
                buttonGroup.add(jRadioButtonMenuItem2);
                jMenu.add(jRadioButtonMenuItem2);
                jRadioButtonMenuItem.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ PopupListener this$1;
                    private final /* synthetic */ RibAttribute val$ra;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$ra.setStatus("opt");
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                    }
                });
                jRadioButtonMenuItem2.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ PopupListener this$1;
                    private final /* synthetic */ RibAttribute val$ra;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.val$ra.getStatus().equals("opt")) {
                            String string = "Making this change can cause previously created\nobjects to not have a value for a required field.\nAre you sure that you want to make this change?\n";
                            int n = JOptionPane.showConfirmDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), string, "Confirm change", 0);
                            if (n != 0) {
                                return;
                            }
                            RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                            this.val$ra.setStatus("req");
                        }
                    }
                });
                jPopupMenu.add(jMenu);
                JMenu jMenu2 = new JMenu("Display");
                ButtonGroup buttonGroup2 = new ButtonGroup();
                JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("show in catalog");
                JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem("don't show in catalog");
                if (ribAttribute.getDisplay().equals("noshow")) {
                    jRadioButtonMenuItem4.setSelected(true);
                } else {
                    jRadioButtonMenuItem3.setSelected(true);
                }
                buttonGroup2.add(jRadioButtonMenuItem3);
                jMenu2.add(jRadioButtonMenuItem3);
                buttonGroup2.add(jRadioButtonMenuItem4);
                jMenu2.add(jRadioButtonMenuItem4);
                jRadioButtonMenuItem4.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$ra.setDisplay("noshow");
                    }
                });
                jRadioButtonMenuItem3.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$ra.setDisplay("show");
                    }
                });
                jPopupMenu.add(jMenu2);
                JMenu jMenu3 = new JMenu("Cardinality");
                ButtonGroup buttonGroup3 = new ButtonGroup();
                JRadioButtonMenuItem jRadioButtonMenuItem5 = new JRadioButtonMenuItem("multiple");
                JRadioButtonMenuItem jRadioButtonMenuItem6 = new JRadioButtonMenuItem("single");
                if (ribAttribute.getCardinality().equals("single")) {
                    jRadioButtonMenuItem6.setSelected(true);
                } else {
                    jRadioButtonMenuItem5.setSelected(true);
                }
                buttonGroup3.add(jRadioButtonMenuItem5);
                jMenu3.add(jRadioButtonMenuItem5);
                buttonGroup3.add(jRadioButtonMenuItem6);
                jMenu3.add(jRadioButtonMenuItem6);
                jRadioButtonMenuItem5.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$ra.setCardinality("mult");
                    }
                });
                jRadioButtonMenuItem6.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$ra.setCardinality("single");
                    }
                });
                jPopupMenu.add(jMenu3);
                JMenu jMenu4 = new JMenu("Data type");
                ButtonGroup buttonGroup4 = new ButtonGroup();
                JRadioButtonMenuItem jRadioButtonMenuItem7 = new JRadioButtonMenuItem("Text");
                JRadioButtonMenuItem jRadioButtonMenuItem8 = new JRadioButtonMenuItem("String");
                JRadioButtonMenuItem jRadioButtonMenuItem9 = new JRadioButtonMenuItem("URL");
                JRadioButtonMenuItem jRadioButtonMenuItem10 = new JRadioButtonMenuItem("Email");
                JRadioButtonMenuItem jRadioButtonMenuItem11 = new JRadioButtonMenuItem("Date");
                if (ribAttribute.getDtype().equals("string")) {
                    jRadioButtonMenuItem8.setSelected(true);
                } else if (ribAttribute.getDtype().equals("url")) {
                    jRadioButtonMenuItem9.setSelected(true);
                } else if (ribAttribute.getDtype().equals("email")) {
                    jRadioButtonMenuItem10.setSelected(true);
                } else if (ribAttribute.getDtype().equals("date")) {
                    jRadioButtonMenuItem11.setSelected(true);
                } else {
                    jRadioButtonMenuItem7.setSelected(true);
                }
                jRadioButtonMenuItem7.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$ra.setDtype("text");
                    }
                });
                jRadioButtonMenuItem8.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$ra.setDtype("string");
                    }
                });
                jRadioButtonMenuItem9.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$ra.setDtype("url");
                    }
                });
                jRadioButtonMenuItem10.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$ra.setDtype("email");
                    }
                });
                jRadioButtonMenuItem11.addActionListener(new ActionListener(ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$ra.setDtype("date");
                    }
                });
                buttonGroup4.add(jRadioButtonMenuItem7);
                jMenu4.add(jRadioButtonMenuItem7);
                buttonGroup4.add(jRadioButtonMenuItem8);
                jMenu4.add(jRadioButtonMenuItem8);
                buttonGroup4.add(jRadioButtonMenuItem9);
                jMenu4.add(jRadioButtonMenuItem9);
                buttonGroup4.add(jRadioButtonMenuItem10);
                jMenu4.add(jRadioButtonMenuItem10);
                buttonGroup4.add(jRadioButtonMenuItem11);
                jMenu4.add(jRadioButtonMenuItem11);
                jPopupMenu.add(jMenu4);
                jPopupMenu.addSeparator();
                JMenuItem jMenuItem3 = new JMenuItem("Add a vocabulary term");
                jMenuItem3.addActionListener(new ActionListener(defaultMutableTreeNode, ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ PopupListener this$1;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    {
                        this.val$node = defaultMutableTreeNode;
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void actionPerformed(ActionEvent var1_1) {
                        var2_2 = new Vector<Object>();
                        var3_3 = this.val$node.children();
                        while (var3_3.hasMoreElements()) {
                            var4_4 = var3_3.nextElement();
                            var2_2.addElement(var4_4.toString());
                        }
                        var4_4 = RibUtil.getAlphanumericsymbolDialogInput("New vocabulary term:", 128, RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                        if (var4_4 != null) ** GOTO lbl14
                        return;
lbl-1000:
                        // 1 sources

                        {
                            JOptionPane.showMessageDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Please choose a term that is not already in use");
                            var4_4 = RibUtil.getAlphanumericsymbolDialogInput("New vocabulary term:", 128, RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                            if (var4_4 != null) continue;
                            return;
lbl14:
                            // 2 sources

                            ** while (var2_2.indexOf((Object)var4_4) != -1)
                        }
lbl15:
                        // 1 sources

                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        if (this.val$ra.getVocabulary() == null) {
                            this.val$ra.setVocabulary(new RibVocabularyTerm("root"));
                        }
                        var5_5 = new RibVocabularyTerm((String)var4_4);
                        v0 = PopupListener.access$0(this.this$1);
                        v0.getClass();
                        var6_6 = v0.new VocabularyTreeNode(var5_5);
                        var2_2.addElement(var4_4);
                        this.val$ra.getVocabulary().addChild(var5_5);
                        var7_7 = RibUtil.sortStringVector(var2_2).indexOf(var4_4);
                        var8_8 = (DefaultTreeModel)RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getModel();
                        this.val$node.setAllowsChildren(true);
                        var8_8.insertNodeInto(var6_6, this.val$node, var7_7);
                        RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).expandPath(RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getSelectionPath());
                    }
                });
                jPopupMenu.add(jMenuItem3);
                jPopupMenu.addSeparator();
                JMenuItem jMenuItem4 = new JMenuItem("Delete this attribute");
                jMenuItem4.addActionListener(new ActionListener(defaultMutableTreeNode, ribAttribute, this){
                    private final /* synthetic */ RibAttribute val$ra;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$node = defaultMutableTreeNode;
                        this.val$ra = ribAttribute;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = JOptionPane.showConfirmDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Are you sure that you want to delete this attribute?", "Confirm Delete", 0);
                        if (n != 0) {
                            return;
                        }
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        ClassTreeNode classTreeNode = (ClassTreeNode)this.val$node.getParent().getParent();
                        RibClass ribClass = classTreeNode.ribClass;
                        ribClass.removeAttribute(this.val$ra);
                        ((DefaultTreeModel)RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getModel()).removeNodeFromParent(this.val$node);
                    }
                });
                jPopupMenu.add(jMenuItem4);
                if (ribAttribute.getName().equals("Name") && defaultMutableTreeNode.getParent().getParent() == RibConfigEditor.this.rigObjectNode) {
                    jPopupMenu.getComponent(0).setEnabled(false);
                    jPopupMenu.getComponent(2).setEnabled(false);
                    jPopupMenu.getComponent(4).setEnabled(false);
                    jPopupMenu.getComponent(5).setEnabled(false);
                    jPopupMenu.getComponent(6).setEnabled(false);
                    jPopupMenu.getComponent(7).setEnabled(false);
                    jPopupMenu.getComponent(9).setEnabled(false);
                }
            } else if (defaultMutableTreeNode instanceof RelationshipTreeNode) {
                RibRelationship ribRelationship = ((RelationshipTreeNode)defaultMutableTreeNode).ribRelationship;
                JMenuItem jMenuItem = new JMenuItem("Description...");
                jMenuItem.addActionListener(new ActionListener(ribRelationship, this){
                    private final /* synthetic */ RibRelationship val$rr;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$rr = ribRelationship;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Container container = PopupListener.access$0(this.this$1).getParent();
                        while (!(container instanceof Frame)) {
                            container = ((Component)container).getParent();
                        }
                        JDialog jDialog = new JDialog((Frame)container, "Description of " + this.val$rr.getName(), true);
                        jDialog.getContentPane().setLayout(new BorderLayout());
                        JToolBar jToolBar = new JToolBar();
                        ((Container)jToolBar).setLayout(new FlowLayout());
                        JButton jButton = new JButton("  Ok  ");
                        jButton.setBorder(new BevelBorder(0));
                        JButton jButton2 = new JButton("  Cancel  ");
                        jButton2.setBorder(new BevelBorder(0));
                        JTextArea jTextArea = new JTextArea(3, 30);
                        jTextArea.setLineWrap(true);
                        jTextArea.setWrapStyleWord(true);
                        jButton.addActionListener(new ActionListener(jDialog, jTextArea, this.val$rr, this.this$1){
                            private final /* synthetic */ JDialog val$jd;
                            private final /* synthetic */ PopupListener this$1;
                            private final /* synthetic */ RibRelationship val$rr;
                            private final /* synthetic */ JTextArea val$jta;
                            {
                                this.val$jd = jDialog;
                                this.val$jta = jTextArea;
                                this.val$rr = ribRelationship;
                                this.this$1 = popupListener;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                String string = this.val$jta.getText();
                                if (string != null && !string.equals(this.val$rr.getDesc())) {
                                    RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                                }
                                string.trim();
                                this.val$rr.setDesc(string);
                                ((Component)this.val$jd).setVisible(false);
                                this.val$jd.dispose();
                            }
                        });
                        jButton2.addActionListener(new ActionListener(jDialog){
                            private final /* synthetic */ JDialog val$jd;
                            {
                                this.val$jd = jDialog;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                ((Component)this.val$jd).setVisible(false);
                                this.val$jd.dispose();
                            }
                        });
                        jTextArea.setText(this.val$rr.getDesc());
                        jToolBar.setFloatable(false);
                        jToolBar.add(jButton);
                        jToolBar.add(jButton2);
                        JScrollPane jScrollPane = new JScrollPane(jTextArea);
                        jDialog.getContentPane().add((Component)jToolBar, "South");
                        jDialog.getContentPane().add((Component)jScrollPane, "Center");
                        ((Component)jDialog).setSize(jDialog.getPreferredSize());
                        jDialog.pack();
                        jDialog.setLocationRelativeTo(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                        jDialog.show();
                        jDialog.addWindowListener(new WindowAdapter(jDialog){
                            private final /* synthetic */ JDialog val$jd;
                            {
                                this.val$jd = jDialog;
                            }

                            public void windowClosing(WindowEvent windowEvent) {
                                ((Component)this.val$jd).setVisible(false);
                                this.val$jd.dispose();
                            }
                        });
                    }
                });
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem5 = new JMenuItem("Alternate name...");
                jMenuItem5.addActionListener(new ActionListener(ribRelationship, this){
                    private final /* synthetic */ RibRelationship val$rr;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$rr = ribRelationship;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = (String)JOptionPane.showInputDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Alternate name to show in catalog:", null, 3, null, null, this.val$rr.getAlt());
                        if (string != null && !string.equals(this.val$rr.getAlt())) {
                            RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                            this.val$rr.setAlt(string);
                        }
                    }
                });
                jPopupMenu.add(jMenuItem5);
                JMenu jMenu = new JMenu("Status");
                ButtonGroup buttonGroup = new ButtonGroup();
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("optional");
                JRadioButtonMenuItem jRadioButtonMenuItem12 = new JRadioButtonMenuItem("required");
                if (ribRelationship.getStatus().equals("opt")) {
                    jRadioButtonMenuItem.setSelected(true);
                } else {
                    jRadioButtonMenuItem12.setSelected(true);
                }
                buttonGroup.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem);
                buttonGroup.add(jRadioButtonMenuItem12);
                jMenu.add(jRadioButtonMenuItem12);
                jRadioButtonMenuItem.addActionListener(new ActionListener(ribRelationship, this){
                    private final /* synthetic */ RibRelationship val$rr;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$rr = ribRelationship;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$rr.setStatus("opt");
                    }
                });
                jRadioButtonMenuItem12.addActionListener(new ActionListener(ribRelationship, this){
                    private final /* synthetic */ PopupListener this$1;
                    private final /* synthetic */ RibRelationship val$rr;
                    {
                        this.val$rr = ribRelationship;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.val$rr.getStatus().equals("opt")) {
                            String string = "Making this change can cause previously created\nobjects to not have a value for a required field.\nAre you sure that you want to make this change?\n";
                            int n = JOptionPane.showConfirmDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), string, "Confirm change", 0);
                            if (n != 0) {
                                return;
                            }
                            RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                            this.val$rr.setStatus("req");
                        }
                    }
                });
                jPopupMenu.add(jMenu);
                JMenu jMenu5 = new JMenu("Display");
                ButtonGroup buttonGroup5 = new ButtonGroup();
                JRadioButtonMenuItem jRadioButtonMenuItem13 = new JRadioButtonMenuItem("show in catalog");
                JRadioButtonMenuItem jRadioButtonMenuItem14 = new JRadioButtonMenuItem("don't show in catalog");
                if (ribRelationship.getStatus().equals("noshow")) {
                    jRadioButtonMenuItem14.setSelected(true);
                } else {
                    jRadioButtonMenuItem13.setSelected(true);
                }
                buttonGroup5.add(jRadioButtonMenuItem13);
                jMenu5.add(jRadioButtonMenuItem13);
                buttonGroup5.add(jRadioButtonMenuItem14);
                jMenu5.add(jRadioButtonMenuItem14);
                jRadioButtonMenuItem14.addActionListener(new ActionListener(ribRelationship, this){
                    private final /* synthetic */ RibRelationship val$rr;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$rr = ribRelationship;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$rr.setDisplay("noshow");
                    }
                });
                jRadioButtonMenuItem13.addActionListener(new ActionListener(ribRelationship, this){
                    private final /* synthetic */ RibRelationship val$rr;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$rr = ribRelationship;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$rr.setDisplay("show");
                    }
                });
                jPopupMenu.add(jMenu5);
                JMenu jMenu6 = new JMenu("Cardinality");
                ButtonGroup buttonGroup6 = new ButtonGroup();
                JRadioButtonMenuItem jRadioButtonMenuItem15 = new JRadioButtonMenuItem("multiple");
                JRadioButtonMenuItem jRadioButtonMenuItem16 = new JRadioButtonMenuItem("single");
                if (ribRelationship.getCardinality().equals("single")) {
                    jRadioButtonMenuItem16.setSelected(true);
                } else {
                    jRadioButtonMenuItem15.setSelected(true);
                }
                buttonGroup6.add(jRadioButtonMenuItem15);
                jMenu6.add(jRadioButtonMenuItem15);
                buttonGroup6.add(jRadioButtonMenuItem16);
                jMenu6.add(jRadioButtonMenuItem16);
                jRadioButtonMenuItem15.addActionListener(new ActionListener(ribRelationship, this){
                    private final /* synthetic */ RibRelationship val$rr;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$rr = ribRelationship;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$rr.setCardinality("mult");
                    }
                });
                jRadioButtonMenuItem16.addActionListener(new ActionListener(ribRelationship, this){
                    private final /* synthetic */ RibRelationship val$rr;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$rr = ribRelationship;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        this.val$rr.setCardinality("single");
                    }
                });
                jPopupMenu.add(jMenu6);
                jPopupMenu.addSeparator();
                JMenuItem jMenuItem6 = new JMenuItem("Delete this relationship");
                jMenuItem6.addActionListener(new ActionListener(defaultMutableTreeNode, ribRelationship, this){
                    private final /* synthetic */ RibRelationship val$rr;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$node = defaultMutableTreeNode;
                        this.val$rr = ribRelationship;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = JOptionPane.showConfirmDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Are you sure that you want to delete this relationship?", "Confirm Delete", 0);
                        if (n != 0) {
                            return;
                        }
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        ClassTreeNode classTreeNode = (ClassTreeNode)this.val$node.getParent().getParent();
                        RibClass ribClass = classTreeNode.ribClass;
                        ribClass.removeRelationship(this.val$rr);
                        ((DefaultTreeModel)RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getModel()).removeNodeFromParent(this.val$node);
                    }
                });
                jPopupMenu.add(jMenuItem6);
            } else if (defaultMutableTreeNode instanceof AttributeListNode) {
                JMenuItem jMenuItem = new JMenuItem("Add a new attribute");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(defaultMutableTreeNode, this){
                    private final /* synthetic */ PopupListener this$1;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    {
                        this.val$node = defaultMutableTreeNode;
                        this.this$1 = popupListener;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void actionPerformed(ActionEvent var1_1) {
                        var2_2 = (ClassTreeNode)this.val$node.getParent();
                        var3_3 = var2_2.ribClass;
                        var4_4 = RibUtil.getAlphabeticDialogInput("New attribute name:", 61, RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                        if (var4_4 == null) {
                            return;
                        }
                        if (RibConfigEditor.access$12(PopupListener.access$0(this.this$1), var4_4)) ** GOTO lbl14
                        return;
lbl-1000:
                        // 1 sources

                        {
                            JOptionPane.showMessageDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Please choose a name that is not already in use");
                            var4_4 = RibUtil.getAlphabeticDialogInput("New attribute name:", 61, RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                            if (var4_4 == null) {
                                return;
                            }
                            if (RibConfigEditor.access$12(PopupListener.access$0(this.this$1), var4_4)) continue;
                            return;
lbl14:
                            // 2 sources

                            ** while (var3_3.getNativeAttributeNames().indexOf((Object)var4_4) != -1)
                        }
lbl15:
                        // 1 sources

                        if (var4_4.equals("Name")) {
                            JOptionPane.showMessageDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "The \"Name\" attribute is inherited from RigObject and cannot be overridden.");
                            return;
                        }
                        try {
                            var5_5 = (ClassTreeNode)this.val$node.getParent().getParent().getParent();
                            while (var5_5 != null) {
                                var6_6 = var5_5.toString();
                                var7_7 = var5_5.getFirstChild().children();
                                while (var7_7.hasMoreElements()) {
                                    var8_8 = (AttributeTreeNode)var7_7.nextElement();
                                    if (!var8_8.toString().equals(var4_4)) continue;
                                    var9_10 = JOptionPane.showConfirmDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "This attribute is already inherited from the parent class " + (String)var6_6 + ".\nDo you want to override this attribute?", "Confirm", 0);
                                    if (var9_10 == 0) break;
                                    return;
                                }
                                var5_5 = (ClassTreeNode)var5_5.getParent().getParent();
                            }
                        }
                        catch (Exception v0) {}
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        var5_5 = new RibAttribute();
                        var5_5.setName(var4_4);
                        var3_3.addAttribute((RibAttribute)var5_5);
                        v1 = PopupListener.access$0(this.this$1);
                        v1.getClass();
                        var6_6 = v1.new AttributeTreeNode((RibAttribute)var5_5);
                        var7_7 = (DefaultTreeModel)RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getModel();
                        var8_9 = var3_3.getNativeAttributeNames().indexOf(var4_4);
                        var7_7.insertNodeInto((MutableTreeNode)var6_6, this.val$node, var8_9);
                        RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).expandPath(RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getSelectionPath());
                    }
                });
            } else if (defaultMutableTreeNode instanceof RelationshipListNode) {
                JMenuItem jMenuItem = new JMenuItem("Add a new relationship");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(defaultMutableTreeNode, this){
                    private final /* synthetic */ PopupListener this$1;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    {
                        this.val$node = defaultMutableTreeNode;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ClassTreeNode classTreeNode = (ClassTreeNode)this.val$node.getParent();
                        RibClass ribClass = classTreeNode.ribClass;
                        String string = RibUtil.getAlphabeticDialogInput("New relationship name:", 24, RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                        if (string == null) {
                            return;
                        }
                        if (!RibConfigEditor.access$12(PopupListener.access$0(this.this$1), string)) {
                            return;
                        }
                        Container container = PopupListener.access$0(this.this$1).getParent();
                        while (!(container instanceof Frame)) {
                            container = ((Component)container).getParent();
                        }
                        JDialog jDialog = new JDialog((Frame)container, "Destination class", true);
                        jDialog.getContentPane().setLayout(new BoxLayout(jDialog.getContentPane(), 1));
                        JToolBar jToolBar = new JToolBar();
                        JButton jButton = new JButton("  Ok  ");
                        jButton.setBorder(new BevelBorder(0));
                        JButton jButton2 = new JButton("  Cancel  ");
                        jButton2.setBorder(new BevelBorder(0));
                        Vector vector = RibConfigEditor.access$6(PopupListener.access$0(this.this$1)).getClassNames(true);
                        Object[] objectArray = new String[vector.size()];
                        vector.copyInto(objectArray);
                        JList<E> jList = new JList<E>(vector);
                        jList.setVisibleRowCount(vector.size());
                        jList.setSelectionMode(0);
                        jList.setSelectedIndex(0);
                        jButton.addActionListener(new ActionListener(jDialog, jList, this.val$node, ribClass, this.this$1, string){
                            private final /* synthetic */ JDialog val$jd;
                            private final /* synthetic */ DefaultMutableTreeNode val$node;
                            private final /* synthetic */ PopupListener this$1;
                            private final /* synthetic */ RibClass val$ribClass;
                            private final /* synthetic */ String val$tmpName;
                            private final /* synthetic */ JList val$jl;
                            {
                                this.val$jd = jDialog;
                                this.val$jl = jList;
                                this.val$node = defaultMutableTreeNode;
                                this.val$ribClass = ribClass;
                                this.this$1 = popupListener;
                                this.val$tmpName = string;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                Object object;
                                Object object2;
                                Cloneable cloneable;
                                String string = (String)this.val$jl.getSelectedValue();
                                if (string == null) {
                                    return;
                                }
                                String string2 = String.valueOf(this.val$tmpName) + "." + string;
                                if (this.val$ribClass.getNativeRelationshipNames().indexOf(string2) != -1) {
                                    JOptionPane.showMessageDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Please choose a name/destination class pair that is not already in use");
                                }
                                try {
                                    cloneable = (ClassTreeNode)this.val$node.getParent().getParent().getParent();
                                    while (cloneable != null) {
                                        object2 = ((DefaultMutableTreeNode)cloneable).toString();
                                        object = ((DefaultMutableTreeNode)cloneable).getChildAt(1).children();
                                        while (object.hasMoreElements()) {
                                            RelationshipTreeNode relationshipTreeNode = (RelationshipTreeNode)object.nextElement();
                                            if (!relationshipTreeNode.toString().equals(string2)) continue;
                                            int n = JOptionPane.showConfirmDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "This relationship is already inherited from the parent class " + (String)object2 + ".\nDo you want to override this relationship?", "Confirm", 0);
                                            if (n == 0) break;
                                            return;
                                        }
                                        cloneable = (ClassTreeNode)((DefaultMutableTreeNode)cloneable).getParent().getParent();
                                    }
                                }
                                catch (Exception exception) {}
                                RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                                cloneable = new RibRelationship();
                                ((RibRelationship)cloneable).setName(string2);
                                ((RibRelationship)cloneable).setDest(string);
                                this.val$ribClass.addRelationship((RibRelationship)cloneable);
                                RibConfigEditor ribConfigEditor = PopupListener.access$0(this.this$1);
                                ribConfigEditor.getClass();
                                object2 = ribConfigEditor.new RelationshipTreeNode((RibRelationship)cloneable);
                                object = (DefaultTreeModel)RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getModel();
                                int n = this.val$ribClass.getNativeRelationshipNames().indexOf(string2);
                                ((DefaultTreeModel)object).insertNodeInto((MutableTreeNode)object2, this.val$node, n);
                                RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).expandPath(RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getSelectionPath());
                                ((Component)this.val$jd).setVisible(false);
                                this.val$jd.dispose();
                            }
                        });
                        jButton2.addActionListener(new ActionListener(jDialog){
                            private final /* synthetic */ JDialog val$jd;
                            {
                                this.val$jd = jDialog;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                ((Component)this.val$jd).setVisible(false);
                                this.val$jd.dispose();
                            }
                        });
                        jDialog.getContentPane().add(jList);
                        jList.setBorder(new EmptyBorder(5, 5, 5, 5));
                        jDialog.getContentPane().add(Box.createVerticalStrut(20));
                        jToolBar.setFloatable(false);
                        jToolBar.add(jButton);
                        jToolBar.add(Box.createHorizontalStrut(2));
                        jToolBar.add(jButton2);
                        jDialog.getContentPane().add(jToolBar);
                        jDialog.pack();
                        jDialog.setLocationRelativeTo(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                        jDialog.show();
                        jDialog.addWindowListener(new WindowAdapter(jDialog){
                            private final /* synthetic */ JDialog val$jd;
                            {
                                this.val$jd = jDialog;
                            }

                            public void windowClosing(WindowEvent windowEvent) {
                                ((Component)this.val$jd).setVisible(false);
                                this.val$jd.dispose();
                            }
                        });
                    }
                });
            } else if (defaultMutableTreeNode instanceof SubclassListNode) {
                JMenuItem jMenuItem = new JMenuItem("Add a new subclass");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(defaultMutableTreeNode, this){
                    private final /* synthetic */ PopupListener this$1;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    {
                        this.val$node = defaultMutableTreeNode;
                        this.this$1 = popupListener;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void actionPerformed(ActionEvent var1_1) {
                        var2_2 = (ClassTreeNode)this.val$node.getParent();
                        var3_3 = var2_2.ribClass;
                        var4_4 = RibUtil.getAlphabeticDialogInput("New class name:", 50, RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                        if (var4_4 != null) ** GOTO lbl10
                        return;
lbl-1000:
                        // 1 sources

                        {
                            JOptionPane.showMessageDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Please choose a name that is not already in use");
                            var4_4 = RibUtil.getAlphabeticDialogInput("New class name:", 50, RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                            if (var4_4 != null) continue;
                            return;
lbl10:
                            // 2 sources

                            ** while (RibConfigEditor.access$6((RibConfigEditor)PopupListener.access$0((PopupListener)this.this$1)).getClassNames((boolean)true).indexOf((Object)var4_4) != -1)
                        }
lbl11:
                        // 1 sources

                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        var5_5 = new RibClass();
                        var5_5.setParentClass(var3_3);
                        var5_5.setExtends(var3_3.getName());
                        var5_5.setName(var4_4);
                        RibConfigEditor.access$6(PopupListener.access$0(this.this$1)).addClass(var5_5);
                        v0 = PopupListener.access$0(this.this$1);
                        v0.getClass();
                        var6_6 = v0.new ClassTreeNode(var5_5);
                        var7_7 = (DefaultTreeModel)RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getModel();
                        var8_8 = new Vector<String>();
                        var8_8.addElement(var4_4);
                        var9_9 = this.val$node.children();
                        while (var9_9.hasMoreElements()) {
                            var10_10 = var9_9.nextElement();
                            var8_8.addElement(var10_10.toString());
                        }
                        var10_11 = RibUtil.sortStringVector(var8_8).indexOf(var4_4);
                        var7_7.insertNodeInto(var6_6, this.val$node, var10_11);
                        RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).expandPath(RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getSelectionPath());
                    }
                });
            } else if (defaultMutableTreeNode instanceof VocabularyTreeNode) {
                JMenuItem jMenuItem = new JMenuItem("Add a subvocabulary term");
                jMenuItem.addActionListener(new ActionListener(defaultMutableTreeNode, this){
                    private final /* synthetic */ PopupListener this$1;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    {
                        this.val$node = defaultMutableTreeNode;
                        this.this$1 = popupListener;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void actionPerformed(ActionEvent var1_1) {
                        var2_2 = new Vector<Object>();
                        var3_3 = this.val$node.children();
                        while (var3_3.hasMoreElements()) {
                            var4_4 = var3_3.nextElement();
                            var2_2.addElement(var4_4.toString());
                        }
                        var4_4 = RibUtil.getAlphanumericsymbolDialogInput("New vocabulary term:", 128, RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                        if (var4_4 != null) ** GOTO lbl14
                        return;
lbl-1000:
                        // 1 sources

                        {
                            JOptionPane.showMessageDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Please choose a term that is not already in use");
                            var4_4 = RibUtil.getAlphanumericsymbolDialogInput("New vocabulary term:", 128, RibConfigEditor.access$0(PopupListener.access$0(this.this$1)));
                            if (var4_4 != null) continue;
                            return;
lbl14:
                            // 2 sources

                            ** while (var2_2.indexOf((Object)var4_4) != -1)
                        }
lbl15:
                        // 1 sources

                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        var5_5 = new RibVocabularyTerm((String)var4_4);
                        v0 = PopupListener.access$0(this.this$1);
                        v0.getClass();
                        var6_6 = v0.new VocabularyTreeNode(var5_5);
                        var2_2.addElement(var4_4);
                        var7_7 = ((VocabularyTreeNode)this.val$node).getRibVocabularyTerm();
                        var7_7.addChild(var5_5);
                        var8_8 = RibUtil.sortStringVector(var2_2).indexOf(var4_4);
                        var9_9 = (DefaultTreeModel)RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getModel();
                        this.val$node.setAllowsChildren(true);
                        var9_9.insertNodeInto(var6_6, this.val$node, var8_8);
                        RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).expandPath(RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getSelectionPath());
                    }
                });
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem7 = new JMenuItem("Delete this term");
                jMenuItem7.addActionListener(new ActionListener(defaultMutableTreeNode, this){
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.val$node = defaultMutableTreeNode;
                        this.this$1 = popupListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = JOptionPane.showConfirmDialog(RibConfigEditor.access$0(PopupListener.access$0(this.this$1)), "Are you sure that you want to delete this term?", "Confirm Delete", 0);
                        if (n != 0) {
                            return;
                        }
                        RibConfigEditor.access$5(PopupListener.access$0(this.this$1), true);
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.val$node.getParent();
                        RibVocabularyTerm ribVocabularyTerm = defaultMutableTreeNode instanceof AttributeTreeNode ? ((AttributeTreeNode)defaultMutableTreeNode).ribAttribute.getVocabulary() : ((VocabularyTreeNode)defaultMutableTreeNode).ribVocabularyTerm;
                        ribVocabularyTerm.removeChild(((VocabularyTreeNode)this.val$node).ribVocabularyTerm);
                        ((DefaultTreeModel)RibConfigEditor.access$10(PopupListener.access$0(this.this$1)).getModel()).removeNodeFromParent(this.val$node);
                        if (defaultMutableTreeNode.getChildCount() == 0) {
                            defaultMutableTreeNode.setAllowsChildren(false);
                        }
                    }
                });
                jPopupMenu.add(jMenuItem7);
            }
            jPopupMenu.pack();
            if (mouseEvent.getY() + jPopupMenu.getPreferredSize().height > RibConfigEditor.this.jsp.getHeight()) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY() - jPopupMenu.getPreferredSize().height);
            } else {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

