#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::WhatsNew;

my $util = new RIB::Util();
$util->dbConnect();
my $ribdir = $util->RibDir();
my $riburl = $util->RibUrl();

# determine repository handle
unless (param('rh') =~ /^\d+$/) {
  $util->error("Repository handle not specified");
}
my $repoHandle = param('rh');
if (param('days')) {
  unless (param('days') =~ /^\d+$/) {
    $util->error("Number of days not formatted properly");
  }
}

# instantiate whats new object
my $wn = new RIB::WhatsNew();
$wn->dbh($util->dbh);
$wn->repoHandle($repoHandle);

# print catalog
print header,
      $wn->whats_new(param('days'));

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
