#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;
use XML::DOM;

##############################################

my $util = new RIB::Util();

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
unless (param('class') =~ /^[A-Za-z]+$/) {
  $util->error("class not specified in input");
}
my $rib_url = $util->RibUrl;
my $ribversion = $util->RibVersion();

$util->dbConnect();

my $sth = $util->dbh->prepare("SELECT password FROM admin");
eval { $sth->execute(); };
if ($@) { $util->error($@); }
my $main_rib_password = $sth->fetchrow_array;

$sth = $util->dbh->prepare("SELECT password,object_approval_required FROM "
                            . "repositories WHERE handle=" . param('rh'));
eval { $sth->execute(); };
if ($@) { $util->error($@); }

my $table_name = param('rh') . "_" . param('class');
my $repo_info = $sth->fetchrow_hashref();
if ($repo_info->{'object_approval_required'}) {
  if (param('repoPasswd') eq $repo_info->{'password'}
      or param('repoPasswd') eq $main_rib_password) {
    $sth = $util->dbh->prepare("SELECT Name_,handle,last_modified,approved,created FROM "
                            . "$table_name WHERE handle IS NOT NULL AND Name_ IS "
                            . "NOT NULL order by Name_");
  } else {
    $sth = $util->dbh->prepare("SELECT Name_,handle,last_modified,approved,created FROM "
                             . "$table_name WHERE handle IS NOT NULL AND Name_ "
                             . "IS NOT NULL AND approved=1 order by Name_");
  }
}
else {
  $sth = $util->dbh->prepare("SELECT Name_,handle,last_modified,approved,created FROM "
                          . "$table_name WHERE handle IS NOT NULL AND Name_ IS "
                          . "NOT NULL order by Name_");
}



eval { $sth->execute(); };
if ($@) { $util->error($@); }

my $document = new XML::DOM::Document();
my $xml_decl = new XML::DOM::XMLDecl();
$xml_decl->setVersion('1.0');
$xml_decl->setStandalone('yes');
$document->setXMLDecl($xml_decl);
my $rib_element = $document->createElement('rib');
$rib_element->setAttribute('version',$ribversion);
$document->appendChild($rib_element);
my $repo_element = $document->createElement('repository');
$repo_element->setAttribute('handle',param('rh'));
$repo_element->setAttribute('config',"$rib_url/".param('rh')."/config.xml");
$rib_element->appendChild($repo_element);
my $class_element = $document->createElement('class');
$class_element->setAttribute('name',param('class'));
$repo_element->appendChild($class_element);

while (my @tmp = $sth->fetchrow_array()) {
  my $object_element = $document->createElement('object');
  $object_element->setAttribute('name',$tmp[0]);
  $object_element->setAttribute('handle',$tmp[1]);
  $object_element->setAttribute('last_modified',$tmp[2]);
  $object_element->setAttribute('approved',$tmp[3]);
  $object_element->setAttribute('created',$tmp[4]);
  $object_element->setAttribute('url',
           "$rib_url/object.pl?rh="
           . param('rh')
           . "&class="
           . param('class')
           . "&oh="
           . $tmp[1]);
  $class_element->appendChild($object_element);
}

print header(-type=>"text/xml"),
      $document->toString();

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
