#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::Parser;
use RIB::ObjectCreator;

my $util = new RIB::Util();
my $rp = new RIB::Parser;
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
unless (param('newObject')) {
  $util->error("new object not supplied in input");
}
unless (param('oh')) {
  $util->error("object handle not supplied in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

my $newObject = param('newObject');
$newObject =~ s/[^\w\-\~\`\!\@\#\$\%\^\&\*\(\)\_\+\-\=\{\}\|\[\]\\\;\'\:\"\,\.\/\<\>\?\\\s]//g;

eval {
  unless ($rp->parse_object($newObject)) {
    $util->error("Couldn't parse new object");
  }
};
if ($@) { $util->error("Couldn't parse object"); }
my $class = $rp->classes->[0];

my $class_handle = param('rh') . "_" . $class->name;

###################################################################
# lock the table
unless ($util->dbh->do("LOCK TABLES $class_handle WRITE")) {
  $util->error("Can't get lock on $class_handle: " . $util->dbh->errstr);
}
my $seq = 0; # we'll use sequence number 0 for the new record


###################################################################
# create a new object with its handle set to 0.
my $oc = new RIB::ObjectCreator();
my $response;
eval { $response = $oc->createObject(param('newObject'),param('rh'),$util,0); };
if ($@) { $util->error($@); }
if ($response !~ /^http:\/\//) {
  $util->error($response);
}
my $objectUrl = $response;


###################################################################
# find the creation date and approval status of the original object.
my $sth = $util->dbh->prepare("SELECT created,approved FROM "
                            . "$class_handle WHERE handle="
                            . param('oh'));
eval { $sth->execute(); };
if ($@) { $util->error($@); }
my $row = $sth->fetchrow_arrayref();
my $created = $row->[0];
my $approved = $row->[1];

###################################################################
# delete the old object, and swap the handle numbers with the new object
$util->dbh->do("DELETE FROM $class_handle WHERE handle="
             . param('oh')
             . " OR extends="
             . param('oh'));
$util->dbh->do("UPDATE $class_handle SET handle="
             . param('oh')
             . " WHERE handle=0");
$util->dbh->do("UPDATE $class_handle SET extends="
             . param('oh')
             . " WHERE extends=0");

###################################################################
# set the created and approved values to the original values
$util->dbh->do("UPDATE $class_handle SET created=$created,approved=$approved "
             . "WHERE handle="
             . param('oh')
             . " OR extends="
             . param('oh'));


###################################################################
# unlock the table
$util->dbh->do("UNLOCK TABLES");

print header(-type=>"text/plain"), $objectUrl;

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
