#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::Parser;

my $util = new RIB::Util();
my $newConfig = new RIB::Parser;
my $oldConfig = new RIB::Parser;
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
unless (param('newConfig')) {
  $util->error("new object not supplied in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

eval {
  unless ($newConfig->parse_config(param('newConfig'))) {
    $util->error("Couldn't parse new data model : " . $newConfig->errormsg());
  }
};
if ($@) {
  $util->error("Couldn't parse new data model : $@");
}

unless ($newConfig->getClass("RigObject")) {
  $util->error("New data model doesn't contain RigObject class");
}
unless ($newConfig->getClass("RigObject")->get_attribute("Name")) {
  $util->error("New data model doesn't contain Name attribute "
             . "in RigObject class.");
}
if (int(@{$newConfig->classes()}) < 2) {
  $util->error("New data model must contain at least one subclass for RigObject");
}

my $oldConfigFile = "$ribdir/docRoot/" . param('rh') . "/config.xml";
eval {
  unless ($oldConfig->parse_config_file($oldConfigFile)) {
    $util->error("Couldn't parse old data model : " . $oldConfig->errormsg());
  }
};
if ($@) {
  $util->error("Couldn't parse old data model : $@");
}

# make sure that we'll be able to write the data model file later
unless (-w $oldConfigFile) {
  $util->error("Can't write to $oldConfigFile : permission denied");
}

# check to make sure the primary_class and primary_attribute are still valid
my $sth = $util->dbh->prepare("SELECT primary_class, primary_attribute FROM repositories WHERE handle=" . param('rh'));
eval { $sth->execute(); };
if ($@) { $util->error($@); }
my $info = $sth->fetchrow_hashref();
my $primary_class = $info->{'primary_class'};
my $primary_attribute = $info->{'primary_attribute'};
if (!($newConfig->getClass($primary_class))) {
  my $primary_class = $newConfig->classes()->[0]->name();
  if (lc($primary_class) eq 'rigobject') {
    $primary_class = $newConfig->classes()->[1]->name();
  }
  eval {
    $util->dbh->do("UPDATE repositories SET primary_class='$primary_class' "
                 . "WHERE handle=". param('rh'));
    $util->dbh->do("UPDATE repositories SET primary_attribute=NULL "
                 . "WHERE handle=". param('rh'));
  };
  if ($@) { $util->error($@); }

  ## reconfigure the interop_objects table
  eval {
    $util->dbh->do("DROP TABLE ".param('rh')."_interop_objects");
  };
  if ($@) { $util->error("Database error $@"); }
  
  my $query = "CREATE TABLE ".param('rh')."_interop_objects (";
  my $pc = $newConfig->getClass($primary_class);
  foreach my $field (@{$pc->attributes},@{$pc->relationships}) {
    my $fieldname = $field->name;
    $fieldname =~ s/\./\_/;
    $query .= "$fieldname\_ TEXT, ";
  }
  $query .= "url TEXT, owner_handle BIGINT UNSIGNED, "
          . "last_modified TIMESTAMP, created TIMESTAMP)";
  
  $sth = $util->dbh->prepare($query);
  eval { $sth->execute(); };
  if ($@) {
    $util->error("Database error : $@");
  }
} elsif (!($newConfig->getClass($primary_class)->get_attribute($primary_attribute))) {
  eval {
    $util->dbh->do("UPDATE repositories SET primary_attribute=NULL "
                 . "WHERE handle=". param('rh'));
  };
  if ($@) { $util->error($@); }
}

# update database to reflect new attributes, relationships, and classes
foreach my $newClass (@{$newConfig->classes})
{
  next if $newClass->name() eq 'RigObject';
  # table names in MySQL are not case sensitive, so can't just
  # call getClass().
  # my $oldClass = $oldConfig->getClass($newClass->name());
  my $oldClass = undef;
  foreach my $c (@{$oldConfig->classes()}) {
    if (lc($c->name) eq lc($newClass->name())) {
      $oldClass = $c;
    }
  }
  if (!($oldClass))
  {
    &addClass($newClass);
  }
  else
  {
    foreach my $newAttribute (@{$newClass->attributes()})
    {
      # column names in MySQL are not case sensitive, so can't just
      # call getAttribute().
      #my $oldAttribute = $oldClass->get_attribute($newAttribute->name());
      my $oldAttribute = undef;
      foreach my $a (@{$oldClass->attributes()}) {
        if (lc($a->name) eq lc($newAttribute->name())) {
          $oldAttribute = $a;
        }
      }
      if (!($oldAttribute))
      {
        &addField($newAttribute->name(),$newClass->name());
      }
    }
    foreach my $newRelationship (@{$newClass->relationships()})
    {
      # column names in MySQL are not case sensitive, so can't just
      # call get_relationship().
      #my $oldRelationship = $oldClass->get_relationship($newRelationship->name());
      my $oldRelationship = undef;
      foreach my $r (@{$oldClass->relationships()}) {
        if (lc($r->name) eq lc($newRelationship->name())) {
          $oldRelationship = $r;
        }
      }
      if (!($oldRelationship))
      {
        &addField($newRelationship->name(),$newClass->name());
      }
    }
  }
}

# write the configuration file
unless (open(CONFIG,">$oldConfigFile")) {
  $util->error("Can't write to $oldConfigFile : $!");
}
print CONFIG param('newConfig');
close (CONFIG);
chmod (0644, $oldConfigFile);

# update database to remove unused attributes, relationships, and classes
foreach my $oldClass (@{$oldConfig->classes})
{
  next if $oldClass->name() eq 'RigObject';
  # table names in MySQL are not case sensitive, so can't just
  # call getClass().
  #my $newClass = $newConfig->getClass($oldClass->name());
  my $newClass = undef;
  foreach my $c (@{$newConfig->classes()}) {
    if (lc($c->name) eq lc($oldClass->name())) {
      $newClass = $c;
    }
  }
  if (!($newClass))
  {
    # don't worry about tracking down relationships that point
    # at this class; that's handled in the gui
    &deleteClass($oldClass->name());
  }
  else
  {
    foreach my $oldAttribute (@{$oldClass->attributes()})
    {
      # column names in MySQL are not case sensitive, so can't just
      # call getAttribute().
      #my $newAttribute = $newClass->get_attribute($oldAttribute->name());
      my $newAttribute = undef;
      foreach my $a (@{$newClass->attributes()}) {
        if (lc($a->name) eq lc($oldAttribute->name())) {
          $newAttribute = $a;
        }
      }
      if (!($newAttribute))
      {
        &deleteField($oldAttribute->name(),$oldClass->name());
      }
    }
    foreach my $oldRelationship (@{$oldClass->relationships()})
    {
      # column names in MySQL are not case sensitive, so can't just
      # call get_relationship().
      #my $newRelationship = $newClass->get_relationship($oldRelationship->name());
      my $newRelationship = undef;
      foreach my $r (@{$newClass->relationships()}) {
        if (lc($r->name) eq lc($oldRelationship->name())) {
          $newRelationship = $r;
        }
      }
      if (!($newRelationship))
      {
        &deleteField($oldRelationship->name(),$oldClass->name());
      }
    }
  }
}


# check every attribute with a vocabulary. if there is a value in the database
# that doesn't fit into the vocabulary then either truncate it or delete it
foreach my $class (@{$newConfig->classes()}) {
  next if $class->name() eq "RigObject";
  my $tableName = param('rh') . "_" . $class->name();
  foreach my $attribute (@{$class->attributes()}) {
    my $rootNode = $attribute->vocabulary();
    next unless $rootNode;
    my $attributeName = $attribute->name();

    #### local (not interoperated) objects
    my $sth = $util->dbh->prepare("SELECT $attributeName\_,handle,extends FROM "
                                . "$tableName WHERE $attributeName\_ IS NOT NULL");
    eval { $sth->execute(); };
    next if $@;
    next unless $sth->rows() >= 1;
    my @legalValues = ();
    &getLegalValues($rootNode,\@legalValues,"",1);
    # last_modified field will automatically get updated. this is ok?
    while (my $row = $sth->fetchrow_hashref()) {
      my $newVal = "";
      my $oldVal = $row->{$attributeName."_"};
      foreach my $part (split(/!/,$oldVal)) {
        if ($newVal ne "") {
          last unless grep(/^\Q$newVal!$part\E$/,@legalValues);
          $newVal .= "!$part"
        } else {
          last unless grep(/^\Q$part\E$/,@legalValues);
          $newVal .= "$part"
        }
      }
      next if $newVal eq $oldVal;
      my $sth2;
      # NULL is not the same as '', so only set val to NULL if handle!=NULL
      if ($row->{'handle'} and ($newVal eq "")) {
        $sth2 = $util->dbh->prepare("UPDATE $tableName "
                                  . "SET $attributeName\_='' WHERE handle="
                                  . $row->{'handle'});
      } elsif ($row->{'extends'} and ($newVal eq "")) {
        $sth2 = $util->dbh->prepare("UPDATE $tableName "
                                  . "SET $attributeName\_=NULL WHERE extends="
                                  . $row->{'extends'}
                                  . " AND $attributeName\_="
                                  . $util->dbh->quote($oldVal));
      } else {
        $sth2 = $util->dbh->prepare("UPDATE $tableName "
                                  . "SET $attributeName\_="
                                  . $util->dbh->quote($newVal)
                                  . " WHERE $attributeName\_="
                                  . $util->dbh->quote($oldVal));
      }
      eval { $sth2->execute(); };
      next if $@;
    }
  }
}

### If primary class has any new vocabulary terms then mark
### interop objects which could fit into a new category as stale.
### If primary class has lost any vocabulary terms then set the
### affected terms in interop objects to the nearest appropriate value
### and mark the object as stale. Marking the object as stale is a quick
### and dirty way to take care of cases where the same object occupies
### two rows in the table, and one of the value is repeated.
my $newPc = $newConfig->getClass($primary_class);
my $oldPc = $oldConfig->getClass($primary_class);
my $interopTable= param('rh') . "_interop_objects";
if ($oldPc and $newPc) {
  foreach my $newAttr (@{$newPc->attributes}) {
    next unless my $newRootNode = $newAttr->vocabulary();
    next unless my $oldAttr = $oldPc->get_attribute($newAttr->name);
    my $oldRootNode = $oldAttr->vocabulary();

    # if old attribute didn't contain vocab then set each of the
    # values to NULL and mark all objects for an update
    unless ($oldRootNode) {
      $util->dbh->do("UPDATE $interopTable SET last_modified=19700101000000, "
                   . $oldAttr->name
                   . "_=NULL");
      
      next;
    }

    # determine all the legal values
    my @newLegalValues = ();
    &getLegalValues($newRootNode,\@newLegalValues,"",1);
    my @oldLegalValues = ();
    &getLegalValues($oldRootNode,\@oldLegalValues,"",1);

    # did attribute gain new vocab terms?
    foreach my $val (@newLegalValues) {
      unless (grep(/^\Q$val\E$/,@oldLegalValues)) {
        foreach my $oldTerm (@oldLegalValues) {
          if ($oldTerm ne '' and $val =~ /^\Q$oldTerm!\E/) {
            $util->dbh->do("UPDATE $interopTable SET last_modified=19700101000000 "
                         . "WHERE "
                         . $oldAttr->name . "_="
                         . $util->dbh->quote($oldTerm));
          }
        }
      }
    }

    # did attribute lose any vocab terms?
    foreach my $val (@oldLegalValues) {
      unless (grep(/^\Q$val\E$/,@newLegalValues)) {
        my $newVal = $val;
        while ($newVal ne '' and !(grep /^\Q$newVal\E$/,@newLegalValues)) {
          $newVal =~ s/!?[^!]+$//;
        }

        # will any rows be affected by the change?
        my $sth = $util->dbh->prepare("SELECT url FROM $interopTable WHERE "
                                    . $newAttr->name . "_="
                                    . $util->dbh->quote($val));
        eval { $sth->execute(); };
        next if $@;
        next unless $sth->rows() >= 1;
        while (my $row = $sth->fetchrow_hashref()) {
          my $url = $row->{'url'};
          $util->dbh->do("UPDATE $interopTable SET "
                       . "last_modified=19700101000000 WHERE url="
                       . $util->dbh->quote($url));
        }
        $util->dbh->do("UPDATE $interopTable SET "
                     . $newAttr->name . "_="
                     . $util->dbh->quote($newVal)
                     . " WHERE "
                     . $newAttr->name . "_="
                     . $util->dbh->quote($val));
      }
    }
  }
}

# delete records from tables where cardinality of field is single
# but multiple entries are found
foreach my $class (@{$newConfig->classes()}) {
  next if $class->name() eq "RigObject";
  my $table_name = param('rh') . "_" . $class->name();
  foreach my $field (@{$class->attributes()},@{$class->relationships()}) {
    if ($field->cardinality() eq 'single') {
      my $column_name = $field->name();
      $column_name =~ s/\./_/;
      $column_name .= "_";
      my $sth = $util->dbh->prepare("UPDATE $table_name SET $column_name=NULL "
                                  . "WHERE extends IS NOT NULL");
      eval { $sth->execute(); };
      if ($@) { print STDERR $@, "\n"; }
    }
  }
}

# delete records from all tables where extends!=NULL and all values
# are empty (NULL or '')
foreach my $class (@{$newConfig->classes()}) {
  next if $class->name() eq "RigObject";
  my $tableName = param('rh') . "_" . $class->name();
  my $query = "DELETE FROM $tableName WHERE extends IS NOT NULL ";
  foreach my $field (@{$class->attributes()}, @{$class->relationships()}) {
    my $name = $field->name();
    $name =~ s/\./_/;
    $query .= "AND ($name\_ IS NULL OR $name\_='')";
  }
  eval { $util->dbh->do($query); };
  if ($@) { print STDERR $@, "\n"; }
}

print header(-type=>"text/plain"), "ok";

sub addClass {
  my $class = shift;

  my $table_name = param('rh') . "_" . $class->name();
  
  # first try to create a row in the sequences table
  #$util->getSequence($table_name);   -- createObject.pl creates sequence now

  my $create_query = "CREATE TABLE $table_name ( ";
  foreach my $field (@{$class->attributes()}, @{$class->relationships()}) {
    my $fieldname = $field->name;
    $fieldname =~ s/\./\_/;
    $create_query .= " $fieldname\_ TEXT,";
  }
  $create_query .= " handle BIGINT UNSIGNED,"
                .  " extends BIGINT UNSIGNED,"
                .  " last_modified TIMESTAMP,"
                .  " created TIMESTAMP,"
                .  " approved TINYINT)";

  eval { $util->dbh->do($create_query); };
  if ($@)
  {
    $util->error("Can't create table $table_name : $@");
  }
}

sub deleteClass {
  my $class = shift;
  my $table_name = param('rh') . "_" . $class;
  $util->deleteSequence($table_name);
  my $sth = $util->dbh->prepare("DROP TABLE $table_name");
  eval '$sth->execute();';
  if ($@) { $util->error("cannot drop table $table_name : $@"); }
}

sub addField {
  my ($field,$class) = @_;
  my $table_name = param('rh') . "_$class";
  $field =~ s/\./_/;
  my $sth = $util->dbh->prepare(
        "ALTER TABLE $table_name ADD COLUMN $field\_ TEXT");
  eval '$sth->execute();';
  if ($@) { $util->error("cannot add column $table_name.$field\_ : $@"); }
  if ($class eq $primary_class) {
    $sth = $util->dbh->prepare(
         "ALTER TABLE ".param('rh')."_interop_objects ADD COLUMN $field\_ TEXT");
    eval '$sth->execute();';
    if ($@) { $util->error("cannot add column $table_name . $field\_ : $@"); }
  }
}

sub deleteField {
  my ($field,$class) = @_;
  my $table_name = param('rh') . "_$class";
  $field =~ s/\./_/;
  my $sth = $util->dbh->prepare("ALTER TABLE $table_name DROP COLUMN $field\_");
  eval '$sth->execute();';
  if ($@) { $util->error("cannot drop column $table_name . $field\_ : $@"); }
  if ($class eq $primary_class) {
    $sth = $util->dbh->prepare(
         "ALTER TABLE ".param('rh')."_interop_objects DROP COLUMN $field\_");
    eval '$sth->execute();';
    if ($@) { $util->error("cannot add column $table_name . $field\_ : $@"); }
  }
}

sub getLegalValues {
  my ($vocabularyNode, $values, $prefix, $recursion) = @_;
  return if $recursion++ > 200;
  foreach my $child ($vocabularyNode->getChildren()) {
    push (@{$values}, $prefix.$child->term());
    &getLegalValues($child,$values,$prefix.$child->term()."!",$recursion);
  }
}


FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
