#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;

##############################################

my $util = new RIB::Util();

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
unless (param('url')) {
  $util->error("interoperation handle not specified in input");
}
unless (param('updateInterval')) {
  $util->error("update interval not specified in input");
}
unless (param('interopName')) {
  $util->error("interoperating repository name not specified in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

my $table = param('rh') . "_interop_registry";

###################################################################
# create a sequence number for the new interop info
my $seq = $util->getSequence($table);

my $sth = $util->dbh->prepare("INSERT INTO $table (name,url,handle,last_attempt,"
                            . "last_success,update_interval,log) VALUES ("
                            . $util->dbh->quote(param('interopName')) . ","
                            . $util->dbh->quote(param('url')) . ","
                            . "$seq,"
                            . "0,"
                            . "0,"
                            . param('updateInterval') . ","
                            . "'This interoperation has never been started'"
                            . ")");
eval { $sth->execute(); };
if ($@) { $util->error($@); }
print header(-type=>"text/plain"), "ok";

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
