#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;

##############################################

my $util = new RIB::Util();

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

unless (defined param('newName')) {
  $util->error("new name not specified in input");
}

my $sth = $util->dbh->prepare("UPDATE repositories SET name="
                   . $util->dbh->quote(param('newName'))
                   . " WHERE handle="
                   . param('rh'));

unless ($sth->execute) {
  $util->error($util->dbh->errstr);
}
print header(-type=>"text/plain"), "ok";

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
