#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;

my $util = new RIB::Util();
my $ribversion = $util->RibVersion();
my $ribdir = $util->RibDir();
my $riburl = $util->RibUrl();

# determine repository handle
my $repoHandle = param('rh');
unless ($repoHandle =~ /^\d+$/) {
  $util->error("Properly formatted repository handle not supplied");
}
eval { $util->dbConnect(); };
if ($@) { $util->error("Database error $@"); }

##########################################
# get repository properties
my $sth = $util->dbh->prepare("SELECT name,contact,object_approval_required,"
                            . "primary_class,primary_attribute FROM "
                            . "repositories WHERE handle=$repoHandle");
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }
unless ($sth->rows() >= 1) {
  $util->error("Bad repository handle");
}

my $row = $sth->fetchrow_hashref();
my $repoName = $row->{'name'};
my $repoContact = $row->{'contact'};
my $object_approval_required = $row->{'object_approval_required'};
my $primary_class = $row->{'primary_class'};
my $primary_attribute = $row->{'primary_attribute'};

print header,
      start_html('-title'=>"About the $repoName Repository",-BGCOLOR=>'#FFFFFF'),
<<"EOF";
<CENTER>
<FONT SIZE="+2">About the $repoName Repository</FONT>
<P><HR>
<TABLE CELLPADDING="5">
  <TR>
    <TD><STRONG>Repository contact:</STRONG></TD>
    <TD><A HREF="mailto:$repoContact">$repoContact</A></TD>
  </TR>
  <TR>
    <TD><STRONG>Primary class:</STRONG></TD>
    <TD>$primary_class</TD>
  </TR>
  <TR>
    <TD><STRONG>Primary attribute:</STRONG></TD>
    <TD>$primary_attribute</TD>
  </TR>
  <TR>
    <TD><STRONG>Interoperation handle:</STRONG></TD>
    <TD><A HREF="$riburl/repository.pl?rh=$repoHandle">$riburl/repository.pl?rh=$repoHandle</A></TD>
  </TR>
  <TR>
    <TD><STRONG>Data model:</STRONG></TD>
    <TD><A HREF="$riburl/$repoHandle/config.xml">$riburl/$repoHandle/config.xml</A></TD>
  </TR>
  <TR>
    <TD><STRONG>Catalog URL:</STRONG></TD>
    <TD><A HREF="$riburl/catalog.pl?rh=$repoHandle">$riburl/catalog.pl?rh=$repoHandle</A></TD>
  </TR>
  <TR>
    <TD><STRONG>RIB version:</STRONG></TD>
    <TD>$ribversion</TD>
  </TR>
</TABLE>
<A HREF="http://www.nhse.org/RIB/"><IMG ALIGN="CENTER" WIDTH="72" HEIGHT="82" BORDER="0" SRC="$riburl/images/poweredRIB.gif"></A>
<P><HR><P>
EOF

$sth = $util->dbh->prepare("SELECT name,url,last_success "
                         . "FROM $repoHandle\_interop_registry");
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }

if ($sth->rows() >= 1) {
  print <<"EOF";
<TABLE CELLPADDING="5" BORDER="5">
<CAPTION><STRONG>Interoperations</STRONG></CAPTION>
  <TR>
    <TH>Name</TH>
    <TH>Handle</TH>
    <TH>Last Update</TH>
  </TR>
EOF
  while (my $row = $sth->fetchrow_hashref()) {
    my $tmp = $row->{'last_success'};
    $tmp =~ /^(\d\d\d\d)(\d\d)(\d\d)/;
    my $last_update = "$2/$3/$1";
    print "<TR>",
          "<TD>", $row->{'name'}, "</TD>",
          "<TD>", $row->{'url'}, "</TD>",
          "<TD>$last_update</TD>",
          "</TR>";
  }

  print "</TABLE>";
}

print "</CENTER>", end_html;

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
