#BANGLINE

##############################################
use strict;
use RIB::Util;
use Getopt::Std;

##############################################
my $util = new RIB::Util();
my $riburl = $util->RibUrl;
my $ribdir = $util->RibDir;

###########################################################
# get command line options
my %opts;
getopt('r',\%opts);
my $repoHandle = $opts{'r'};
if ($repoHandle !~ /^\d+$/) {
  die "Properly formatted repository handle not supplied to $0";
}

eval { $util->dbConnect(); };
if ($@) { die "Can't connect to database. $@"; }

# get the interop handles that need to be updated. if checkpoint < 300 (5mins)
# then assume that the interopation might still be running
my $sth = $util->dbh->prepare("SELECT handle FROM $repoHandle\_interop_registry WHERE ((NOW()-last_attempt) > update_interval) AND (checkpoint > 300)");
eval { $sth->execute(); };
if ($@) {
  die "Database error $@";
}

while (my $row = $sth->fetchrow_arrayref()) {
  eval {
    &start_interop($row->[0]);
  };
  if ($@) {
    print STDERR "Can't start updateInterop.pl for interopation "
                 . $row->[0] . " $@";
  }
}

sub start_interop {
  my $ih = shift;
  my $pid;
  if ($pid = fork()) {
    wait;  ## parent wait on first child (should happen quickly)
    return 1;
  } elsif (defined $pid) {
    # 2nd fork forces child into background
    unless (fork()) {   # child's child
      sleep 1 until getppid == 1;
      exec "$ribdir/bin/updateInterop.pl", "-r", $repoHandle, "-i", $ih;
    }
    ## first child exits quickly
    exit (0);
  } else  { # this isn't supposed to happen
    die $!;
  }
}

