#!/bin/sh

RIBVERSION="2.1.1"
PATH=/bin:/usr/bin:/usr/local/bin:/usr/ucb:$PATH
export PATH

echo
echo "Repository in a Box (RIB), version $RIBVERSION installation"
echo
echo "This script will guide you through the RIB installation process."
echo "Press Enter to accept default values which appear in []'s. If at"
echo "any time you need to stop this script then press CTRL-C."
echo

echo "At this point you should have already installed the MySQL database."
echo "Have you installed the MySQL database? [y]"
read sql_installed
if test ! $sql_installed"x" = "x" -a ! $sql_installed"x" = "yx"; then
  echo
  echo "Before proceeding with this installation, you need to"
  echo "install MySQL database version >= 3.22. The database"
  echo "is available at the MySQL web site (http://www.mysql.com/)"
  echo "in both binary and source code formats.  "
  echo
  echo "While you are installing MySQL, please make note of the"
  echo "base install directory and the database's root password."
  echo "You will need that information when you proceed with the"
  echo "rest of the RIB installation. When you are finished"
  echo "installing MySQL, start the database and then run this"
  echo "script again to proceed with the RIB installation."
  echo
  exit
fi

echo
echo "Is the MySQL database currently running? [y]"
read sql_running
if test ! $sql_running"x" = "x" -a ! $sql_running"x" = "yx"; then
  echo
  echo "Before proceeding with this installation you need to"
  echo "start the MySQL database. Supposing that you installed the"
  echo "database at /usr/local/mysql, you can start the database"
  echo "with the following commands :"
  echo
  echo "	> cd /usr/local/mysql"
  echo "	> bin/safe_mysqld &"
  echo
  echo "After starting the database please run this script again"
  echo "to proceed with the RIB installation."
  echo
  exit
fi

echo
echo "What is the MySQL root password? []"
echo "(If you have not set the root password yet then just press Enter."
echo " Just be sure to set the password later.)"
read sql_pass

while true; do
  # get input
  echo
  echo "What is the base installation directory for MySQL? [/usr/local/mysql]"
  read sql_path
  if test $sql_path"x" = "x"; then
    sql_path=/usr/local/mysql
  fi
  if test ! -x $sql_path; then
    echo
    echo "!!!!!! Cannot cd to directory $sql_path !!!!!!"
  else
    break
  fi
done

# are $sql_path/bin/mysql and $sql_path/bin/mysqladmin executatble?
if test ! -x $sql_path/bin/mysql; then
  echo
  echo "!!!!!! Cannot execute $sql_path/bin/mysql !!!!!"
  echo
  exit
elif test ! -x $sql_path/bin/mysqladmin; then
  echo
  echo "!!!!!! Cannot execute $sql_path/bin/mysqladmin !!!!!"
  echo
  exit
else
  break
fi

echo
echo "Testing your database...."
echo 

#if $sql_path/bin/mysqladmin --socket=$sql_sock --user=root --password=$sql_pass version; then
if $sql_path/bin/mysqladmin --user=root --password=$sql_pass version; then
  echo
else
  echo
  echo "Cannot connect to the MySQL database using the following command :"
  echo
  #echo "	$sql_path/bin/mysqladmin --socket=$sql_sock --user=root --password=$sql_pass version"
  echo "	$sql_path/bin/mysqladmin --user=root --password=$sql_pass version"
  echo
  echo "Please consult the MySQL documentation to determine the cause of "
  echo "this problem and rerun this installation script when you are finshed."
  echo
  exit
fi

sql_major_ver=`$sql_path/bin/mysqld --version | cut -d' ' -f4 | cut -d'.' -f1`
sql_minor_ver1=`$sql_path/bin/mysqld --version | cut -d' ' -f4 | cut -d'.' -f2`
sql_minor_ver2=`$sql_path/bin/mysqld --version | cut -d' ' -f4 | cut -d'.' -f3`

if test $sql_major_ver"x" = "x"; then
  echo
  echo "Cannot determine MySQL version number using the command :"
  echo "	$sql_path/bin/mysqld --version"
  echo
  exit
elif test $sql_minor_ver1"x" = "x"; then
  echo
  echo "Cannot determine MySQL version number using the command :"
  echo "	$sql_path/bin/mysqld --version"
  echo
  exit
elif test $sql_minor_ver2"x" = "x"; then
  echo
  echo "Cannot determine MySQL version number using the command :"
  echo "	$sql_path/bin/mysqld --version"
  echo
  exit
fi

if test $sql_major_ver -le 3; then
  if test $sql_minor_ver1 -lt 22; then
    echo
    echo "The version of MySQL that you have installed ($sql_major_ver.$sql_minor_ver1.$sql_minor_ver2)"
    echo "is older than 3.22. Please install version >= 3.22 and then run"
    echo "this installation script again."
  fi
fi

echo
echo "Your database looks ok. Proceeding with RIB installation."

#############################################3
# determine rib path
while true; do
  echo
  echo "Where would you like to install RIB? [/usr/local/rib/rib-$RIBVERSION]"
  read rib_path
  if test $rib_path"x" = "x"; then
    rib_path="/usr/local/rib/rib-$RIBVERSION"
  fi
  if test -x $rib_path; then
    echo
    echo "The directory $rib_path already exists. Install here anyway? [y]"
    read tmp
    if test $tmp"x" = "x" -o $tmp"x" = "xy"; then
      if test -w $rib_path; then
        break
      else
        echo
        echo "!!!!!! You don't have write permissions at $rib_path !!!!!!"
      fi
    fi
  else
    echo
    echo "Ok to create directory $rib_path? [y]"
    read tmp
    if test $tmp"x" = "x" -o $tmp"x" = "xy"; then
      if mkdir $rib_path; then
        break;
      else
        echo 
        echo "!!!!!! Can't create directory $rib_path !!!!!!"
      fi
    fi
  fi
done

#############################################3
# untar distribution file
echo
echo "Extracting the RIB distribution file...."
mydir=`pwd`
if cd rib; then
  if tar -cf - . | (cd $rib_path; tar -xf -); then
    echo
  else
    echo
    echo "!!!!!! Can't copy distribution files !!!!!!"
    echo "Quitting."
    echo
    exit
  fi
else
  echo
  echo "!!!!!! Can't cd to $mydir/rib !!!!!!"
  echo "Quitting."
  echo
  exit
fi
cd $mydir

###################################################3
# determine rib user
default_usr="nobody"
if grep '^rib:' /etc/passwd >/dev/null 2>&1; then
  default_usr="rib"
fi
user=`whoami`
if test $user = "root"; then
  while true; do
    echo
    echo "Which user would you like to run the RIB server as? [$default_usr]"
    read rib_usr
    if test $rib_usr"x" = "x"; then
      rib_usr=$default_usr
      break;
    elif test $rib_usr = "root"; then
      echo
      echo "Running RIB as the user \"root\" is not recommended."
      echo "Are you sure that you want to do this? [y]"
      read tmp
      if test $tmp"x" = "x" -o $tmp"x" = "yx"; then
        break;
      fi
    else
      break;
    fi
  done
else
  echo
  echo "Since you are not currently logged in as root, you cannot"
  echo "configure the RIB server to run as any user other than who you"
  echo "are currently logged in as (\"$user\"). Is this ok? [y]"
  read tmp
  if test $tmp"x" = "x" -o $tmp"x" = "yx"; then
    rib_usr=$user
  else
    echo
    echo "To enable RIB to run as another user, please log in as root"
    echo "and then run this installation program again."
    echo
    exit
  fi
fi

###################################################3
# get the RIB password.
while true; do
  echo
  echo "Please specify a password for the RIB Management Page. The"
  echo "password should be at least 5 characters in length. Be sure"
  echo "to write the password down before proceeding. This password"
  echo "will be used to protect access to RIB's user interface."
  read rib_pass
  length=`echo $rib_pass | wc -c`
  if test $length -gt 5; then
    break
  fi
done

#sql_cmd="$sql_path/bin/mysql --socket=$sql_sock --user=root --password=$sql_pass mysql"
sql_cmd="$sql_path/bin/mysql --user=root --password=$sql_pass mysql"
echo
echo "Creating database user $rib_usr for RIB..."

create_cmd="INSERT INTO user (Host, User, Password, Select_priv, Insert_priv, Update_priv, Delete_priv, Create_priv, Drop_priv, Reload_priv, Shutdown_priv, Index_priv, Alter_priv) VALUES ('localhost','$rib_usr',password('$rib_pass'),'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');"

tmp=`echo "select count(*) from user where User='$rib_usr'" | $sql_cmd`;
tmp=`echo $tmp | cut -d' ' -f2`
if test $tmp -gt 0; then
  echo
  echo "Database user \"$rib_usr\" already exists."
  echo "Ok to change the password for this user? [y]"
  read tmp
  if test ! $tmp"x" = "x" -a ! $tmp"x" = "yx"; then
    echo
    echo "Cannot proceed with installation unless the password can"
    echo "be changed for user \"$rib_usr\". After you have figured out a"
    echo "workaround run this installation script again to install rib."
    echo
    exit
  fi
  create_cmd="UPDATE user SET Host='localhost', Password=password('$rib_pass'), Select_priv='Y', Insert_priv='Y', Update_priv='Y', Delete_priv='Y', Create_priv='Y', Drop_priv='Y', Reload_priv='Y', Shutdown_priv='Y', Index_priv='Y', Alter_priv='Y' WHERE User='$rib_usr';"
fi

if echo $create_cmd | $sql_cmd; then
  echo "Database user \"$rib_usr\" successfully created."
else
  echo "Can't create database user \"$rib_usr\". Installation aborted."
  echo
  exit
fi

tmp=`echo "show databases like 'rib';" | $sql_cmd`
if test "$tmp x" = " x"; then
  echo "Creating database for RIB..."
  #if $sql_path/bin/mysqladmin --socket=$sql_sock --user=root --password=$sql_pass create rib; then
  if $sql_path/bin/mysqladmin --user=root --password=$sql_pass create rib; then
    echo
  else
    echo
    echo "!!!!!! Can't create database \"rib\" !!!!!!"
    echo "Quitting."
    echo
    exit
  fi
else
  echo
  echo "Database for RIB has already been created."
  echo "Skipping database creation step."
  echo
fi

##########################################################
## grant access to rib database
echo
echo "granting access to rib database"
echo
db_cmd="INSERT INTO db (Host, Db, User, Select_priv, Insert_priv, Update_priv, Delete_priv, Create_priv, Drop_priv, Index_priv, Alter_priv) VALUES ('localhost','rib','$rib_usr','Y','Y','Y','Y','Y','Y','Y','Y');"
tmp=`echo "select count(*) from db where Host='localhost' and Db='rib' and User='$rib_usr';" | $sql_cmd`
tmp=`echo $tmp | cut -d' ' -f2`
if test $tmp -gt 0; then
  db_cmd="UPDATE db SET Select_priv='Y', Insert_priv='Y', Update_priv='Y', Delete_priv='Y', Create_priv='Y', Drop_priv='Y', Index_priv='Y', Alter_priv='Y' WHERE Host='localhost' and Db='rib' and User='$rib_usr'";
fi

if echo $db_cmd | $sql_cmd; then
  echo
else
  echo
  echo "!!!!!! Can't grant access to the mysql.db table !!!!!!"
  echo "Quitting."
  echo
  exit
fi


##########################################################
## create rib's internal tables
echo
echo "Creating RIB's internal tables"
echo
echo "creating repositories table"
#sql_cmd2="$sql_path/bin/mysql --socket=$sql_sock --user=root --password=$sql_pass rib"
sql_cmd2="$sql_path/bin/mysql --user=root --password=$sql_pass rib"

# repositories table
tmp=`echo "show tables like 'repositories';" | $sql_cmd2`
if test "$tmp x" = " x"; then
  if cat tables/repositories | $sql_cmd2; then
    echo
  else
    echo
    echo "!!!!!! Can't create repositories table !!!!!!"
    echo
    exit
  fi
else
  echo "repositories table already exists"
  echo
fi

# admin table
echo "creating admin table"
tmp=`echo "show tables like 'admin';" | $sql_cmd2`
if test "$tmp x" = " x"; then
  if cat tables/admin | $sql_cmd2; then
    echo
  else
    echo
    echo "!!!!!! Can't create admin table !!!!!!"
    echo
    exit
  fi
else
  echo "admin table already exists"
  echo
fi

if echo "delete from admin;" | $sql_cmd2; then
  if echo "insert into admin (password,is_locked) values ('$rib_pass',0)" | $sql_cmd2; then
    echo
  else
    echo
    echo "!!!!!! Can't set RIB password in admin table !!!!!!"
    echo
    exit
  fi
else
  echo
  echo "!!!!!! Can't set RIB password in admin table !!!!!!"
  echo
  exit
fi

# sequences table
echo "creating sequences table"
tmp=`echo "show tables like 'sequences';" | $sql_cmd2`
if test "$tmp x" = " x"; then
  if cat tables/sequences | $sql_cmd2; then
    echo
  else
    echo
    echo "!!!!!! Can't create sequences table !!!!!!"
    echo
    exit
  fi
else
  echo "sequences table already exists"
  echo
fi

##########################################################
## create the database startup script
cat > $rib_path/bin/start-db <<EOF
#!/bin/sh
if cd $sql_path; then
  if test -x bin/safe_mysqld; then
    bin/safe_mysqld &
    echo "mysqld database started"
  else
    echo "ERROR: Cannot execute $sql_path/bin/safe_mysqld. Database not started."
    exit 1
  fi
else
  echo "ERROR: Can't cd to $sql_path. Database not started."
  exit 1
fi
EOF
if chmod +x $rib_path/bin/start-db; then
  echo
else
  echo
  echo "!!!!!! Can't set permissions on $rib_path/bin/start-db !!!!!!"
  echo "Quitting."
  echo
  exit
fi

##########################################################
## create the database shutdown script
cat > $rib_path/bin/stop-db <<EOF
#!/bin/sh
if cd $sql_path; then
  if test -x bin/mysqladmin; then
    bin/mysqladmin --user=$rib_usr --password=$rib_pass shutdown
  else
    echo "ERROR: Cannot execute $sql_path/bin/mysqladmin. Database not shutdown."
    exit 1
  fi
else
  echo "ERROR: Can't cd to $sql_path. Database not shutdown."
  exit 1
fi
EOF
if chmod +x $rib_path/bin/stop-db; then
  echo
else
  echo
  echo "!!!!!! Can't set permissions on $rib_path/bin/start-db !!!!!!"
  echo "Quitting."
  echo
  exit
fi

##########################################################
## force mysql to reload the privilege tables
#if $sql_path/bin/mysqladmin --user=root --password=$sql_pass --socket=$sql_sock reload; then
if $sql_path/bin/mysqladmin --user=root --password=$sql_pass reload; then
  echo
else
  echo
  echo "!!!!!! Can't reload mysql privelege tables !!!!!!"
  echo "Quitting."
  echo
  exit
fi

##########################################################
## http port number
while true; do
  echo
  echo "Which port do you want to run the RIB HTTP server on? [80]"
  echo "If you choose a port other than 80, that port number will"
  echo "appear in ther URLs used to access your RIB repository."
  echo "e.g. http://your.machine.org:port#/"
  read http_port
  if test $http_port"x" = "x"; then 
    http_port="80"
  fi
  if test $user"x" != "rootx"; then
    if test $http_port -lt 1025; then
      echo "Since the port number is less than 1025 you must start the"
      echo "RIB server as the user root (preferably from your machine's"
      echo "startup scripts). Is this ok? [y]"
      read tmp
      if test $tmp"x" = "x" -o $tmp"x" = "yx"; then
        break
      fi
    else
      break
    fi
  else
    break
  fi
done


##########################################################
## host name
while true; do
  echo
  echo "What is the fully qualified hostname of your machine?"
  echo "e.g. www.cs.utk.edu"
  read rib_host
  if test $rib_host"x" = "x"; then
    echo
  else
    break
  fi
done


######################################################################
# Make and install perl
echo
echo "Installing perl for use by RIB...."
cd $mydir/src/perl-5.6.0
./Configure -Dprefix=$rib_path/lib/perl -Dcc=gcc -des
if make; then
	echo
else
	echo
	echo "!!!!!! Can't make perl !!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!! Can't install perl !!!!!!"
	echo "Quitting."
	echo
	exit
fi
cd $rib_path/bin
ln -s $rib_path/lib/perl/bin/perl ./perl
echo "Done."

####################################################################
# Install perl modules
echo
echo "Installing perl modules for use by RIB...."

###################################################################
# CGI.pm
cd $mydir/src/CGI.pm-2.753
$rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!! Can't make CGI.pm !!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!! Can't install CGI.pm !!!!!!"
	echo "Quitting."
	echo
	exit
fi

########################################################################
# MD5
cd $mydir/src/Digest-MD5-2.13
$rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!!! Can't make MD5.pm !!!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!! Can't install MD5.pm !!!!!!"
	echo "Quitting."
	echo
	exit
fi

#########################################################################
# MIME-Base64
cd $mydir/src/MIME-Base64-2.12
$rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!!! Can't make MIME-Base64 !!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!! Can't install MIME-Base64 !!!!!!"
	echo "Quitting."
	echo
	exit
fi

#########################################################################
# URI
cd $mydir/src/URI-1.11
$rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!! Can't make URI !!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!!! Can't install URI !!!!!!!"
	echo "Quitting."
	echo
	exit
fi

#########################################################################
# HTML-Tagset
cd $mydir/src/HTML-Tagset-3.03
$rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!! Can't make HTML-Tagset !!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!!! Can't install HTML-Tagset !!!!!!"
	echo "Quitting."
	echo
	exit
fi

##########################################################################
# HTML-Parser
cd $mydir/src/HTML-Parser-3.21
$rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!! Can't make HTML-Parser !!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!! Can't install HTML-Parser !!!!!"
	echo "Quitting."
	echo
	exit
fi

#############################################################################
# libnet
cd $mydir/src/libnet-1.0703
echo | $rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!! Can't make libnet !!!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!!! Can't install libnet !!!!!!!"
	echo "Quitting."
	echo
	exit
fi

##############################################################################
# libwww
cd $mydir/src/libwww-perl-5.53
$rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!!! Can't make libwww !!!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!! Can't install libwww !!!!!!"
	echo "Quitting."
	echo
	exit
fi

##############################################################################
# XML-Parser
cd $mydir/src/XML-Parser-2.30
$rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!! Can't make XML-Parser !!!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!!! Can't install XML-Parser !!!!!!!"
	echo "Quitting."
	echo
	exit
fi

###########################################################################
# XML-DOM
cd $mydir/src/XML-DOM-1.25
$rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!! Can't make XML-DOM !!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!! Can't install XML-DOM !!!!!!"
	echo "Quitting."
	echo
	exit
fi

#########################################################################
# DBI
cd $mydir/src/DBI-1.15
$rib_path/bin/perl Makefile.PL
if make; then
	echo
else
	echo
	echo "!!!!!! Can't make DBI !!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!!! Can't install DBI !!!!!!!"
	echo "Quitting."
	echo
	exit
fi

#########################################################################
# Mysql
cd $mydir/src/Msql-Mysql-modules-1.2216
$rib_path/bin/perl Makefile.PL --noprompt --mysql-install --nomsql-install --nomsql1-install \
                               --mysql-test-db=test --mysql-test-user=nobody \
                               --mysql-test-host=$rib_host --mysql-test-pass=undef --mysql-incdir=$sql_path/include --mysql-libdir=$sql_path/lib
if make; then
	echo
else
	echo
	echo "!!!!!! Can't make mysql.pm !!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!! Can't install mysql.pm !!!!!!"
	echo "Quitting."
	echo
	exit
fi

#########################################################################
# mod_perl
cd $mydir/src/mod_perl-1.25

if $rib_path/bin/perl Makefile.PL \
	APACHE_HEADER_INSTALL=0 \
	APACHE_PREFIX=$rib_path/lib/apache \
	APACHE_SRC=$mydir/src/apache_1.3.19 \
	DO_HTTPD=1 \
	USE_APACI=1 \
	EVERYTHING=1; then
	echo
else
	echo
	echo "!!!!!! Can't make mod_perl !!!!!!"
	echo "Quitting."
	echo
	exit
fi
if make install; then
	echo
else
	echo
	echo "!!!!!! Can't install mod_perl !!!!!!"
	echo "Quitting."
	echo
	exit
fi

#####################################################################33
## Modify apache configuration
cd $rib_path/lib/apache/conf
mv httpd.conf httpd.conf.old

##########################################################################
#
#This line was removed from the following for portability reasons:
#
#   -e  "/Group n.*/s/n.*/$rib_grp/" \
#
sed -e "/Port 8.*/s/8.*/$http_port/" \
		-e "/User n.*/s/n.*/$rib_usr/" \
    -e "/DocumentRoot \"/s%.*%DocumentRoot \"$rib_path/docRoot/\"%" \
    httpd.conf.old > httpd.conf
    #-e "/ScriptAlias \//s%.*%ScriptAlias /cgi-bin/ $rib_path/docRoot/cgi-bin/%" \

cat >> httpd.conf <<DONE
<Files *.pl>
SetHandler perl-script
PerlHandler Apache::Registry
Options +ExecCGI
</Files>
PerlSendHeader off
LockFile /var/tmp/accept.lock
DONE

cd $rib_path/bin
ln -s $rib_path/lib/apache/bin/apachectl ./apachectl
echo "Done."

if test $http_port -eq 80; then
  rib_url="http://"$rib_host
else
  rib_url="http://"$rib_host":"$http_port
fi

#####################################################################
# Modify Util.pm
rib_lib=$rib_path/lib/perl/lib/site_perl/5.6.0/RIB
mkdir $rib_lib
cd $mydir/src/RIB
cp * $rib_lib
sed -e "s%RIBDIR%$rib_path%" \
         -e "s%RIBURL%$rib_url%" \
         -e "s%RIBUSR%$rib_usr%" \
         -e "s%RIBPASS%$rib_pass%" \
         -e "s%RIBVERSION%$RIBVERSION%" \
         -e "s%SOCKET_PATH%$sql_sock%" \
         Util.pm.old > $rib_lib/Util.pm

####################################################################
# Modify RIB CGI scripts
echo
echo "Installing RIB CGI scripts...."
cd $mydir/src/CGI
cat > bangtest.pl <<DONE
#!$rib_path/bin/perl
print "good shell\n";
DONE
chmod +x bangtest.pl
if ./bangtest.pl; then
	goodbang=1
else
	goodbang=0
fi

for file in `ls *.pl`
do
	if [ $goodbang -eq 1 ]; then
		sed -e "/#BANGLINE/s%.*%#!$rib_path/bin/perl%" \
	   	$file > $rib_path/docRoot/$file
	else
		sed -e "/#BANGLINE/i\\
#!/bin/sh -- # perl \\
eval 'exec $rib_path/bin/perl -S \$0 \${1+\"\$@\"}' \\
if 0;" \
			$file > $rib_path/docRoot/$file
	fi
	chmod +x $rib_path/docRoot/$file
done 


cd $rib_path/bin
for file in `ls *.pl`
do
	if [ $goodbang -eq 1 ]; then
		sed -e "/#BANGLINE/s%.*%#!$rib_path/bin/perl%" \
	   	$file > $file.new
	else
		sed -e "/#BANGLINE/i\\
#!/bin/sh -- # perl \\
eval 'exec $rib_path/bin/perl -S \$0 \${1+\"\$@\"}' \\
if 0;" \
			$file > $file.new
	fi
        if test -s $file.new; then
	  chmod +x $file.new
          rm $file
          mv -f $file.new $file
        else
          echo
          echo "!!!!!! Can't substitute bangline in $file !!!!!!"
          echo
          exit
        fi
done 
echo "Done."

echo
echo "Creating startup scripts...."
cat > $rib_path/bin/start-rib <<DONE
#!/bin/sh
if $rib_path/bin/start-db; then
	echo
else
	echo
	echo "!!!!!! Unable to start mysql database !!!!!!"
	echo 
	exit 1
fi
if $rib_path/lib/apache/bin/httpd -d $rib_path/lib/apache; then
	echo
else
	echo
	echo "!!!!!! Unable to start apache !!!!!!"
	echo
	exit 1
fi
DONE
chmod +x $rib_path/bin/start-rib

cat > $rib_path/bin/stop-rib <<DONE
#!/bin/sh
if $rib_path/bin/stop-db; then
	echo
else
	echo
	echo "!!!!!! Unable to stop mysql database !!!!!!"
	echo
fi
if $rib_path/bin/apachectl stop; then
	echo
else
	echo
	echo "!!!!!! Unable to stop apache !!!!!!"
	echo
fi
DONE
chmod +x $rib_path/bin/stop-rib

if test $user = "root"; then
  chown -R $rib_usr $rib_path
fi

if $rib_path/bin/stop-db; then
  echo
fi

echo
echo "Starting RIB...."
cd $rib_path/bin
if ./start-rib; then
  echo
  echo "RIB was successfully installed. You can access the administration"
  echo "pages by pointing your web browser at :"
  echo
  echo "	$rib_url/top.pl"
  echo
  echo "and using the RIB password that you entered before."
  echo
  echo "If you want RIB to automatically start when the machine reboots"
  echo "then you need to make sure that the following script gets run"
  echo "at startup time :"
  echo
  echo "	$rib_path/bin/start-rib"
  echo
  echo "If you want RIB's interoperation scheduler to run automatically"
  echo "then you need to use cron to set up a job that runs at 15 minute"
  echo "intervals and executes the following script :"
  echo
  echo "	$rib_path/bin/updateAllInterops.pl"
  echo
  echo "This can probably be done by typing \"crontab -e\" and inserting the"
  echo "following line :"
  echo
  echo "0,15,30,45 * * * * $rib_path/bin/updateAllInterops.pl"
  echo
else
  echo
  echo "RIB was NOT successfully installed."
  echo
fi
