/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibConfig;
import org.nhse.rib.RibInterface;
import org.nhse.rib.RibObjectBrowser;
import org.nhse.rib.TableSorter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RibObjectBrowser
extends JPanel {
    String className;
    RibComm ribComm;
    RibInterface ribInterface;
    Vector objectList = new Vector();
    Vector columnNames = new Vector();
    JTable table;
    TableSorter sorter;
    JScrollPane scrollpane;
    JComboBox classCombo;
    JButton createButton;
    JButton importButton;
    JButton refreshButton;

    public RibObjectBrowser(RibInterface ri, RibComm rc, String cn) {
        this.setLayout(new FlowLayout(1, 5, 5));
        this.setBackground(Color.white);
        this.setSize(0, 0);
        this.ribInterface = ri;
        this.ribComm = rc;
        this.className = cn;
        this.setLayout(new BorderLayout());
        this.sorter = new TableSorter(new MyTableModel());
        this.table = new JTable(this.sorter);
        this.table.setShowHorizontalLines(false);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.addMouseListener(new PopupListener());
        this.scrollpane = new JScrollPane(this.table);
        this.add((Component)this.scrollpane, "Center");
        JToolBar jtb = new JToolBar();
        jtb.setBorder(new BevelBorder(1));
        ((Container)jtb).setLayout(new BoxLayout(jtb, 0));
        jtb.setFloatable(false);
        RibConfig config = new RibConfig(this.ribInterface.configUrl);
        config.parse();
        JPanel classPanel = new JPanel(new FlowLayout(0));
        if (config.getClassNames(false).size() == 0) {
            this.ribInterface.showAlert("Error : Cannot parse repository configuration");
        } else {
            classPanel = new JPanel(new FlowLayout(0));
            JLabel myLabel = new JLabel("Class :");
            classPanel.add(myLabel);
            Vector v = config.getClassNames(false);
            this.classCombo = new JComboBox(v);
            this.classCombo.setSelectedItem(this.className);
            this.classCombo.addActionListener(new 1());
            this.classCombo.setBackground(Color.white);
            this.classCombo.setMaximumRowCount(this.classCombo.getItemCount());
            this.classCombo.setToolTipText("Work with another class");
            classPanel.add(this.classCombo);
        }
        classPanel.setMaximumSize(classPanel.getPreferredSize());
        jtb.add(classPanel);
        this.createButton = new JButton("  Create  ");
        this.createButton.addMouseListener(new ButtonPushMouseListener(this.createButton));
        jtb.add(this.createButton);
        this.createButton.setToolTipText("Create a new " + this.className);
        this.createButton.addActionListener(new 2());
        jtb.add(Box.createHorizontalStrut(2));
        this.importButton = new JButton("  Import  ");
        this.importButton.addMouseListener(new ButtonPushMouseListener(this.importButton));
        jtb.add(this.importButton);
        this.importButton.setToolTipText("Import a new " + this.className);
        this.importButton.addActionListener(new 4());
        this.refreshButton = new JButton("  Refresh  ");
        this.refreshButton.addMouseListener(new ButtonPushMouseListener(this.refreshButton));
        jtb.add(Box.createHorizontalStrut(2));
        jtb.add(this.refreshButton);
        this.refreshButton.setToolTipText("Contact server to refresh the list below");
        this.refreshButton.addActionListener(new 5());
        HelpButton helpButton = new HelpButton("object_browser.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, this.refreshButton.getPreferredSize().height));
        helpButton.setToolTipText("Display help on the object browser");
        jtb.add(Box.createHorizontalStrut(2));
        jtb.add(helpButton);
        this.createButton.setAlignmentY(0.5f);
        this.importButton.setAlignmentY(0.5f);
        this.refreshButton.setAlignmentY(0.5f);
        classPanel.setAlignmentY(0.5f);
        helpButton.setAlignmentY(0.5f);
        this.createButton.setAlignmentX(0.5f);
        this.importButton.setAlignmentX(0.5f);
        this.refreshButton.setAlignmentX(0.5f);
        classPanel.setAlignmentX(0.5f);
        helpButton.setAlignmentX(0.5f);
        this.add((Component)jtb, "North");
        this.refreshTable();
    }

    public void refresh() {
        this.createButton.setEnabled(true);
        this.importButton.setEnabled(true);
        RibConfig config = new RibConfig(this.ribInterface.configUrl);
        config.parse();
        this.classCombo.removeAllItems();
        Vector classNames = config.getClassNames(false);
        int i = 0;
        while (i < classNames.size()) {
            this.classCombo.addItem(classNames.elementAt(i));
            ++i;
        }
        if (config.getClassNames(false).size() == 0) {
            this.ribInterface.showAlert("Error : Cannot parse repository configuration");
        } else {
            this.classCombo.setMaximumRowCount(this.classCombo.getItemCount());
            if (config.getClass(this.className) == null) {
                this.ribInterface.showAlert("The " + this.className + " class has been deleted from the repository configuration.\nPlease choose another class in the Class selection box.");
                this.remove(this.table);
                this.table = new JTable();
                this.table.setBackground(Color.white);
                this.add((Component)this.table, "Center");
                this.createButton.setEnabled(false);
                this.importButton.setEnabled(false);
            } else {
                this.classCombo.setSelectedItem(this.className);
            }
        }
    }

    public void refreshTable() {
        this.ribInterface.showStatus("Accessing network...");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
        NodeList nl = null;
        try {
            try {
                nl = this.ribComm.listObjects(this.className);
            }
            catch (Exception e) {
                this.ribInterface.showAlert(e.toString());
            }
            Object var3_4 = null;
            this.ribInterface.showStatus("");
            this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.ribInterface.showStatus("");
            this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.objectList = new Vector(nl.getLength());
        int i = 0;
        while (i < nl.getLength()) {
            Element element = (Element)nl.item(i);
            String name = element.getAttribute("name");
            String handle = element.getAttribute("handle");
            String last_modified = element.getAttribute("last_modified");
            String approved = element.getAttribute("approved");
            String url = element.getAttribute("url");
            if (name != null && handle != null && last_modified != null && approved != null && url != null) {
                Vector<String> objectInfo = new Vector<String>(4);
                objectInfo.addElement(name);
                try {
                    String dateString = String.valueOf(last_modified.substring(0, 4)) + "/" + last_modified.substring(4, 6) + "/" + last_modified.substring(6, 8) + " at " + last_modified.substring(8, 10) + ":" + last_modified.substring(10, 12);
                    objectInfo.addElement(dateString);
                }
                catch (Exception e) {
                    System.err.println(e.toString());
                    objectInfo.addElement("????");
                }
                if (approved.equals("1")) {
                    objectInfo.addElement("approved");
                } else if (approved.equals("0")) {
                    objectInfo.addElement("not approved");
                } else {
                    objectInfo.addElement("????");
                }
                objectInfo.addElement(handle);
                objectInfo.addElement(url);
                this.objectList.addElement(objectInfo);
            }
            ++i;
        }
        this.sorter.tableChanged(new TableModelEvent(this.table.getModel()));
        this.sorter.sortByColumn(0);
        this.table.clearSelection();
    }

    private final class 1
    implements ActionListener {
        /* synthetic */ 1() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (RibObjectBrowser.this.classCombo.getSelectedItem() != null) {
                RibObjectBrowser.this.ribInterface.showObjectsList((String)RibObjectBrowser.this.classCombo.getSelectedItem());
            }
        }
    }

    private final class 2
    implements ActionListener {
        /* synthetic */ 2() {
        }

        public void actionPerformed(ActionEvent ae) {
            SwingUtilities.invokeLater(new 3(RibObjectBrowser.this));
        }
    }

    private final class 4
    implements ActionListener {
        /* synthetic */ 4() {
        }

        public void actionPerformed(ActionEvent ae) {
            String url = (String)JOptionPane.showInputDialog(RibObjectBrowser.this.ribInterface, "URL : ", null, 3, null, null, null);
            if (url == null) {
                return;
            }
            url.trim();
            if (url.length() == 0) {
                return;
            }
            if (url.indexOf("://") == -1) {
                url = "http://" + url;
            }
            if (url.indexOf("&html=1") != -1) {
                int index = url.indexOf("&html=1");
                String newUrl = url.substring(0, index);
                if (newUrl.length() < url.length() - 7) {
                    newUrl = String.valueOf(newUrl) + url.substring(index + 7, url.length());
                }
                url = newUrl;
            } else if (url.indexOf("html=1") != -1) {
                int index = url.indexOf("html=1&");
                String newUrl = url.substring(0, index);
                url = newUrl = String.valueOf(newUrl) + url.substring(index + 7, url.length());
            } else if (url.indexOf("/catalog/" + RibObjectBrowser.this.className + "/") != -1) {
                int index = url.indexOf("/catalog/");
                String newUrl = url.substring(0, index);
                newUrl = String.valueOf(newUrl) + "/objects";
                url = newUrl = String.valueOf(newUrl) + url.substring(index + 8, url.length());
            }
            try {
                new URL(url);
            }
            catch (Exception exception) {
                RibObjectBrowser.this.ribInterface.showAlert("Improperly formatted URL");
                return;
            }
            RibObjectBrowser.this.ribInterface.importObject(url, RibObjectBrowser.this.className);
        }
    }

    private final class 5
    implements ActionListener {
        /* synthetic */ 5() {
        }

        public void actionPerformed(ActionEvent ae) {
            RibObjectBrowser.this.ribInterface.showStatus("Accessing network...");
            RibObjectBrowser.this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
            RibObjectBrowser.this.refresh();
            RibObjectBrowser.this.ribInterface.showStatus("");
            RibObjectBrowser.this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Name", "Last Modified", "Status"};

        MyTableModel() {
            RibObjectBrowser.this = RibObjectBrowser.this;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int row) {
            return this.columnNames[row];
        }

        public int getRowCount() {
            return RibObjectBrowser.this.objectList.size();
        }

        public Object getValueAt(int row, int col) {
            Vector v = (Vector)RibObjectBrowser.this.objectList.elementAt(row);
            return v.elementAt(col);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object obj, int row, int col) {
            Vector v = (Vector)RibObjectBrowser.this.objectList.elementAt(row);
            v.setElementAt(obj, col);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
            RibObjectBrowser.this = RibObjectBrowser.this;
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            if (e.getClickCount() == 2) {
                int index = RibObjectBrowser.this.table.getSelectedRow();
                String objectHandle = (String)RibObjectBrowser.this.sorter.getValueAt(index, 3);
                String url = (String)RibObjectBrowser.this.sorter.getValueAt(index, 4);
                RibObjectBrowser.this.ribInterface.editObject(url, objectHandle, RibObjectBrowser.this.className);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void showPopup(MouseEvent e) {
            if (!SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            int rowCount = RibObjectBrowser.this.table.getSelectedRowCount();
            if (rowCount < 1) {
                return;
            }
            JPopupMenu jpm = new JPopupMenu();
            JMenuItem edit = new JMenuItem("Edit");
            edit.addActionListener(new 6(this));
            jpm.add(edit);
            if (rowCount > 1) {
                edit.setEnabled(false);
            }
            JMenu view = new JMenu("View");
            jpm.add(view);
            if (rowCount > 1) {
                view.setEnabled(false);
            }
            JMenuItem html = new JMenuItem("HTML");
            view.add(html);
            html.addActionListener(new 7(this));
            JMenuItem xml = new JMenuItem("XML");
            view.add(xml);
            xml.addActionListener(new 8(this));
            JMenuItem delete = new JMenuItem("Delete");
            delete.addActionListener(new 9(rowCount, this));
            jpm.add(delete);
            JMenu status = new JMenu("Set status");
            jpm.add(status);
            JMenuItem approve = new JMenuItem("Approved");
            approve.addActionListener(new 10(rowCount, this));
            status.add(approve);
            JMenuItem not_approved = new JMenuItem("Not Approved");
            not_approved.addActionListener(new 11(rowCount, this));
            status.add(not_approved);
            jpm.pack();
            if (e.getY() - RibObjectBrowser.this.scrollpane.getViewport().getViewPosition().y + jpm.getPreferredSize().height > RibObjectBrowser.this.scrollpane.getViewport().getHeight()) {
                jpm.show(e.getComponent(), e.getX(), e.getY() - jpm.getPreferredSize().height);
            } else {
                jpm.show(e.getComponent(), e.getX(), e.getY());
            }
            jpm.revalidate();
        }

        static /* synthetic */ RibObjectBrowser access$0(PopupListener $0) {
            return $0.RibObjectBrowser.this;
        }
    }
}

