#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;

my $util = new RIB::Util();
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
unless (param('template')) {
  $util->error("new template not supplied in input");
}
unless (param('templateURL')) {
  $util->error("template URL not supplied in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

my $templateURL = param('templateURL');
my ($fileName) = $templateURL =~ m/([\w\.-]+)$/;
unless ($fileName) {
  $util->error("Improperly formatted template URL : $templateURL");
}
my $template = "$ribdir/docRoot/" . param('rh') . "/$fileName";
unless (open(TEMPLATE,">$template")) {
  $util->error("Can't write to $template : $!");
}
unless (print TEMPLATE param('template')) {
  $util->error("Can't write to $template : $!");
}
close (TEMPLATE);
print header(-type=>"text/plain"), "ok";

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
