#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Parser;
use RIB::Util;
use RIB::RepositoryCreator;

##############################################
my $rp = new RIB::Parser;
my $util = new RIB::Util;
my $rc = new RIB::RepositoryCreator;
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;
my $sth = undef;
my $repo_handle;

my $RelAttrNameMaxSize = 50;

unless (param('password'))
{
  print header,
        start_html('-title'=>'Enter RIB password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Enter RIB Password')),
        p,hr,p,
        "Please enter the main RIB password in the form below<p>\n",
        start_form,
        password_field(-name=>'password', -size=>50, -maxlength=>80),
        submit(-value=>'Submit'), end_form, end_html;
  goto FALLOFF;
}

$util->dbConnect();
$util->authenticate(param('password'),undef);
my $password = param('password');

unless (param('start')) {
  print header;
  print <<"EOF";
<HTML>
<HEAD>
<TITLE>Create new repository</TITLE>
<SCRIPT LANGUAGE="JavaScript1.2">
  function select_simple () {
    document.myForm.use_nhse[0].checked = false;
    document.myForm.use_nhse[1].checked = true;
    document.myForm.use_acf[0].checked = false;
    document.myForm.use_acf[1].checked = true;
    document.myForm.use_iprf[0].checked = false;
    document.myForm.use_iprf[1].checked = true;
    document.myForm.use_deploy[0].checked = false;
    document.myForm.use_deploy[1].checked = true;
  }
  function select_bidm () {
    document.myForm.use_simple[0].checked = false;
    document.myForm.use_simple[1].checked = true;
  }
  function check_form () {
    if (document.myForm.name.value.length == 0) {
      alert("Please specify a name for the new repository.");
      return false;
    }
    if (document.myForm.contact.value.length == 0) {
      alert("Please specify a contact for the new repository.");
      return false;
    }
    if (document.myForm.new_password.value.length == 0) {
      alert("Please specify a password for the new repository.");
      return false;
    }
    if (document.myForm.new_password.value != document.myForm.new_password2.value) {
      alert("The passwords that you entered don't match. Please reenter the passwords and then resubmit.");
      document.myForm.new_password.value = "";
      document.myForm.new_password2.value = "";
      return false;
    }
    if (document.myForm.new_password.value.length < 5) {
      alert("Please choose a password that contains at least five characters.");
      return false;
    }
    return true;
  }
</SCRIPT>
</HEAD>
<BODY BGCOLOR="#FFFFFF">
<CENTER><H1>Create a new repository</H1></CENTER>
<P><HR><P>
To create a new repository, please supply a name, contact email address, and
password in the form below. The password should be at least five characters.
The new repository will use the
<A HREF="$riburl/doc/top_help.html#bidm">Basic Interoperability
Data Model (BIDM)</A> by default. You can also include one or more
of the BIDM extensions if desired.
<P>
After creating the repository,
you can change the data model by going to the administration
page for the repository. Using the data model editor, you can either customize
the BIDM or import a data model from another RIB repository.
<P><HR><P>
<FORM onSubmit="return check_form()" ACTION="createRepository.pl" METHOD="POST" NAME="myForm">
<TABLE BORDER=1 CELLPADDING=5>
  <TR>
    <TD>Name for new<br>repository:</TD>
    <TD><INPUT NAME="name" SIZE="50" MAXLENGTH="128"></TD>
  </TR>
  <TR>
    <TD>Contact email address:</TD>
    <TD><INPUT NAME="contact" SIZE="50" MAXLENGTH="128"></TD>
  </TR>
  <TR>
    <TD>Password for new<br>repository (5 or more chars):</TD>
    <TD><INPUT NAME="new_password" TYPE="password" SIZE="50" MAXLENGTH="128"></TD>
  </TR>
  <TR>
    <TD>Retype new password:</TD>
    <TD><INPUT NAME="new_password2" TYPE="password" SIZE="50" MAXLENGTH="128"></TD>
  </TR>
  <TR>
    <TD>Include <A HREF="../doc/bidm.html#extensions">Standard NHSE</A><BR>extensions?</TD>
    <TD><INPUT NAME="use_nhse" onClick='select_bidm()' TYPE="radio" CHECKED VALUE="1">Yes
        <INPUT NAME="use_nhse" TYPE="radio" VALUE="0">No</TD>
  </TR>
  <TR>
    <TD>Include <A HREF="../doc/bidm.html#extensions">Asset Certification<BR>Framework</A>
        extensions?</TD>
    <TD><INPUT NAME="use_acf" onClick='select_bidm()' TYPE="radio" VALUE="1">Yes
        <INPUT NAME="use_acf" TYPE="radio" CHECKED VALUE="0">No</TD>
  </TR>
  <TR>
    <TD>Include <A HREF="../doc/bidm.html#extensions">Intellectual Property<BR>Rights Framework</A>
        extensions?</TD>
    <TD><INPUT NAME="use_iprf" onClick='select_bidm()' TYPE="radio" VALUE="1">Yes
        <INPUT NAME="use_iprf" TYPE="radio" CHECKED VALUE="0">No</TD>
  </TR>
  <TR>
    <TD>Include <A HREF="../doc/bidm.html#extensions">NHSE Deployment</A><BR>extensions?</TD>
    <TD><INPUT NAME="use_deploy" onClick='select_bidm()' TYPE="radio" VALUE="1">Yes
        <INPUT NAME="use_deploy" TYPE="radio" CHECKED VALUE="0">No</TD>
  </TR>
  <TR>
    <TD>Use <A HREF="../doc/bidm.html#simple">Simplified BIDM</A>?</TD>
    <TD><INPUT NAME="use_simple" onClick='select_simple()' TYPE="radio" VALUE="1">Yes
        <INPUT NAME="use_simple" TYPE="radio" CHECKED VALUE="0">No</TD>
  </TR>
</TABLE>
<INPUT TYPE="hidden" NAME="password" VALUE="$password">
<INPUT TYPE="hidden" NAME="start" VALUE="1">
<P>
<INPUT TYPE="submit" VALUE="Submit">
</FORM>
</BODY>
</HTML>
EOF
  goto FALLOFF;
}

##############################################
# check inputs

# clear leading and trailing whitespace
foreach ('name','contact') {
  my $tmp = param($_);
  $tmp =~ s/^\s*//; $tmp =~ s/\s*$//;
  param($_,$tmp);
}
unless (param('name')) {
  $util->error("a repository name was not specified in your input");
}
unless (param('contact') =~ /.+@.+/) {
  $util->error("an email address should be supplied for the contact");
}
unless (defined(param('new_password'))) {
  $util->error("a password was not specified in your input");
}
unless (length(param('new_password')) >= 5) {
  $util->error("password should contain at least 5 characters");
}
unless (param('new_password') eq param('new_password2')) {
  $util->error("passwords didn't match");
}

##############################################
# load configuration

my $config_file = "$ribdir/conf/";

if (param('use_simple')) {
  $config_file .= "Simple";
}
else {
  $config_file .= "BIDM";
  if (param('use_acf')) {
    $config_file .= "_ACF";
  }
  if (param('use_iprf')) {
    $config_file .= "_IPRF";
  }
  if (param('use_deploy')) {
    $config_file .= "_Deploy";
  }
  if (param('use_nhse')) {
    $config_file .= "_NHSE";
  }
}
$config_file .= ".xml";

unless (open (INPUT,"<$config_file")) {
  $util->error("Can't open $config_file");
}
my $tmp = $/;
$/ = undef;
my $config_xml = <INPUT>;
$/ = $tmp;
close INPUT;
my $response;
eval {
  $response = $rc->createRepository($config_xml,param('name'),param('contact'),
                                    param('new_password'),$util);
};
if ($@) {
  $util->error($@);
}
if ($response !~ /^\d+$/) {
  $util->error($response);
}
$repo_handle = $response;

print header,
      start_html('-title'=>'Create a new repository', -BGCOLOR=>'#FFFFFF'),
      center(h1('Create a new repository')),
      p,hr,p,
      "The repository was successfully created.",
      p,
      start_form(-action=>'top.pl'),
      hidden(-name=>'password'),
      submit(-value=>'Return to the RIB management page'),
      end_form,
      start_form(-action=>"adminRepository.pl?rh=$repo_handle"),
      hidden(-name=>'password'),
      hidden(-name=>'rh', -value=>$repo_handle),
      hidden(-name=>'came_from_top', -value=>'1'),
      submit(-value=>'Go to the administration page for '
                   . param('name')),
      end_form,
      end_html;

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
