/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibInterface;

public class RibTemplateEditor
extends JDialog {
    Cursor waitCursor = Cursor.getPredefinedCursor(3);
    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    RibInterface ribInterface;
    JTextArea jTextArea;
    JTextArea key;
    RibComm ribComm;
    JButton saveButton;
    JButton cancelButton;
    String url;
    JScrollPane editScrollPane;
    JScrollPane keyScrollPane;
    boolean fComponentsAdjusted = false;

    public RibTemplateEditor(RibInterface ri, RibComm rc, Frame parent) {
        super(parent, true);
        this.setTitle("Template Editor");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(0, 0);
        this.setVisible(false);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.ribInterface = ri;
        this.ribComm = rc;
        JToolBar jtb2 = new JToolBar();
        ((Container)jtb2).setLayout(new FlowLayout());
        this.saveButton = new JButton("  Save  ");
        this.cancelButton = new JButton("  Cancel  ");
        this.jTextArea = new JTextArea(30, 50);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setWrapStyleWord(true);
        this.jTextArea.setCursor(Cursor.getPredefinedCursor(2));
        this.jTextArea.getDocument().addDocumentListener(new 1());
        this.editScrollPane = new JScrollPane(this.jTextArea);
        this.getContentPane().add((Component)this.editScrollPane, "Center");
        this.key = new JTextArea(30, 50);
        this.key.setBackground(Color.black);
        this.key.setForeground(Color.white);
        this.key.setEditable(false);
        this.key.setText("\nSubstitution Keys\n==================================\n\n<!-- RIB -->\n     Placeholder for information generated by RIB\n\nABOUT_URL\n     URL to repository information page generated by RIB\n\nADVANCED_SEARCH_URL\n     URL to the repository Advanced Search page\n\nCATALOG_URL\n     Replaced with URL to the repository Catalog\n\nDATA_MODEL_URL\n     URL to the repository data model\n\nJOIN_URL\n     Replaced with URL to the repository Join page\n\nREPOSITORY_HANDLE\n     The repository's interoperation handle\n\nREPOSITORY_CONTACT\n     Replaced with the repository's contact email address\n\nREPOSITORY_NAME\n     Replaced with the repository name\n\nRIB_LOGO\n     The \"Powered By RIB\" logo in an HTML anchor tag\n\nSEARCH_URL\n     Replaced with URL to the repository Search page\n\nWHATS_NEW_URL\n     Replaced with URL to the repository What's New page");
        this.key.setCaretPosition(0);
        this.keyScrollPane = new JScrollPane(this.key);
        this.keyScrollPane.setHorizontalScrollBarPolicy(31);
        this.key.setCursor(Cursor.getPredefinedCursor(2));
        jtb2.setFloatable(false);
        this.cancelButton.addActionListener(new 2());
        this.saveButton.setEnabled(false);
        this.saveButton.addMouseListener(new ButtonPushMouseListener(this.saveButton));
        this.saveButton.addActionListener(new 3());
        this.cancelButton.addMouseListener(new ButtonPushMouseListener(this.cancelButton));
        JButton keyButton = new JButton("  View Substitution Keys  ");
        keyButton.addMouseListener(new ButtonPushMouseListener(keyButton));
        keyButton.addActionListener(new 4(keyButton, this));
        HelpButton helpButton = new HelpButton("catalog_templates.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, this.cancelButton.getPreferredSize().height));
        helpButton.setPreferredSize(new Dimension(helpButton.getPreferredSize().width, this.cancelButton.getPreferredSize().height));
        helpButton.setToolTipText("Display help on the template editor");
        jtb2.add(this.saveButton);
        jtb2.add(this.cancelButton);
        jtb2.add(keyButton);
        jtb2.add(helpButton);
        this.getContentPane().add((Component)jtb2, "South");
    }

    void RibTemplateEditor_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        ((Component)this).setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        int i = 0;
        while (i < components.length) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
            ++i;
        }
        this.fComponentsAdjusted = true;
    }

    public void loadURL(String url) {
        this.url = url;
        this.jTextArea.setText("");
        try {
            String inputLine;
            URL u = new URL(url);
            URLConnection uc = u.openConnection();
            uc.setUseCaches(false);
            InputStream is = (InputStream)uc.getContent();
            String content = new String();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((inputLine = reader.readLine()) != null) {
                content = String.valueOf(content) + inputLine + '\n';
            }
            this.jTextArea.setText(content);
            this.jTextArea.setCaretPosition(0);
        }
        catch (Exception e) {
            this.ribInterface.showAlert(e.toString());
            return;
        }
        this.pack();
    }

    public void setVisible(boolean b) {
        if (b) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(b);
    }

    private final class 1
    implements DocumentListener {
        /* synthetic */ 1() {
        }

        public void changedUpdate(DocumentEvent de) {
            RibTemplateEditor.this.saveButton.setEnabled(true);
        }

        public void insertUpdate(DocumentEvent de) {
            RibTemplateEditor.this.saveButton.setEnabled(true);
        }

        public void removeUpdate(DocumentEvent de) {
            RibTemplateEditor.this.saveButton.setEnabled(true);
        }
    }

    private final class 2
    implements ActionListener {
        /* synthetic */ 2() {
        }

        public void actionPerformed(ActionEvent ae) {
            RibTemplateEditor.this.setVisible(false);
            RibTemplateEditor.this.dispose();
        }
    }

    private final class 3
    implements ActionListener {
        /* synthetic */ 3() {
        }

        public void actionPerformed(ActionEvent ae) {
            String newTemplate = RibTemplateEditor.this.jTextArea.getText();
            newTemplate.trim();
            if (newTemplate.length() == 0) {
                RibTemplateEditor.this.ribInterface.showAlert("Can't save an empty template");
                RibTemplateEditor.this.saveButton.setEnabled(false);
                return;
            }
            if (newTemplate.indexOf("<!-- RIB -->") == -1) {
                RibTemplateEditor.this.ribInterface.showAlert("Template must contain <!-- RIB --> somewhere in its text.");
                RibTemplateEditor.this.saveButton.setBorder(new BevelBorder(0));
                RibTemplateEditor.this.saveButton.setEnabled(false);
                return;
            }
            ((Component)RibTemplateEditor.this).setCursor(RibTemplateEditor.this.waitCursor);
            RibTemplateEditor.this.ribInterface.showStatus("Accessing network...");
            try {
                try {
                    String response = RibTemplateEditor.this.ribComm.saveTemplate(RibTemplateEditor.this.url, newTemplate);
                    if (!response.equals("ok")) {
                        RibTemplateEditor.this.ribInterface.showAlert(response);
                    } else {
                        RibTemplateEditor.this.setVisible(false);
                        RibTemplateEditor.this.dispose();
                    }
                }
                catch (Exception e2) {
                    RibTemplateEditor.this.ribInterface.showAlert(e2.toString());
                }
                Object var4_5 = null;
                ((Component)RibTemplateEditor.this).setCursor(RibTemplateEditor.this.defaultCursor);
                RibTemplateEditor.this.ribInterface.showStatus("");
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ((Component)RibTemplateEditor.this).setCursor(RibTemplateEditor.this.defaultCursor);
                RibTemplateEditor.this.ribInterface.showStatus("");
                throw throwable;
            }
        }
    }

    private static final class 4
    implements ActionListener {
        private final /* synthetic */ JButton val$keyButton;
        private final /* synthetic */ RibTemplateEditor this$0;

        /* synthetic */ 4(JButton val$keyButton, RibTemplateEditor this$0) {
            this.val$keyButton = val$keyButton;
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.this$0.jTextArea.isShowing()) {
                this.this$0.getContentPane().remove(this.this$0.editScrollPane);
                this.this$0.getContentPane().add((Component)this.this$0.keyScrollPane, "Center");
                this.val$keyButton.setText("  Return to template  ");
                this.this$0.saveButton.setVisible(false);
                this.this$0.cancelButton.setVisible(false);
            } else {
                this.this$0.getContentPane().remove(this.this$0.keyScrollPane);
                this.this$0.getContentPane().add((Component)this.this$0.editScrollPane, "Center");
                this.val$keyButton.setText("  View Substitution Keys  ");
                this.this$0.saveButton.setVisible(true);
                this.this$0.cancelButton.setVisible(true);
            }
            this.this$0.pack();
            this.this$0.repaint();
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
            RibTemplateEditor.this = RibTemplateEditor.this;
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == RibTemplateEditor.this) {
                RibTemplateEditor.this.RibTemplateEditor_WindowClosing(event);
            }
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Key"};
        String[] vals = new String[]{"ADVANCED_SEARCH_URL", "   URL to the repository Advanced Search page", "CATALOG_URL", "   URL to the repository Catalog", "DATA_MODEL_URL", "   URL to the repository data model", "JOIN_URL", "   URL to the repository Join page", "REPOSITORY_CONTACT", "   The contact email address", "REPOSITORY_NAME", "   The name of the repository", "REPOSITORY_HANDLE", "   The repository's interoperation handle", "SEARCH_URL", "   URL to the repository Search page", "WHATS_NEW_URL", "   URL to the repository What's New page"};

        MyTableModel() {
            RibTemplateEditor.this = RibTemplateEditor.this;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int row) {
            return this.columnNames[row];
        }

        public int getRowCount() {
            return 12;
        }

        public Object getValueAt(int row, int col) {
            return this.vals[row];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

