
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *	pvmfrag.h
 *
 *	Frag buffer util.
 *
$Log: pvmfrag.h,v $
 * Revision 1.3  1995/05/17  16:43:54  manchek
 * added support for CSPP shared memory
 *
 * Revision 1.2  1994/06/03  20:38:25  manchek
 * version 3.3.0
 *
 * Revision 1.1  1993/08/30  23:26:51  manchek
 * Initial revision
 *
 */

struct frag {
	struct frag *fr_link;	/* chain or 0 */
	struct frag *fr_rlink;
	char *fr_buf;			/* buffer or zero if master frag */
	char *fr_dat;			/* data */
	int fr_max;				/* size of buffer */
	int fr_len;				/* length of data */
	struct {
		int ref : 16;		/* refcount (of chain if master else of frag) */
		int dab : 1;		/* buffer is a databuf */
		int spr : 1;		/* sparse data (csz, lnc valid) */
	} fr_u;
	int fr_csz;				/* chunk size */
	int fr_lnc;				/* lead to next chunk */
#ifdef IMA_CSPP
	int fr_num_unpacked;	/* so we know how much to flush */
#endif
};

struct frag *fr_new __ProtoGlarp__(( int n ));
struct frag *fr_snew __ProtoGlarp__(( char *cp, int n ));
void fr_unref __ProtoGlarp__(( struct frag *f ));

