
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *	pvmdmp.h
 *
$Log: pvmdmp.h,v $
 * Revision 1.6  1995/07/25  17:37:26  manchek
 * mpp_output returns int
 *
 * Revision 1.5  1995/06/16  16:12:47  manchek
 * declare special mpp_load for PGON
 *
 * Revision 1.4  1995/05/30  17:48:30  manchek
 * mpp_free() takes struct task instead of tid.
 * Refined TIDISNODE macro
 *
 * Revision 1.3  1995/02/01  21:32:54  manchek
 * added nenv and envp args to mpp_load
 *
 */

#define TIMEOUT     10000       /* for select(); in usec */
/* determine if task is a node process */
#define TIDONNODE   0x00020000  /* this bit is set for node tasks */
#define TIDISNODE(x)	(!((x)&(TIDGID|TIDPVMD)) && ((x)&TIDONNODE))

void mpp_init __ProtoGlarp__((int *argc, char **argv));
void mpp_free __ProtoGlarp__((struct task *tp));
#if defined(IMA_PGON)
int mpp_load __ProtoGlarp__((int flags, char *name, char **argv, int count,
    int *tids, int ptid, int nenv, char **envp, int outtid, int outcod,
    int trctid, int trccod));
#else
int mpp_load __ProtoGlarp__((int flags, char *name, char **argv, int count,
    int *tids, int ptid, int nenv, char **envp));
#endif
void mpp_input __ProtoGlarp__((void));
int mpp_mcast __ProtoGlarp__((struct pkt *pp, int *tids, int ntask));
int mpp_output __ProtoGlarp__((struct task *tp, struct pkt *pp));
int mpp_probe __ProtoGlarp__((void));
void mpp_kill __ProtoGlarp__((struct task *tp, int signum));
void mpp_cleanup __ProtoGlarp__((void));

void wakesig __ProtoGlarp__((int sig));
