
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *	mesg.h
 *
 *	Pvmd message descriptors.
 *
$Log: mesg.h,v $
 * Revision 1.3  1995/07/18  17:01:24  manchek
 * added function mesg_crc
 *
 * Revision 1.2  1994/06/03  20:38:18  manchek
 * version 3.3.0
 *
 * Revision 1.1  1993/08/30  23:26:49  manchek
 * Initial revision
 *
 */

struct mesg {
	struct mesg *m_link;	/* chain or 0 */
	struct mesg *m_rlink;
	int m_ref;				/* refcount */
	int m_len;				/* total length */
	int m_dst;				/* dst addr */
	int m_src;				/* src addr */
	int m_enc;				/* data encoding (for pvmd-task) */
	int m_cod;				/* type code */
	int m_wid;				/* wait serial (for pvmd-pvmd) */
	int m_flag;
	struct frag *m_frag;	/* master frag or 0 if we're master mesg */
	struct frag *m_cfrag;	/* for keeping state */
	int m_cpos;				/* for keeping state */
	unsigned int m_crc;		/* checksum */
};

#define	MM_PRIO		1		/* put message at head of queue */

struct mesg *mesg_new __ProtoGlarp__((int master));
void mesg_free __ProtoGlarp__((struct mesg *mp));
void mesg_unref __ProtoGlarp__((struct mesg *mp));
void mesg_rewind __ProtoGlarp__((struct mesg *mp));
unsigned int mesg_crc __ProtoGlarp__((struct mesg *mp));

int bytepk __ProtoGlarp__((struct mesg *mp, char *cp,
						int num, int siz, int lnc));
int byteupk __ProtoGlarp__((struct mesg *mp, char *cp,
						int num, int siz, int lnc));
int pkint __ProtoGlarp__((struct mesg *mp, int i));
int upkint __ProtoGlarp__((struct mesg *mp, int *np));
int upkuint __ProtoGlarp__((struct mesg *mp, int *np));
int pkstr __ProtoGlarp__((struct mesg *mp, char *s));
int upkstr __ProtoGlarp__((struct mesg *mp, char *s, int mlen));
int upkstralloc __ProtoGlarp__((struct mesg *mp, char **ss));

/* used to cache multicast addresses */

struct mca {
	struct mca *mc_link;	/* dll of peers */
	struct mca *mc_rlink;
	int mc_tid;				/* the multicast tid */
	int mc_ndst;			/* number of dsts */
	int *mc_dsts;			/* dst tids (local tasks or foreign pvmds) */
};

struct mca *mca_new __ProtoGlarp__(( void ));
void mca_free __ProtoGlarp__((struct mca *mcap));

