/* $Id: pvmgs_mac.h,v 1.1 1995/05/17 15:52:48 manchek Exp $ */
/* File: pvmgs_mac.h - various macros that are used throughout the group   */
/*                     server                                              */
/* Set the pvm_errno to info, print the error, and then return the error   */
#define DO_ERROR_RTN(info,caller) { pvm_errno = info; pvm_perror(caller); return; }


/* Allocate new memory for a string based if length > mxlen                */ 
#define REALLOCSTRING(length, mxlen, name, caller) { if ((length) > (mxlen))  \
                    {                                                         \
                      if (name != (char *) NULL)                              \
                         PVM_FREE(name);                                      \
                      name=(char *)PVM_ALLOC( sizeof(char) *(length + 1),     \
                                    caller);                                  \
                      mxlen = length;                                         \
                    }                                                         \
         }

/* Init a send buffer and pack the single integer result                   */
/* caller is used for error reporting                                      */
#define PK_IRESULT(result, caller) { if                                       \
                       (pvm_initsend(PvmDataDefault) < 0 )                    \
                       pvm_perror( caller );                                  \
                   if (pvm_pkint((&result),1,1) < 0 )                         \
                       pvm_perror( caller );                                  \
                   }                              

/* Pack the state. If state is STATIC then pack all group information.     */
#define PK_STATE(tid, state, name, hash_list, ngroups, caller) { if           \
                     (pvm_pkint((&state),1,1) < 0 )                           \
                        pvm_perror( caller );                                 \
                  if (state == STATIC)                                        \
                     if (gs_newstaticcache(tid,name,hash_list,ngroups,caller) \
                         == PvmgsNotCached)                                   \
                         gs_pkstaticinfo(gs_group(name,hash_list,ngroups,NOCREATE)); }
                     
                 
/* Send the packed buffer to tid,msgtag. Caller is used for error reporting*/ 
#define SENDRESULT(tid, msgtag, caller) if (pvm_send((tid),(msgtag)) < 0 )    \
                       pvm_perror( caller );                                 

/* Create a send buffer, pack a single integer, and send it                */
#define SENDINTRESULT(result,tid,msgtag,caller) {  PK_IRESULT(result,caller); \
                   SENDRESULT(tid,msgtag,caller) }

/* Begin a trace event, keep track of the current trace level              */
/* Optionally packs a single integer argument                              */
#define BGN_TRACE(level,x,event,strarg,intarg) if ( (x) = (level) ) {       \
                                          level = 0;                        \
                                          if (TEV_DO_TRACE( event ) )       \
                                          {                                 \
                                            pvm_pkstr(strarg ? strarg: ""); \
                                            if ( intarg != (int *) NULL)    \
                                               pvm_pkint(intarg,1,1);       \
                                            TEV_FIN;                        \
                                          }                                 \
                                        }
/* End trace event and send back an integer                                */
#define END_TRACE(level,x,event,intarg) if ( x ) {                           \
                                          if (TEV_DO_TRACE( event ) )        \
                                          {                                  \
                                            pvm_pkint(intarg, 1 , 1);        \
                                            TEV_FIN;                         \
                                          }                                  \
                                          level = 1;                         \
                                        }

/* Max, min. Interval confines the argument to the interval               */
#define MAX(x,y) ((x) > (y) ? (x) : (y))                               
#define MIN(x,y) ((x) < (y) ? (x) : (y))                               
#define INTERVAL(x,a,y)  MIN(MAX((x),(a)), (y)) 
