#include <stdio.h>
#include "pvm3.h"
char prog_name[256];

void usage(void);

/* extern variables */
extern int errno, optind;
extern char *optarg;

main(argc, argv)
    int argc;
    char **argv;
{
    int mytid;                  /* my task id */
    int tids[32];		/* slave task ids */
    int n, nproc, numt, i, who, msgtype, nhost, narch, ch;
    float data[100], result[32];
    struct pvmhostinfo *hostp[32];
    int info, ntasks, done, j;
    struct pvmtaskinfo *taskp;

    /* Set number of slaves to start */
    while ((ch = getopt(argc, argv, "n:")) != EOF) {
       switch(ch) {
          case 'n': nproc = atoi(optarg);
                    break;
          default:  usage();
                    break;
       }
    }
    argc -= optind;
    argv += optind;

    if (argc < 1) {
       usage();
    }

    /* Get program name */
    strcpy(prog_name, argv[0]);
    argv += 1;

    printf("%s program to be spawned %d times.\n", prog_name, nproc);

    /* enroll in pvm */
    mytid = pvm_mytid();
    pvm_setopt(PvmAutoErr, 1);
    pvm_catchout(stdout);

    /* start up slave tasks */
    numt=pvm_spawn(prog_name, argv, 0, "", nproc, tids);
    if( numt < nproc ){
       printf("Trouble spawning slaves. Aborting. Error codes are:\n");
       for( i=numt ; i<nproc ; i++ ) {
          printf("TID %d %d\n",i,tids[i]);
       }
       for( i=0 ; i<numt ; i++ ){
          pvm_kill( tids[i] );
       }
       pvm_exit();
       exit();
    }
    
    done = 1;
    taskp = NULL;
    while(done) {
       sleep(1);
       info = pvm_tasks(0, &ntasks, &taskp);
       done = 0;
       for (j=0; j < numt; j++)
          for (i=0; i < ntasks; i++) {
             if (tids[j] == taskp[i].ti_tid) {
                done = 1;
                break;
             }
          }
    }
    /* Program Finished exit PVM before stopping */
    pvm_exit();
}

void usage(void)
{
    printf("starter -n <number to spawn> <program name> <args>\n");
    exit(1);
}

