C ================================================================
      Subroutine uniformRefinement(
C ================================================================
     &      nP, MaxP, nF, MaxF, nE, MaxE,  
     &      XYP, IPF, IPE, lbE,
     &      ParCrv, iFnc, IFE,
     &      Sol, iW, MaxWi)
C ================================================================
C Routine refines the input mesh and interpolates (linearly) the
C nodal solution.
C 
C *** Remarks:
C        1. The size of working memory is 3 * nE + nP
C ================================================================
      Real*8  XYP(2, *)
      Integer IPE(3, *), IPF(4, *), lbE(*)

      Real*8  ParCrv(2, *)
      Integer iFnc(*)

      Integer IFE(3, *), iW(*)
      Real*8  Sol(*)

C (Local variables)
      Integer iref(4), iEt(8)
      Real*8  t1, t2, t3, s
      Logical cmpE, tangled, check3, flagE

      DATA    iref /1,2,3,1/

C ================================================================
      inEP = 1
      iIEP = inEP + nP
      iEnd = iIEP + 3 * nE

      If(iEnd.GT.MaxWi) Call errMes(1001, 'uniformRefinement',
     &                             'not enough working memory')


c ... compute map E -> F
      Call makMf(nP, nFtot, nE, IPE, IFE, iW(inEP), iW(iIEP))

      nPo = nP
      nFo = nF
      nEo = nE

      nP = nPo + nFtot
      nF = 2 * nFo
      nE = 4 * nEo

      If(nP.GT.MaxP) Call errMes(1003, 'uniformRefinement',
     &                          'local parameter MaxP is small')
      If(nF.GT.MaxF) Call errMes(1004, 'uniformRefinement',
     &                          'local parameter MaxF is small')
      If(nE.GT.MaxE) Call errMes(1006, 'uniformRefinement',
     &                          'local parameter MaxE is small')


c ... split edges
      Do 10 n = 1, nFo
         iP1 = IPF(1, n)
         iP2 = IPF(2, n)

         flagE = cmpE(iP1, iP2, iW(iIEP), iW(inEP), 0, iE)

         Do i1 = 1, 3
            i2 = iref(i1 + 1)

            jP1 = IPE(i1, iE)
            jP2 = IPE(i2, iE)

            If(check3(iP1, iP2, jP1, jP2)) Then
               kP1 = nPo + IFE(i1, iE)

               IPF(1, nFo + n) = iP1
               IPF(2, nFo + n) = kP1

               IPF(4, nFo + n) = IPF(4, n)

               IPF(1, n) = kP1
               Goto 10
            End if
         End do
  10  Continue


c ... split elements
      kE = nEo 
      Do n = 1, nEo
         Do i1 = 1, 3
            i2 = iref(i1 + 1)
            i3 = iref(i2 + 1)

            iP1 = IPE(i1, n)
            iP2 = IPE(i2, n)

            jP1 = nPo + IFE(i1, n)
            jP3 = nPo + IFE(i3, n)

            kE = kE + 1
            IPE(1, kE) = iP1
            IPE(2, kE) = jP1
            IPE(3, kE) = jP3

            lbE(kE) = lbE(n)

            Do i = 1, 2
               XYP(i, jP1) = (XYP(i, iP1) + XYP(i, iP2)) / 2
            End do

            Sol(jP1) = (Sol(iP1) + Sol(iP2)) / 2
         End do

         Do i = 1, 3
            IPE(i, n) = nPo + IFE(i, n)
         End do
      End do


c ... split curved edges
      kC = 0
      Do n = 1, nFo
         If(iFnc(n).GT.0) kC = kC + 1
      End do

      Do n = 1, nFo
         nC = IPF(3, n) 

         If(nC.GT.0) Then
            s = 1.0D0

            iloop = 0
 20         iloop = iloop + 1
            If(iloop.GT.3) Call errMes(6004, 'uniformRefinement', 
     &                          'Mesh is tangled after refinement')

            t1 = ParCrv(1, nC)
            t2 = ParCrv(2, nC)

            s = s / 2
            t3 = s * t1 + (1 - s) * t2
            ParCrv(1, nC) = t3

            kP1 = IPF(1, n)
            Call aniCrv(t3, XYP(1, kP1), iFnc(nC))

c  ...  check for inverted elements    
            iP1 = IPF(1, nFo + n) 
            iP2 = IPF(2, n) 

            nEt = 0
            iE1 = 0
            Do k = 1, 2
               If(cmpE(iP1, iP2, iW(iIEP), iW(inEP), iE1, iE2)) Then
                  Do i = 1, 3 
                     iEt(nEt + i) = nEo + 3 * (iE2 - 1) + i 
                  End do
                  iEt(nEt + 4) = iE2
                  nEt = nEt + 4
               End if

               iE1 = iE2
            End do

            Do i = 1, nEt
               Do j = max(i + 1, 4), nEt
                  If(tangled(iEt(i), iEt(j), XYP, IPE)) Goto 20
               End do
            End do

c  ...  add new curved edge
            kC = kC + 1
            IPF(3, nFo + n) = kC

            iFnc(kC) = iFnc(nC)
            ParCrv(1, kC) = t1
            ParCrv(2, kC) = t3
         End if
      End do

      Return
      End



C ================================================================
      Subroutine orientBoundary(nP, nF, nE, XYP, IPF, IPE, iW, MaxWi)
C ================================================================
C Routine orient the external boundary of a given mesh in such 
C a way that the domain is on the left of an edge. In orwer words, 
C IPF(1, *) and IPF(2, *) are flipped if neccessary.
C
C *** Remarks:
C        1. The size of working memory is 3 * nE + 2 * nF + nP
C ================================================================
      Real*8  XYP(2, *)
      Integer IPE(3, *), IPF(4, *), iW(*)

C (Local variables)
      Real*8  v, calVol
      Integer iref(4)
      DATA    iref /1,2,3,1/

C ================================================================
      inEP = 1
      iIEP = inEP + nP
      iIFE = iIEP + 2 * nF
      iEnd = iIFE + 3 * nE

      If(iEnd.GE.MaxWi) Call errMes(1001, 'orientBoundary',
     &                             'not enough working memory')

c ... compute map E -> F
      Call makMb(nP, nF, nE, IPF, IPE, iW(iIFE), iW(inEP), iW(iIEP))

      Do n = 1, nE
         Do i1 = 1, 3
            ife = iW(iIFE + 3 * (n - 1) + i1 - 1)
            If(ife.GT.0) Then 
               i2 = iref(i1 + 1)
               i3 = iref(i2 + 1)
 
               iP1 = IPF(1, ife)  
               iP2 = IPF(2, ife)  
               iP3 = IPE(i3, n)  

               v = calVol(XYP(1, iP1), XYP(1, iP2), XYP(1, iP3))
               If(v.GT.0D0) Call swapii(IPF(1, ife), IPF(2, ife))
            End if
         End do
      End do      

      Return
      End



C ================================================================
      Subroutine makMf(nP, nF, nE, IPE, IFE, nEP, IEP)
C ================================================================
C  The routine computes connectivity lists for mesh edges 
C
C  *** Remarks:
C         1. Working memory is nEP(nP), IEP(3 * nE)
C ================================================================
      Integer IPE(3, *), IFE(3, *)
      Integer IEP(*), nEP(*)

C ================================================================
C group (Local variables)
      Integer iref(4)
      Logical cmpE, check3

      DATA    iref /1,2,3,1/

C ================================================================
      Call backReferences(nP, nE, 3, 3, IPE, nEP, IEP)

      Do n = 1, nE
         Do i = 1, 3
            IFE(i, n) = 0
         End do
      End do

      nF = 0
      Do n = 1, nE
         Do 10 i1 = 1, 3
            If(IFE(i1, n).EQ.0) Then
               nF = nF + 1
               IFE(i1, n) = nF

               i2 = iref(i1 + 1)

               iP1 = IPE(i1, n)
               iP2 = IPE(i2, n)

               If(cmpE(iP1, iP2, IEP, nEP, n, iE2)) Then
                  Do j1 = 1, 3
                     j2 = iref(j1 + 1)

                     jP1 = IPE(j1, iE2)
                     jP2 = IPE(j2, iE2)
                     If(check3(iP1, iP2, jP1, jP2)) Then
                        IFE(j1, iE2) = nF
                        Goto 10
                     End if
                  End do
               End if
            End if
 10      Continue
      End do

      Return
      End



C ================================================================
      Subroutine makMb(nP, nF, nE, IPF, IPE, IFE, nEP, IEP)
C ================================================================
C  The routine computes connectivity lists for BOUNDARY mesh faces
C
C  *** Remarks:
C         1. Working memory is nEP(nP), IEP(2 * nF)
C ================================================================
      Integer IPF(4, *), IPE(3, *), IFE(3, *)
      Integer IEP(*), nEP(*)

C ================================================================
C group (Local variables)
      Integer iref(4)
      Logical cmpE

      DATA    iref /1,2,3,1/

C ================================================================
      Call backReferences(nP, nF, 2, 4, IPF, nEP, IEP)

      Do n = 1, nE
         Do i1 = 1, 3
            IFE(i1, n) = 0

            i2 = iref(i1 + 1)

            iP1 = IPE(i1, n)
            iP2 = IPE(i2, n)

            If(cmpE(iP1, iP2, IEP, nEP, 0, iF)) Then
               IFE(i1, n) = iF
            End if
         End do
      End do

      Return
      End

