C ================================================================
      Subroutine updQa(n, XYP, IPE, IEE, qE)
C ================================================================
C Initial quality modification for tangled elements and their 
C edge-neighboors.
C ================================================================
      Real*8  XYP(2, *), qE(*)
      Integer IPE(3, *), IEE(3, *)

C (Local variables)
      Integer ip(4)
      Real*8  calVol, v1, v2
      Logical check3

C ================================================================
      ip(1) = 1
      ip(2) = 2
      ip(3) = 3
      ip(4) = 1

      Do 100 i1 = 1, 3
         iE = IEE(i1, n)
         If(iE.LE.0) Goto 100

         i2 = ip(i1 + 1)
         i3 = ip(i2 + 1)

         iP1 = IPE(i1, n)
         iP2 = IPE(i2, n)

         Do j1 = 1, 3
            j2 = ip(j1 + 1)

            jP1 = IPE(j1, iE)
            jP2 = IPE(j2, iE)

            If(check3(iP1, iP2, jP1, jP2)) Then
               i3  = ip(i2 + 1)
               iP3 = IPE(i3, n)

               j3  = ip(j2 + 1)
               jP3 = IPE(j3, iE)

               v1 = calVol(XYP(1, iP1), XYP(1, iP2), XYP(1, iP3))
               v2 = calVol(XYP(1, iP1), XYP(1, iP2), XYP(1, jP3))

               If(v1 * v2.GE.0D0) Then
                  qE(n)  = -dabs(qE(n))
                  qE(iE) = -dabs(qE(iE))
               End if
               Goto 100
            End if
         End do
 100  Continue

      Return
      End


C ================================================================
      Subroutine updQb(nEs, lE, iEs, XYP, IPEs, qEs)
C ================================================================
C Dynamic quality modification for tangled elements inside
C a super-element.
C
C Remark: non-efficient, time-consuming, but robust algorithm.
C ================================================================
      Real*8  XYP(2, *), qEs(*)
      Integer iEs(*), IPEs(3, *)

C group (Local variables)
      Integer ip(4)
      Real*8  calVol, v1, v2
      Logical check3

C ================================================================
      ip(1) = 1
      ip(2) = 2
      ip(3) = 3
      ip(4) = 1

      Do 100 i1 = 1, 3
         i2 = ip(i1 + 1)

         iP1 = IPEs(i1, nEs)
         iP2 = IPEs(i2, nEs)

         Do 20 k = 1, lE
            If(iEs(k).LT.0)  Goto 20
            If(k.EQ.nEs)     Goto 20

            Do j1 = 1, 3
               j2 = ip(j1 + 1)

               jP1 = IPEs(j1, k)
               jP2 = IPEs(j2, k)

               If(check3(iP1, iP2, jP1, jP2)) Then
                  i3  = ip(i2 + 1)
                  iP3 = IPEs(i3, nEs)

                  j3  = ip(j2 + 1)
                  jP3 = IPEs(j3, k)

                  v1 = calVol(XYP(1, iP1), XYP(1, iP2), XYP(1, iP3))
                  v2 = calVol(XYP(1, iP1), XYP(1, iP2), XYP(1, jP3))

                  If(v1 * v2.GE.0D0) Then
                     qEs(nEs) = -dabs(qEs(nEs))
                     qEs(k)   = -dabs(qEs(k))
                  End if

                  Goto 100
               End if
            End do
 20      Continue
 100  Continue

 1000 Return
      End



C ================================================================
      Logical Function  chkTangled(lE, iEs, IPEs)
C ================================================================
C Local mesh modifications for tangled mesh may result is a 
C topologically wrong mesh (chkTangled = TRUE).
C ================================================================
      Integer iEs(*), IPEs(3, *)

C group (Local variables)
      Integer ip(4)
      Logical check3

C ================================================================
      chkTangled = .TRUE.

      ip(1) = 1
      ip(2) = 2
      ip(3) = 3
      ip(4) = 1

c ...  more than two triangles with a common edge
       Do 20 n = 1, lE
          iEt = iEs(n)
          If(iEt.LE.0) Goto 20
          
          Do i1 = 1, 3
             i2 = ip(i1 + 1)

             iP1 = IPEs(i1, n)
             iP2 = IPEs(i2, n)

             nEdge = 0
             Do 10 m = 1, lE
                jEt = iEs(m)
                If(m.EQ.n .OR. jEt.LE.0) Goto 10

                Do j1 = 1, 3
                   j2 = ip(j1 + 1)

                   jP1 = IPEs(j1, m)
                   jP2 = IPEs(j2, m)
                   If(check3(iP1, iP2, jP1, jP2)) nEdge = nEdge + 1
                End do
 10          Continue            
             If(nEdge.GT.2) Goto 1000
          End do 
 20    Continue
       

c ...  there is no topological defects
       chkTangled = .FALSE.

 1000  Return
       End

