C ========================================================
      Subroutine swapF(
C ========================================================
c group (M)
     &            iwF, iwE,
     &            nP, nF, nE,
     &            XYP, IPF, IPE,
     &            parCrv, iFnc,
     &            hStar,
     &            ICP, IEP, IFE, IEE,
     &            L1E, L2E, nL2, nStep,
     &            IHolP, IHolF, IHolE,
     &            status,
C group (Q)
     &            HesP, Quality, rQuality,
     &            detG, qE,
C group (S)
     &            lFu, lEu, iFu, iEu, IPFu, IPEu, qEu,
C group (W)
     &            iSE, rSE,
     &            flag)
C ========================================================
      include 'makS.fd'
      include 'colors.fd'
      include 'status.fd'
      include 'operat.fd'
C ========================================================
C group (M)
      Integer IPF(4, *), IPE(3, *)
      Real*8  XYP(2, *)

      Integer iFnc(*)
      Real*8  parCrv(2, *), hStar

      Integer L1E(2, *), L2E(*), nStep(4)
      Integer IHolP(*), IHolF(*), IHolE(*)

      Integer ICP(*), IEP(*)
      Integer IFE(3, *), IEE(3, *)

      Integer status

C group (Q)
      Real*8  HesP(3, *), Quality, rQuality
      Real*8  detG(*), qE(*)

C group (S)
      Integer iFu(*), iEu(*), IPFu(2, *), IPEu(3, *)
      Real*8  qEu(*)

C group (W)
      Integer iSE(*)
      Real*8  rSE(*)

C group (Flag)
      Logical flag

C group (Local variables)
      Integer iFs(MaxS), iEs(MaxS), IPFs(2, MaxS), IPEs(3, MaxS)
      Real*8  XYPs(2), HesPs(3), detGs, qEs(MaxS)

      Integer ip(4), iPs(MaxS)
      Real*8  par(6), t1, t2, tc
      Logical flagBNDs, flagFirst

      Integer minClr
      Logical ifXnode

C ========================================================
      flag = .FALSE.

      Call copySE(lFu, lEu, iFu, iEu, IPFu, IPEu, qEu,
     &            lF,  lE,  iFs, iEs, IPFs, IPEs, qEs)

      ip(1) = 1
      ip(2) = 2
      ip(3) = 3
      ip(4) = 1

      iF = IFE(iwF, iwE)

      i1 = iwF
      i2 = ip(i1 + 1)

      iP1 = IPE(i1, iwE)
      iP2 = IPE(i2, iwE)

      iE1 = iwE
      iE2 = IEE(iwF, iE1)


c ... checking the case when swapping is impossible
      If(iE2.EQ.0) Goto 1000
      If(iF.NE.0)  Goto 1000

      ICPs = minClr(ICP(iP1), ICP(iP2))
      If(ifXnode(ICPs, jTnode)) Goto 1000


      i3 = ip(i2 + 1)
      iPa = IPE(i3, iwE)

      Do i = 1, 3
         If(IPE(i, iE2).NE.iP1 .AND. IPE(i, iE2).NE.iP2) Then
            i4 = i
            iPb = IPE(i, iE2)
         End if
      End do


C ... checking for boundary triangles
      If(ifXnode(status, ANIForbidBoundaryElements)) Then
         If(ifXnode(ICP(iPa), jInode)) Goto 100
         If(ifXnode(ICP(iPb), jInode)) Goto 100

         If(ifXnode(ICP(iP1), jBnode)) Goto 1000
         If(ifXnode(ICP(iP2), jBnode)) Goto 1000

 100     Continue
      End if


c ... checking the case when swapping is impossible
      t1 =(XYP(1, iPa) - XYP(1, iP1)) * (XYP(2, iPb) - XYP(2, iP1)) -
     &    (XYP(2, iPa) - XYP(2, iP1)) * (XYP(1, iPb) - XYP(1, iP1))

      t2 =(XYP(1, iPa) - XYP(1, iP2)) * (XYP(2, iPb) - XYP(2, iP2)) -
     &    (XYP(2, iPa) - XYP(2, iP2)) * (XYP(1, iPb) - XYP(1, iP2))

      If(t1 * t2.GE.0D0) Goto 1000


C ... skipping the inverted elements
      if(ifXnode(status, ANIUntangleMesh)) Then
         If(qE(iE1).LE.0D0) Goto 1000
         If(qE(iE2).LE.0D0) Goto 1000
      End if


c ... checking for surrounding points
      If(ifXnode(status, ANIUse2ArmRule)) Then
         If(ifXnode(ICP(iPa), jBnode) .OR. 
     &      ifXnode(ICP(iPb), jBnode)) Then
            Call chkSPf(iP1, iP2, ICP, IEP, IPE, IEE, lP, iPs)
            Call chkSPb(iP1, iP2, iPa, iPb, iSWAP,
     &                  ICP, IEP, IPE, IEE, lP, iPs, flagBNDs)
            If(flagBNDs) Goto 1000
         End if
      End if


C ... making a virtual evaluation of the quality
      Call findSE(lE, iEs, iE1, nE1)
      Call calQE(
     &     HesP(1, iP1), detG(iP1), XYP(1, iP1),
     &     HesP(1, iPa), detG(iPa), XYP(1, iPa),
     &     HesP(1, iPb), detG(iPb), XYP(1, iPb),
     &     hStar, qEs(nE1))

      If(qEs(nE1).LE.rQuality) Goto 1000

      Call findSE(lE, iEs, iE2, nE2)
      Call calQE(
     &     HesP(1, iP2), detG(iP2), XYP(1, iP2),
     &     HesP(1, iPa), detG(iPa), XYP(1, iPa),
     &     HesP(1, iPb), detG(iPb), XYP(1, iPb),
     &     hStar, qEs(nE2))

      If(qEs(nE2).LE.rQuality) Goto 1000


C ... updating the grid
      flag = .TRUE.

      IPEs(1, nE1) = iP1
      IPEs(2, nE1) = iPa
      IPEs(3, nE1) = iPb

      IPEs(1, nE2) = iP2
      IPEs(2, nE2) = iPa
      IPEs(3, nE2) = iPb


c ... updating the quality
      If(ifXnode(status, ANISmoothMesh)) Then
         flagFirst = .TRUE.
         Call updQE(XYP, lE, iEs, IPEs,
     &              HesP, rQuality, detG, hStar, qEs, flagFirst)
         If(.NOT.flagFirst) Then
            flag = .FALSE.
            Goto 1000
         End if
      End if 


      Call lstUpd(nE, L1E, nL2, L2E, nStep, qE, iEs(nE1), qEs(nE1))
      Call lstUpd(nE, L1E, nL2, L2E, nStep, qE, iEs(nE2), qEs(nE2))

      Call eleDel(iEs(nE1), IPE, IEE)
      Call eleDel(iEs(nE2), IPE, IEE)

      Call eleUpd(nE1, IEP, IPE, IFE, IEE,
     &            lF, lE, iFs, iEs, IPFs, IPEs)
      Call eleUpd(nE2, IEP, IPE, IFE, IEE,
     &            lF, lE, iFs, iEs, IPFs, IPEs)

 1000 Return
      End


