C ==========================================================
      Double Precision Function NLnFnc(
C ==========================================================
C group (F)
     &       nU, U,
C group (ANI)
     &       nP, nE, XYP, IPE, IEE, HesP, detG, hStar, status,
     &       lE, iEs, XYPs, IPEs, HesPs, detGs, qEs,
     &       nPw, nEw, XYPw, HesPw, IPEw,
     &       iSE, rSE, iP1, iP2, iCRVs, iFNCs, t1, t2,
     &       L1Et, L2Et, tE,
     &       nL2t, nStept, nEt, nCrvFnc, LFnc, ILt)
C ==========================================================
      include 'status.fd'
C ==========================================================
C group (F)
      Real*8 U(*)

C group (ANI)
      Integer IPE(3, *), IEE(3, *)
      Integer iEs(*), IPEs(3, *), IPEw(3, *), iSE(*), status
      Real*8  XYP(2, *), HesP(3, *), detG(*), hStar

      Real*8  XYPs(2),   HesPs(*),  detGs,  qEs(*)
      Real*8  XYPw(2, *), HesPw(3, *), rSE(*), t1, t2
      Real*8  tE(*)
      Integer L1Et(2, *), L2Et(*)
      Integer nL2t(*), nStept(4, *), nEt(*)
      Integer LFnc(*), ILt(*)

C group (Local variables)
      Integer ip(4)
      Real*8  prjXYPs(2), tc, qEt
      Logical check1, ifXnode

C ==========================================================
      ip(1) = 1
      ip(2) = 2
      ip(3) = 3
      ip(4) = 1

      If(nU.EQ.2) Then
         Do i = 1, 2
            XYPs(i) = U(i)
         End do
      Else if(nU.EQ.1) Then
         tc = U(1)

         Call aniCrv(tc, XYPs, iFNCs)
      End if

      Call findSE(nCrvFnc, LFnc, iFNCs, k)
      If(k.GT.0) Then
         ir = ILt(k)
         Call prjCrv(XYPs, prjXYPs, iFNCs, tc,
     &               L1Et(1, ir), L2Et(ir), nL2t(k), nStept(1, k),
     &               nEt(k), tE(ir))

         Call LINTRP(nEw, IPEw, nPw, XYPw, 3, HesPw, 1, 
     &               prjXYPs, HesPs, iSE, rSE, .FALSE.)
      Else 
         Call LINTRP(nEw, IPEw, nPw, XYPw, 3, HesPw, 1, 
     &               XYPs, HesPs, iSE, rSE, .FALSE.)
      End if

      Call calDet(HesPs, detGs)


      Do 50 n = 1, lE
         iE = iEs(n)
         If(iE.LE.0) Goto 50

         Do i1 = 1, 3
            If(IPEs(i1, n).EQ.iP1) Then
               i2 = ip(i1 + 1)
               i3 = ip(i2 + 1)

               iPa = IPEs(i2, n)
               iPb = IPEs(i3, n)

               Call calQE(
     &              HesPs,        detGs,     XYPs,
     &              HesP(1, iPa), detG(iPa), XYP(1, iPa),
     &              HesP(1, iPb), detG(iPb), XYP(1, iPb),
     &              hStar, qEs(n))

c  ...  updating the quality
               If(ifXnode(status, ANISmoothMesh)) Then
                  Do 10 j1 = 1, 3
                     jE = IEE(j1, iE)
                     If(jE.LE.0) Goto 10

                     jP1 = IPE(1, jE)
                     jP2 = IPE(2, jE)
                     jP3 = IPE(3, jE)

                     If(check1(iP1, IPE(1, jE))) Then 
                        if(jP2.EQ.iP1) jP2 = jP1 
                        if(jP3.EQ.iP1) jP3 = jP1 

                        Call calQE(
     &                       HesPs,        detGs,     XYPs,
     &                       HesP(1, jP2), detG(jP2), XYP(1, iPa),
     &                       HesP(1, jP3), detG(jP3), XYP(1, iPb),
     &                       hStar, qEt)

                        qEs(n) = min(qEs(n), qEt)
                     Else
                        Call calQE(
     &                       HesP(1, jP1), detG(jP1), XYPs,
     &                       HesP(1, jP2), detG(jP2), XYP(1, iPa),
     &                       HesP(1, jP3), detG(jP3), XYP(1, iPb),
     &                       hStar, qEt)

                        qEs(n) = min(qEs(n), qEt)

                        Call calQE(
     &                       HesPs,        detGs,     XYP(1, jP1),
     &                       HesP(1, iPa), detG(iPa), XYP(1, jP2),
     &                       HesP(1, iPb), detG(iPb), XYP(1, jP3),
     &                       hStar, qEt)

                        Call findSE(lE, iEs, jE, m)
                        If(m.LE.0) Call errMes(6002, 
     &                                  'NLnFnc', 'System error') 
                        qEs(m) = min(qEs(m), qEt)
                     End if
 10               Continue
               End if
               
               Goto 50
            End if
         End do
 50   Continue

      NLnFnc = 1D0
      Do n = 1, lE
         NLnFnc = min(NLnFnc, qEs(n))
      End do
      NLnFnc = 1D0 - NLnFnc
      Return
      End
