C ==========================================================
C ANI2D Version 1.X
C ==========================================================
      Subroutine mesh_metric(
C ==========================================================
c group (M)
     &      nP, MaxP, nF, MaxF, nE, MaxE, nPv,
     &      XYP, IPF, IPE, IPV,
     &      ParCrv, iFnc,
     &      nEStar, 
c group (D)
     &      nFv, nEv, IFV, IEV, lbE,
     &      flagAuto, status,
c group (Q)
     &      MaxSkipE, MaxQItr,
     &      Quality, rQuality,
c group (W)
     &      MaxWr, MaxWi, rW, iW,
     &      iPrint, iERR)
C ==========================================================
      include 'lintrp.fd'
      include 'status.fd'
C ==========================================================
C  VARIABLES & PARAMETER are described in mesh_solution.f
C
C *** Authors: K. Lipnikov (lipnikov@hotmail.com)
C              Y. Vassilevski (vasilevs@dodo.inm.ras.ru)
C ==========================================================
C group (M)
C     Integer MaxP, MaxF, MaxE, MaxFnc
      Real*8  XYP(2, *)
      Integer IPE(3, *), IPF(4, *), IPV(*)

      Real*8  ParCrv(2, *)
      Integer iFnc(*)

C group (D)
      Integer nFv, nEv
      Integer IFV(*), IEV(*), lbE(*)
      
      Logical flagAuto
      Integer status

C group (Q)
C     Integer MaxSkipE, MaxQItr
      Real*8  Quality, rQuality

C group (W)
      Real*8  rW(*)
      Integer iW(*)

C group (Local variables)
      Real*8  hStar

C ==========================================================
C group (Common blocks)
      Integer iDomBnd, iMatBnd
      Common /aniBND/ iDomBnd, iMatBnd
 
      Real*8  refXYP(2), scaXYP(2)
      Common /rescale/refXYP, scaXYP

C ==========================================================
      iERR = 0

      Do i = 1, 2
         refXYP(i) = 0D0
         scaXYP(i) = 1D0
      End do


c ... refine initial mesh when nE is very small
c ... it increases robustness of the code 
      Do while(nE < nEStar / 15 .AND. nE.LE.500)
         iIFE = 1
         iiW  = iIFE + 3 * nE
         nWi  = iiW  + 3 * nE + nP 
         If(nWi.GT.MaxWi) Goto 100

         iSol = 1
         nWr  = iSol + MaxP
         If(nWr.GT.MaxWr) Goto 100
 
         If(iPrint.GE.1) Write(*,5001) 

         Call uniformRefinement(
     &        nP, MaxP, nF, MaxF, nE, MaxE,
     &        XYP, IPF, IPE, lbE,
     &        ParCrv, iFnc, iW(iIFE),
     &        rW(iSol), iW(iiW), MaxWi)
      End do 


 100  miLINTRP = 10 * nP + 3 * nE + 6
      mrLINTRP =  4 * nP + MaxH + 4

      inEt = 1
      inStept = inEt + MaxF
      inL2t = inStept + 4 * MaxF
      iLFnc = inL2t + MaxF
      iILt  = iLFnc + MaxF
      iL1Et = iILt + MaxF
      iL2Et = iL1Et + 2 * MaxF
      iIHolP = iL2Et + 2 * MaxF
      iIHolF = iIHolP + MaxP
      iIHolE = iIHolF + MaxF
      iICP = iIHolE + MaxE
      iIEP = iICP + MaxP
      iIFE = iIEP + MaxP
      iIEE = iIFE + 3 * MaxE
      iL1E = iIEE + 3 * MaxE
      iL2E = iL1E + 2 * MaxE
      iIPEw = iL2E + 2 * MaxE
      iiSE  = iIPEw + 3 * nE
      iIEPw = iiSE + miLINTRP
c ... we need twice less memory for backReferences
      inEPw = iIEPw + max(6 * nE, 4 * MaxF)
      nWi   = inEPw + max(3 * MaxP, 2 * MaxF)


      iHesP = 1
      itE = iHesP + 3 * MaxP
      idG = itE + MaxF
      iqE = idG + MaxP
      iHesPw = iqE + MaxE
      iXYPw = iHesPw + 3 * nP
      irSE = iXYPw + 2 * nP
      nWr  = irSE + max(mrLINTRP, max(nE, MaxF))


      iW(1) = nWi
      iW(2) = nWr
      If(nWi.GT.MaxWi) Then
         iERR = 1001
         Goto 1000
      End if

      If(nWr.GT.MaxWr) Then
         iERR = 1002
         Goto 1000
      End if


      Do n = 1, nWr
         rW(n) = 0D0
      End do

      Do n = 1, nWi
         iW(n) = 0
      End do


c ... compute the analytic metric
      Call iniQ_analytic(nP, XYP, rW(iHesP))


c ... scale geometry to unit cube
      Call scale2Square(nP, XYP, .TRUE.)


c ... print Ani2D header
      If(iPrint.GE.1) Write(*, 5004) Quality, nEStar, MaxQItr


c ... set up default status
      Call setStatus(flagAuto, status, iPrint)


c ... call the main module
      Call ani2(
c group (M)
     &      nP, MaxP, nF, MaxF, nE, MaxE, nPv,
     &      XYP, IPF, IPE, IPV,
     &      ParCrv, iFnc,
     &      nEStar, hStar,
     &      iW(iICP), iW(iIEP),
     &      iW(iIFE), iW(iIEE),
     &      iW(iL1E), iW(iL2E),
     &      iW(iIHolP), iW(iIHolF), iW(iIHolE),
     &      iW(iIEPw), iW(inEPw),
     &      iW(iIPEw), iW(iiSE),
c group (Dev)
     &      nFv, nEv, IFV, IEV, lbE,
     &      flagAuto, status,
c group (CRV)
     &      iW(iL1Et), iW(iL2Et), rW(itE),
     &      iW(inL2t), iW(inStept), iW(inEt),
     &      iW(iLFnc), iW(iILt),
c group (Q)
     &      MaxSkipE, MaxQItr,
     &      rW(iHesP), Quality, rQuality,
     &      rW(idG), rW(iqE), rW(iXYPw), rW(iHesPw), rW(irSE),
c group (ERR)
     &      iPrint, iERR)


c ... rescale geometry back
      Call scale2Square(nP, XYP, .FALSE.)


c ... returning sadditional information
      Do n = 1, nP
         iW(n) = iW(iICP + n - 1)
      End do
      iW(nP + 1) = nQItr

      rW(1) = 0D0
      rW(2) = rQuality
      rW(3) = hStar


 1000 If(iERR.EQ.0 .OR. iERR.EQ.1000) Return
      Call errMes(iERR, 'mesh_metric', 
     &            'See error.f for error description')

      Return

 5001 Format('Refining initial mesh')

 5004 Format(/,
     &    'STONE FLOWER! (1997-2005), version 1.3', /,
     &    'Target: Quality', F5.2, ' with', I8, 
     &    ' triangles for at most', I8, ' iterations',/) 
      End



C ==========================================================
      Subroutine iniQ_analytic(nP, XYP, HesP)
C ==========================================================
C  Three Fortran routines below create a metric field which
C  is 2x2 variable positive definite symmetric tensor HesP,
C             F(x,y)  H(x,y)
C      HesP =
C             H(x,y)  G(x,y)
C ==========================================================
C group (M)
      Real*8  XYP(2, *)

C group (Q)
      Real*8  HesP(3, *)

C group (Local variables)
      Real*8  F, G, H, x, y

C ==========================================================
      Real*8  refXYP(2), scaXYP(2)
      Common /rescale/refXYP, scaXYP

C ==========================================================
      Do n = 1, nP
         x = refXYP(1) + XYP(1, n) * scaXYP(1)
         y = refXYP(2) + XYP(2, n) * scaXYP(2)

         HesP(1, n) = F(x, y)
         HesP(2, n) = G(x, y)
         HesP(3, n) = H(x, y)
      End do

      Return
      End


