C ================================================================
C  Changes since makQ_orig.f:
C  1. constant metric is replaced by linear metric
C  2. use LAPACK's routine dsyev instead of Linpack's dsvdc
C  3. added routine computing average quality
C ================================================================

C ================================================================
      Subroutine makQ(
C ================================================================
C Routine computes hStar and quality of elements in the initial 
c mesh. 
C ================================================================
c group (M)
     &     nP, nE, XYP, IPE, IEE,
     &     nEStar, hStar, status,
c group (Q)
     &     HesP, detG, qE)
C ================================================================
      include 'status.fd'
C ================================================================
C group (M)
C     Integer MaxP, MaxF, MaxE, nEStar
      Real*8  XYP(2, *)
      Integer IPE(3, *), IEE(3, *)
      Integer status

      Real*8  hStar

C group (Q)
      Real*8  HesP(3, *)
      Real*8  detG(*), qE(*)

C group (Local variables)
      Real*8  d1, d2, d3, dsum, calVol
      Real*8  VStar, Vn, detMax, qEt
      Logical ifXnode
C ================================================================

      Do n = 1, nP
         Call calDet(HesP(1, n), detG(n))
      End do

      VStar = 0D0
      Do n = 1, nE
         iP1 = IPE(1, n)
         iP2 = IPE(2, n)
         iP3 = IPE(3, n)

         d1 = detG(iP1)
         d2 = detG(iP2)
         d3 = detG(iP3)

         dsum = dsqrt((d1 + d2) / 2)
     &        + dsqrt((d2 + d3) / 2)
     &        + dsqrt((d3 + d1) / 2)

         Vn = calVol(XYP(1, iP1), XYP(1, iP2), XYP(1, iP3))
         VStar = VStar + dabs(Vn) * dsum / 3
      End do

      hStar = dsqrt(VStar / nEStar * 4D0 / dsqrt(3D0))

      Do n = 1, nE
         i1 = IPE(1, n)
         i2 = IPE(2, n)
         i3 = IPE(3, n)

         Call calQE(
     &        HesP(1, i1), detG(i1), XYP(1, i1),
     &        HesP(1, i2), detG(i2), XYP(1, i2),
     &        HesP(1, i3), detG(i3), XYP(1, i3),
     &        hStar, qE(n))

         If(ifXnode(status, ANISmoothMesh)) Then
            Do i = 1, 3
               k = IEE(i, n)
               If(k.GT.0) Then
                  j1 = IPE(1, k)
                  j2 = IPE(2, k)
                  j3 = IPE(3, k)

                  Call calQE(
     &                 HesP(1, j1), detG(j1), XYP(1, i1),
     &                 HesP(1, j2), detG(j2), XYP(1, i2),
     &                 HesP(1, j3), detG(j3), XYP(1, i3),
     &                 hStar, qEt)

                  qE(n) = min(qE(n), qEt)
               End if
            End do
         End if
      End do
      Return
      End



C ================================================================
      Real*8 Function calVol(xy1, xy2, xy3)
C ================================================================
C Routine computes triangle area
C ================================================================
      Real*8 xy1(2), xy2(2), xy3(2)

      calVol = 5D-1 * ((xy1(1) - xy3(1)) * (xy2(2)-xy3(2)) -
     &                 (xy1(2) - xy3(2)) * (xy2(1)-xy3(1)))
      Return
      End



C ================================================================
      Subroutine calDet(HesP, detG)
C ================================================================
      include 'magic.fd'
C ================================================================
C Routine computes determinat det(H) of matrix H where
C       | HesP(1)  HesP(3) |
C   H = |                  |
C       | HesP(3)  HesP(2) |  
C ================================================================
      Real*8  HesP(3), detG

C Local arrays for LAPACK
      Real*8  A(2, 2), E(2), rW(10)
      Integer info

C ================================================================
      detG = HesP(1) * HesP(2) - HesP(3) ** 2

      If(detG.LE.0D0) Then
        A(1, 1) = HesP(1)
        A(2, 2) = HesP(2)
        A(1, 2) = HesP(3)

        Call dsyev('V', 'U', 2, A, 2, E, rW, 10, info)
        If(info.NE.0) Call errMes(3011, 'calDet', 
     &                    'Error in Lapack routine dsyev')

        E(1) = dabs(E(1))
        E(2) = dabs(E(2))

        E(1) = max( E(1), E(2) * AniRatio )

        If(E(2).EQ.0D0) Then
           E(1) = AniEigenvalue
           E(2) = AniEigenvalue
        End if

        HesP(1) = E(1) * A(1, 1) ** 2 + E(2) * A(1, 2) ** 2
        HesP(2) = E(1) * A(2, 1) ** 2 + E(2) * A(2, 2) ** 2
        HesP(3) = E(1) * A(1, 1) * A(2, 1) + E(2) * A(1, 2) * A(2, 2)

        detG = HesP(1) * HesP(2) - HesP(3) ** 2
      End if

      Return
      End



C ================================================================
      Subroutine calQE(
C ================================================================
     &      Hes1, det1, xy1,
     &      Hes2, det2, xy2,
     &      Hes3, det3, xy3,
     &      hStar, qE)
C ================================================================
C Routines computes quality of triangle {xy1, xy2, xy3} assuming
C that the metric is linear.
C
C *** Remarks:
C        1. round-off errors require to use |Lk|
C ================================================================
      Real*8 Hes1(3), det1, xy1(2)
      Real*8 Hes2(3), det2, xy2(2)
      Real*8 Hes3(3), det3, xy3(2)
      Real*8 hStar, qE

C group (Local variables)
      Real*8 HesAvg(3), dsum
      Real*8 Pk, Vk, Lk
      Real*8 F, x1, y1, x2, y2

C group (FUnction)
      F(x1) = (x1 * (2D0 - x1)) ** 3

C ================================================================
      Do i = 1, 3
         HesAvg(i) = (Hes2(i) + Hes3(i)) / 2
      End do

      x1 = xy3(1) - xy2(1)
      y1 = xy3(2) - xy2(2)
      Lk = dabs(HesAvg(1) * x1 * x1 + HesAvg(2) * y1 * y1 +
     &                            2 * HesAvg(3) * x1 * y1)
      Pk = dsqrt(Lk)

      Do i = 1, 3
         HesAvg(i) = (Hes1(i) + Hes2(i)) / 2
      End do

      x1 = xy1(1) - xy2(1)
      y1 = xy1(2) - xy2(2)
      Lk = dabs(HesAvg(1) * x1 * x1 + HesAvg(2) * y1 * y1 +
     &                            2 * HesAvg(3) * x1 * y1)
      Pk = Pk + dsqrt(Lk)

      Do i = 1, 3
         HesAvg(i) = (Hes1(i) + Hes3(i)) / 2
      End do

      x2 = xy1(1) - xy3(1)
      y2 = xy1(2) - xy3(2)
      Lk = dabs(HesAvg(1) * x2 * x2 + HesAvg(2) * y2 * y2 +
     &                            2 * HesAvg(3) * x2 * y2)
      Pk = Pk + dsqrt(Lk)

      dsum = dsqrt((det1 + det2) / 2)
     &     + dsqrt((det2 + det3) / 2)
     &     + dsqrt((det3 + det1) / 2)

      Vk = dabs(x1 * y2 - y1 * x2) * 5D-1 * dsum / 3

      x1 = Pk / (3 * hStar)
      x1 = min(x1, 1D0 / x1)

      qE = 20.784619D0 * Vk / (Pk ** 2) * F(x1)

      Return
      End


C ================================================================
      Subroutine calQF(
C ================================================================
     &      Hes1, det1, xy1,
     &      Hes2, det2, xy2,
     &      Hes3, det3, xy3,
     &      hStar, iw)
C ================================================================
C Routine orders mesh edges in assending of their quality 
C ================================================================
      Real*8  Hes1(3), det1, xy1(2)
      Real*8  Hes2(3), det2, xy2(2)
      Real*8  Hes3(3), det3, xy3(2)
      Real*8  hStar

      Integer iw(3)

C group (Local variables)
      Real*8  HesMax(3), detMax
      Real*8  qF(3)
      Real*8  F, x1, y1

C group (Function)
      F(x1) = (x1 * (2D0 - x1)) ** 3

C ================================================================
      detMax = det1
      Do i = 1, 3
         HesMax(i) = Hes1(i)
      End do

      If(det2.GT.detMax) Then
         detMax = det2
         Do i = 1, 3
            HesMax(i) = Hes2(i)
         End do
      End if

      If(det3.GT.detMax) Then
         detMax = det3
         Do i = 1, 3
            HesMax(i) = Hes3(i)
         End do
      End if

      x1 = xy1(1) - xy2(1)
      y1 = xy1(2) - xy2(2)
      x1 = dsqrt(HesMax(1) * x1 * x1 + HesMax(2) * y1 * y1 +
     &                             2 * HesMax(3) * x1 * y1) / hStar
      x1 = min(x1, 1D0 / x1)
      qF(1) = F(x1)


      x1 = xy3(1) - xy2(1)
      y1 = xy3(2) - xy2(2)
      x1 = dsqrt(HesMax(1) * x1 * x1 + HesMax(2) * y1 * y1 +
     &                             2 * HesMax(3) * x1 * y1) / hStar
      x1 = min(x1, 1D0 / x1)
      qF(2) = F(x1)

      x1 = xy1(1) - xy3(1)
      y1 = xy1(2) - xy3(2)
      x1 = dsqrt(HesMax(1) * x1 * x1 + HesMax(2) * y1 * y1 +
     &                             2 * HesMax(3) * x1 * y1) / hStar
      x1 = min(x1, 1D0 / x1)
      qF(3) = F(x1)

      iw(1) = 1
      iw(2) = 2
      iw(3) = 3

      Do i = 1, 2
         iMin = i
         Do j = i + 1, 3
            If(qF(j).LT.qF(iMin)) iMin = j
         End do

         x1 = qF(i)
         qF(i) = qF(iMin)
         qF(iMin) = x1

         k = iw(i)
         iw(i) = iw(iMin)
         iw(iMin) = k
      End do

      Return
      End



C ================================================================
      Subroutine updQE(XYP, lE, iEs, IPEs, 
     &                 HesP, rQuality, detG, hStar, qEs, flag)
C ================================================================
C Routine is used for mesh smoothing (status & ANISmoothMesh = 1)
C
C *** Remark: the routine is obsolete
C ================================================================
      Integer IPEs(3, *), iEs(*)
      Real*8  XYP(2, *),  HesP(3, *)
      Real*8  rQuality,  detG(*), hStar, qEs(*)
      Logical flag

C group (Local variables)
      Integer iref(4)
      Real*8  qEt
      Logical flagFirst

C ==========================================================
      iref(1) = 1
      iref(2) = 2
      iref(3) = 3
      iref(4) = 1

      flagFirst = flag
      flag = .FALSE.

      Do 50 n = 1, lE
         If(iEs(n).LE.0) Goto 50

         Do 30 i1 = 1, 3
            i2 = iref(i1 + 1)

            iP1 = IPEs(i1, n)
            iP2 = IPEs(i2, n)

            Do 20 k = n + 1, lE
               If(iEs(k).LE.0)  Goto 20

               Do j1 = 1, 3
                  j2 = iref(j1 + 1)

                  jP1 = IPEs(j1, k)
                  jP2 = IPEs(j2, k)

                  If(iP1.EQ.jP1 .AND. iP2.EQ.jP2 .OR.
     &               iP1.EQ.jP2 .AND. iP2.EQ.jP1) Then

                     i3 = iref(i2 + 1)
                     iP3 = IPEs(i3, n)

                     j3 = iref(j2 + 1)
                     jP3 = IPEs(j3, k)

                     Call calQE(
     &                    HesP(1, jP1), detG(jP1), XYP(1, iP1),
     &                    HesP(1, jP2), detG(jP2), XYP(1, iP2),
     &                    HesP(1, jP3), detG(jP3), XYP(1, iP3),
     &                    hStar, qEt)

                     If(qEt.LT.rQuality .AND. flagFirst) Goto 1000
                     qEs(n) = min(qEs(n), qEt)

                     Call calQE(
     &                    HesP(1, iP1), detG(iP1), XYP(1, jP1),
     &                    HesP(1, iP2), detG(iP2), XYP(1, jP2),
     &                    HesP(1, iP3), detG(iP3), XYP(1, jP3),
     &                    hStar, qEt)

                     If(qEt.LT.rQuality. AND. flagFirst) Goto 1000
                     qEs(k) = min(qEs(k), qEt)

                     Goto 30
                  End if
               End do
 20         Continue
 30      Continue
 50   Continue

      flag = .TRUE.

 1000 Return
      End



C ================================================================
      Real*8 Function avgQ(nE, qE, L1E, L2E)
C ================================================================
      Real*8  qE(*)
      Integer L2E(*), L1E(2, *) 

      avgQ = 0D0

      iE = L2E(1)
      Do n = 1, nE
         iE = L1E(2, iE)
         avgQ = avgQ + qE(iE)
      End do

      avgQ = avgQ / nE

      Return
      End

