C ==========================================================
C ANI2D Version 1.X
C The file contains: 
C    (1) program
C    (2) user routine iniQ 
C    (3) user routine calCrv
C ==========================================================
      Program Main_Metric
C ==========================================================
c Maximum number of nodes, elements and boundary edges
      Integer   MaxP,  MaxE,  MaxF, MaxPV, MaxEV, MaxFV
      Parameter(MaxP = 20000, MaxF = 10000, MaxE = 2 * MaxP)
      Parameter(MaxPV = MaxP, MaxFV = MaxF, MaxEV = MaxE)

c Basket capacity and the maximum number of local modifications
      Integer   MaxSkipE, MaxQItr
      Parameter(MaxSkipE = 200, MaxQItr = 15000)

c Available memory 
      Integer   MaxWr, MaxWi
      Parameter(MaxWr = 1000000, MaxWi = 1000000)

c Desired number of triangles in the final mesh
      Integer   nEStar
      Parameter(nEStar = 2000)

c Desired final mesh quality
      Real*8    Quality
      Parameter(Quality = 7D-1)

C ==========================================================
C group (M)
      Real*8  XYP(2, MaxP)
      Integer IPE(3, MaxE), IPF(4, MaxF), IPV(MaxPV)

      Real*8  ParCrv(2, MaxF)
      Integer iFnc(MaxF)

C group (Dev)
      Integer IFV(MaxFV), IEV(MaxEV), lbE(MaxE)
      Logical flagAuto
      Integer status

C group (Q)
      Real*8  rQuality

C group (W)
      Real*8  rW(MaxWr)
      Integer iW(MaxWi)

C ==========================================================
c ... load the initial mesh
      Call loadMone(
c group (M)
     &      nP,  MaxP,  nF,  MaxF,  nE,  MaxE, 
     &      nPv, MaxPV, nFv, MaxFV, nEv, MaxEV,
     &      XYP, IPF, IPE, IPV, IFV, IEV, lbE,
     &      ParCrv, iFnc,
     &      "../data/wing")


c ... drawg the initial mesh
      Do i = 1, nP
         iW(i) = 0
      End do
      Call draw(nP, nF, nE, XYP, iW, IPF, IPE, 'ini.ps')


c ... generate adaptive mesh
      flagAuto = .TRUE.  ! default mesh generation options
      status = 1         ! forbid boundary triangles
      iPrint = 1         ! average level of output information


      Call mesh_metric(
c group (M)
     &      nP, MaxP, nF, MaxF, nE, MaxE, nPv,
     &      XYP, IPF, IPE, IPV, 
     &      ParCrv, iFnc,
     &      nEStar, 
c group (D)
     &      nFv, nEv, IFV, IEV, lbE,
     &      flagAuto, status,
c group (Q)
     &      MaxSkipE, MaxQItr,
     &      Quality, rQuality,
c group (W)
     &      MaxWr, MaxWi, rW, iW,
     &      iPrint, iERR)


c ... draw the final mesh 
      Call draw(nP, nF, nE, XYP, iW, IPF, IPE, 'fin.ps')


c ... save the final mesh 
      Call saveMone(
c group (M)
     &      nP, nF, nE, nPv, nFv, nEv,
     &      XYP, IPF, IPE, IPV, IFV, IEV, lbE,
     &      ParCrv, iFnc,
     &      "../data/save")

      Stop
      End


C ==========================================================
C  Three Fortran routines below create a metric field which
C  is 2x2 variable positive definite symmetric tensor HesP,
C                     | F(x,y)  H(x,y) |
C      Metric(x, y) = |                |
C                     | H(x,y)  G(x,y) |
C
C  *** Remarks:
c         1. We refine the mesh aroung the wing
C ==========================================================
      Real*8 Function F(x, y)
C ==========================================================
      Real*8 x, y

      F = max(1D0 / dsqrt((x - 0.4)**2 + (y - 0.5)**2 + 0.0001),
     &        1D0 / dsqrt((x - 0.6)**2 + (y - 0.5)**2 + 0.0001))

      Return
      End


C ==========================================================
      Real*8 Function G(x, y)
C ==========================================================
      Real*8 x, y

      G = max(1D0 / dsqrt((x - 0.4)**2 + (y - 0.5)**2 + 0.0001),
     &        1D0 / dsqrt((x - 0.6)**2 + (y - 0.5)**2 + 0.0001))

      Return
      End


C ==========================================================
      Real*8 Function H(x, y)
C ==========================================================
      Real*8 x, y
      H = 0D0
      Return
      End


C ==========================================================
      Subroutine calCrv(tc, xyc, iFnc)
C ==========================================================
C  The routine computes the Cartesian coordinates of point
C  xyc from its parametric coordinate tc.
C
C  tc     - the given parametric coordinate of point
C  xyc(2) - the Cartesian coordinate of the same point
C  iFnc   - the function number for computing
C
C  On input :  tc, iFnc
C  On output:  xyc(2)
C
C  *** Remarks:
C         1. There are 2 different parametrizations with 
C            positive identificators (called function 
C            numbers) 2 and 5.
C
C ==========================================================
      Real*8  tc, xyc(2)

C group (Local variables)
      Real*8  CX2, tt, xx, yy, w, XB
      Real*8  X1, X2, XE, Y2, C1, C2, C3, C4, C5, wingAngle

C ==========================================================
c .. closed profile of the wing model 
      If(iFnc.EQ.2) Then
         C1 = 0.17735D0
         C2 =-0.075597D0
         C3 =-0.212836D0
         C4 = 0.17363D0
         C5 =-0.062547D0

         wingAngle = 0D0
         
         X1 = 0.45D0
         X2 = 0.55D0
         XE = 1D0
         Y2 = 5D-1

         X1 = 0.40D0
         X2 = 0.60D0

         CX2 = 5D-1 * (X1 + X2)

         tt = 2 * tc
         if(tt.GT.1D0) Then
            tt = tt - 1D0
            isgn = -1
         Else
            tt = 1D0 - tt
            isgn = 1
         End if

         xx = X1 + tt * (X2 - X1)
         yy = Y2 + isgn * (X2 - X1) * (C1 * dsqrt(tt) + C2 * tt +
     &        C3 * tt * tt + C4 * tt * tt * tt +
     &        C5 * tt * tt * tt * tt)

         xyc(1) = CX2 + (xx - CX2) * dcos(wingAngle) +
     &                  (yy - Y2)  * dsin(wingAngle)

         xyc(2) = Y2 - (xx - CX2) * dsin(wingAngle) +
     &                 (yy - Y2)  * dcos(wingAngle)

c ... tail line after the wing
      Else If(iFnc.EQ.5) Then
         wingAngle = 0D0

         X1 = 0.45D0
         X2 = 0.55D0
         XE = 1D0
         Y2 = 5D-1

         X1 = 0.40D0
         X2 = 0.60D0

         w = 5D-1 * (X2 - X1)
         XB = X2 - w * (1D0 - dcos(wingAngle))

         xyc(1) = XB + (XE - XB) * tc
         xyc(2) = Y2 + w * dsin(-wingAngle)
      Else
         Write(*, '(A,I5)') 'Undefined function =', iFnc
         Stop
      End if

      Return
      End






