C ==========================================================
C ANI2D Version 1.X
C The file contains:
C    (1) program
C    (3) user routine calCrv
C ==========================================================
      Program Main_Solution
C ==========================================================
c Maximum number of points, elements and edges
      Integer   MaxP, MaxE, MaxF, MaxPV, MaxEV, MaxFV
      Parameter(MaxP = 20000, MaxF = 10000, MaxE = 2 * MaxP)
      Parameter(MaxPV = MaxP, MaxFV = MaxF, MaxEV = MaxE)

c Basket capacity and the maximum number of local modifications
      Integer   MaxSkipE, MaxQItr
      Parameter(MaxSkipE = 100, MaxQItr = 15000)

c Available memory
      Integer   MaxWr, MaxWi
      Parameter(MaxWr = 1000000, MaxWi = 1000000)

c Desired number of triangles in the final mesh
      Integer   nEStar
      Parameter(nEStar = 1000)

c Desired final mesh quality
      Real*8    Quality
      Parameter(Quality = 7D-1)

C ==========================================================
C group (M)
      Real*8  XYP(2, MaxP)
      Integer IPE(3, MaxE), IPF(4, MaxF), IPV(MaxPV)

      Real*8  ParCrv(2, MaxF)
      Integer iFnc(MaxF)

C group (Dev)
      Integer IFV(MaxFV), IEV(MaxEV), lbE(MaxE)
      Logical flagAuto
      Integer status

C group (Q)
      Real*8  Sol(MaxP)
      Real*8  rQuality

C group (W)
      Real*8  rW(MaxWr)
      Integer iW(MaxWi)

C ==========================================================
c ... load the initial mesh
      Call loadMone(
     &      nP,  MaxP,  nF,  MaxF,  nE,  MaxE, 
     &      nPv, MaxPV, nFv, MaxFV, nEv, MaxEV,
     &      XYP, IPF, IPE, IPV, IFV, IEV, lbE,
     &      ParCrv, iFnc,
     &      "../data/simple")


c ... load the discrete solution (defined at points)
      Call loadS(nP, Sol, "../data/simple")


c ... or create an artificial solution
c     Do n = 1, nP
c        Sol(n) = XYP(1, n) ** 2
c     End do


c ... smooth the solution if necessary
c     Do n = 1, 4
c        Call smoothing(nP, nE, XYP, IPE, Sol, MaxWr, MaxWi, rW, iW)
c     End do


c ... draw the initial grid
      Do i = 1, nP
         iW(i) = 0
      End do
      Call draw(nP, nF, nE, XYP, iW, IPF, IPE, 'ini.ps')


c ... adaprt the mesh 
      flagAuto = .TRUE.  ! default options
      status = 0         ! do not enforce any mesh adaptation regime
      iPrint = 2         ! average level of output information

      Call mesh_solution(
c group (M)
     &      nP, MaxP, nF, MaxF, nE, MaxE, nPv,
     &      XYP, IPF, IPE, IPV,
     &      ParCrv, iFnc,
     &      nEStar, 
c group (D)
     &      nFv, nEv, IFV, IEV, lbE,
     &      flagAuto, status,
c group (Q)
     &      MaxSkipE, MaxQItr,
     &      Sol, Quality, rQuality,
c group (W)
     &      MaxWr, MaxWi, rW, iW,
     &      iPrint, iERR)


c ... draw the final mesh 
      Call draw(nP, nF, nE, XYP, iW, IPF, IPE, 'fin.ps')


c ... save the final mesh
      Call saveMone(
     &     nP, nF, nE, nPv, nFv, nEv,
     &     XYP, IPF, IPE, IPV, IFV, IEV, lbE,
     &     ParCrv, iFnc,
     &     "../data/save")

c ... save the interpolated solution
      Call saveS(nP, Sol, "../data/save")

      Stop
      End



C ==========================================================
C  Three Fortran routines below create a metric field which
C  is 2x2 variable positive definite symmetric tensor HesP,
C                     | F(x,y)  H(x,y) |
C      Metric(x, y) = |                |
C                     | H(x,y)  G(x,y) |
C
C  *** Remarks:
C       1. These are default routines to link library libani2D.a
C ==========================================================
      Real*8 Function F(x, y)
C ==========================================================
      Real*8 x, y
      F = 1D0
      Return
      End


C ==========================================================
      Real*8 Function G(x, y)
C ==========================================================
      Real*8 x, y
      G = 1D0
      Return
      End


C ==========================================================
      Real*8 Function H(x, y)
C ==========================================================
      Real*8 x, y
      H = 0D0
      Return
      End



C ==========================================================
      Subroutine calCrv(tc, xyc, iFnc)
C ==========================================================
C  The routine computes the Cartesian coordinates of point
C  xyc from its parametric coordinate tc.
C
C  tc     - the given parametric coordinate of point
C  xyc(2) - the Cartesian coordinate of the same point
C  iFnc   - the function number for computing
C
C  On input :  tc, iFnc
C  On output:  xyc(2)
C
C  *** Remarks:
C         1. This is the default routine to link library libani2D.a
C ==========================================================
      Real*8  tc, xyc(2)

      Return
      End






