C ==========================================================
      Subroutine draw(nP, nF, nE, XYP, ICP, IPF, IPE, fName)
C ==========================================================
      include 'colors.fd'
C ==========================================================
C Routine converts the mesh into a postcript file fName.
C ==========================================================
C group (M)
      Real*8  XYP(2, *)
      Integer ICP(*), IPF(4, *), IPE(3, *)

C group (File)
      Character*(*) fName

C group (Local variables)
      Real  mmTOpt, kx, ky
      Real  x1, y1, x2, y2, x3, y3, rad, d
      Real  fxmax, fymax

      Real*8  calEdge
      Logical ifXnode

C ==========================================================
      mmTOpt = 72.0 / 25.4
      Pi = 4.0*atan(1.0)
      rdTOdg = 180.0 / Pi
      xBig = 150.0
      yBig = 150.0

      fxmax = XYP(1, 1)
      fxmin = fxmax
      fymax = XYP(2, 1)
      fymin = fymax

      Do n = 2, nP
         fxmin = min(fxmin, real(XYP(1, n)))
         fxmax = max(fxmax, real(XYP(1, n)))
         fymin = min(fymin, real(XYP(2, n)))
         fymax = max(fymax, real(XYP(2, n)))
      End do

      kx = xBig / (fxmax-fxmin) * mmTOpt
      ky = yBig / (fymax-fymin) * mmTOpt

      If(kx.GT.ky) kx = ky

      ibx = (fxmax-fxmin) * kx + 10
      iby = (fymax-fymin) * kx + 10

      Open(30, file = fName, status='UNKNOWN')
      Write(30,'(A)') '%!PS-Adobe-2.0 EPSF-2.0'
      Write(30,'(A,2I5)') '%%BoundingBox: 0 0 ', ibx, iby 
      Write(30,'(A)') '%%EndComments'

      Call PSini()
      Write(30,*) '5 5 translate'

      Do n = 1, nP
         x1 = (XYP(1, n) - fxmin) * kx
         y1 = (XYP(2, n) - fymin) * kx
c        Write(30,*) x1,y1, ' m', x1, y1, n, ' intTOtext ctext'
      End do 

      Do 10 n = 1, nE
         If(IPE(1, n).EQ.0) Goto 10
         x1 = (XYP(1, IPE(1, n)) - fxmin) * kx
         y1 = (XYP(2, IPE(1, n)) - fymin) * kx

         x2 = (XYP(1, IPE(2, n)) - fxmin) * kx
         y2 = (XYP(2, IPE(2, n)) - fymin) * kx

         x3 = (XYP(1, IPE(3, n)) - fxmin) * kx
         y3 = (XYP(2, IPE(3, n)) - fymin) * kx

         Write(30,*) 'newpath'
         Write(30,*) x1,y1, ' m', x2,y2, ' l', x3,y3, ' l'
         Write(30,'(A)') ' closepath cBlack stroke'

c  ...   mark fix points 
         rad = fxmax - fxmin
         Do i = 1, 3
            iP1 = IPE(i, n)
            Do j = i + 1, 3
               iP2 = IPE(j, n)

               rad = min(rad, calEdge(XYP(1, iP1), XYP(1, iP2)))
            End do
         End do
         rad = rad * kx / 4
         rad = min(rad, 1)

         Do i = 1, 3
            iP1 = IPE(i, n)
            If(ifXnode(ICP(iP1), jVnode)) Then
               x1 = (XYP(1, iP1) - fxmin) * kx
               y1 = (XYP(2, iP1) - fymin) * kx
               Write(30,*) x1,y1, rad, ' cRed fillCircle'
            End if
         End do
 10   Continue


c ... draw boundaries using thick lines
      Write(30,*) 'blw'
      Do 20 n = 1, nF
         If(IPF(1, n).LE.0) Goto 20
         iP1 = IPF(1, n)
         iP2 = IPF(2, n)

         x1 = (XYP(1, iP1) - fxmin) * kx
         y1 = (XYP(2, iP1) - fymin) * kx

         x2 = (XYP(1, iP2) - fxmin) * kx
         y2 = (XYP(2, iP2) - fymin) * kx

         Write(30,*) x1,y1, ' m', x2,y2, ' l '
c        Write(30,*) x1,y1, x2,y2, ' emptyArrow '

         ic = IPF(4, n) / 5
         ic = max(0, IPF(4, n) - 5 * ic) 
         Write(30,'(A,I1,A)') 'c', ic, ' stroke'

         x1 = (x1 + x2) / 2
         y1 = (y1 + y2) / 2
c        Write(30,*) x1,y1, ' m', x1, y1, n, ' intTOtext ctext'
 20   Continue

      Write(30,'(A)') 'showpage '
      Close(30)
      Return
      End



C ==========================================================
      Subroutine draw_Q(nP, nE, XYP, IPE, qE, rQuality, fName)
C ==========================================================
      include 'colors.fd'
C ==========================================================
C Routine converts the mesh into a postcript file fName.
C ==========================================================
C group (M)
      Real*8  XYP(2, *), qE(*), rQuality
      Integer IPE(3, *)

C group (File)
      Character*(*) fName

C group (Local variables)
      Real  mmTOpt, kx, ky
      Real  x1, y1, x2, y2, x3, y3
      Real  fxmax, fymax

C ==========================================================
      mmTOpt = 72.0 / 25.4
      Pi = 4.0*atan(1.0)
      rdTOdg = 180.0 / Pi
      xBig = 150.0
      yBig = 150.0

      fxmax = XYP(1, 1)
      fxmin = fxmax
      fymax = XYP(2, 1)
      fymin = fymax

      Do n = 2, nP
         fxmin = min(fxmin, real(XYP(1, n)))
         fxmax = max(fxmax, real(XYP(1, n)))
         fymin = min(fymin, real(XYP(2, n)))
         fymax = max(fymax, real(XYP(2, n)))
      End do

      kx = xBig / (fxmax-fxmin) * mmTOpt
      ky = yBig / (fymax-fymin) * mmTOpt

      If(kx.GT.ky) kx = ky

      ibx = (fxmax-fxmin) * kx + 10
      iby = (fymax-fymin) * kx + 10

      Open(30, file = fName, status='UNKNOWN')
      Write(30,'(A)') '%!PS-Adobe-2.0 EPSF-2.0'
      Write(30,'(A,2I5)') '%%BoundingBox: 0 0 ', ibx, iby 
      Write(30,'(A)') '%%EndComments'

      Call PSini()
      Write(30,*) '5 5 translate'


      Do 10 n = 1, nE
         If(IPE(1, n).EQ.0) Goto 10
         x1 = (XYP(1, IPE(1, n)) - fxmin) * kx
         y1 = (XYP(2, IPE(1, n)) - fymin) * kx

         x2 = (XYP(1, IPE(2, n)) - fxmin) * kx
         y2 = (XYP(2, IPE(2, n)) - fymin) * kx

         x3 = (XYP(1, IPE(3, n)) - fxmin) * kx
         y3 = (XYP(2, IPE(3, n)) - fymin) * kx

         Write(30,*) 'newpath'
         Write(30,*) x1,y1, ' m', x2,y2, ' l', x3,y3, ' l'
         Write(30,'(A)') ' closepath'

c  ...   color all elements
c        Write(30,*) qE(n), ' setgray fill stroke'

c  ...   color only low-quality elements
         If(qE(n).LE.rQuality) Then
            Write(30,*) ' 0 fill stroke'
         Else
            Write(30,*) ' cBlack stroke'
         End if
 10   Continue

      Write(30,'(A)') 'showpage '
      Close(30)
      Return
      End



C ================================================================
      Subroutine draw_S(U, nP, XYP, nE, IPE, nF, IPF, fName, ni)
C ================================================================
C  Draw solution isolines. Their number is ni.
C ================================================================
      Real*8      U(*), XYP(2, *)
      Integer     IPE(3, *), IPF(4, *)
      Character*3 fName

c group (Local variables)
      Real*8   xymax(2), xymin(2), x(2), y(2), scale, kx
      Real*8   umin, umax, ucur, vi, tet

C ================================================================
      Do i = 1, 2
         xymin(i) = XYP(i, 1)
         xymax(i) = XYP(i, 1)
      End do

      umin = U(1)
      umax = umin

      Do n = 2, nP
         Do i = 1, 2
            xymin(i)=min(xymin(i), XYP(i, n))
            xymax(i)=max(xymax(i), XYP(i, n))
         End do

         umax = max(umax, U(n))
         umin = min(umin, U(n))
      End do

      scale = max(xymax(1) - xymin(1), xymax(2) - xymin(2))
      kx = 450.0 / scale

      Open(10, file = fName//".ps")
      Write(10, '(A)') '%!PS-Adobe-2.0 EPSF-2.0'
      Write(10, '(A)') '%%BoundingBox: 0 0  460 460'
      Write(10, '(A)') '%%EndComments'
      Write(10, '(A)') '10 10 translate 0 setlinewidth'
      Write(10, '(A)') '/v{moveto lineto stroke}def'

      Do n = 1, nE
         Do is = 1, ni 
            icount = 0
            ucur = umin + (is - 1) * (umax-umin) / (ni - 1)

            Do j = 1, 3
               If(j.GE.2) Then
                  k = j - 1
               Else
                  k = 3
               End if

               If(U(IPE(j, n)).EQ.U(IPE(k, n)) .AND.
     &            U(IPE(j, n)).EQ.ucur .AND. icount.LT.2) Then
                  x(1) = XYP(1, IPE(j, n))
                  x(2) = XYP(1, IPE(k, n))
                  y(1) = XYP(2, IPE(j, n))
                  y(2) = XYP(2, IPE(k, n))

                  vi = ucur

                  icount = 2
               End if

               If(((U(IPE(j, n)).LT.ucur .AND. ucur.LE.U(IPE(k, n)))
     &            .OR.
     &             (U(IPE(j, n)).GE.ucur .AND. ucur.GT.U(IPE(K,n))))
     &            .AND. 
     &            icount.LT.2) Then

                  icount = icount+1
                  tet = (ucur - U(IPE(j, n))) 
     &                 / (U(IPE(k, n)) - U(IPE(j, n)))

                  x(icount) = XYP(1,IPE(j, n)) + tet 
     &                      * (XYP(1,IPE(k, n)) - XYP(1,IPE(j, n)))

                  y(icount) = XYP(2,IPE(j, n)) + tet
     &                      * (XYP(2,IPE(k, n)) - XYP(2,IPE(j, n)))

                  vi = ucur
               End if
            End do

            If(icount.NE.0) Then
               Write(10,'(4F8.2,A)') 
     &            (x(1) - xymin(1)) * kx, (y(1) - xymin(2)) * kx,
     &            (x(2) - xymin(1)) * kx, (y(2) - xymin(2)) * kx,' v'
            End if
         End do
      End do


c ... draw the boundary
      Do n = 1, nF
         Write(10,'(4F8.2,A)') 
     &      (XYP(1, IPF(1, n)) - xymin(1)) * kx, 
     &      (XYP(2, IPF(1, n)) - xymin(2)) * kx,
     &      (XYP(1, IPF(2, n)) - xymin(1)) * kx, 
     &      (XYP(2, IPF(2, n)) - xymin(2)) * kx, ' v'
      End do

      Write(10,*) ' showpage'
      Close(10)

      Return
      End



C ==========================================================
      Subroutine PSini()
C ==========================================================
      Character*70 s

      Open(31, file='ps.lib', status='OLD', err=1000)
 1    Continue
      Read(31,'(A)', end=2) s
      Write(30,'(A)') s
      Goto 1
 2    Continue
      Close(31)
      Return

 1000 Continue
      Call errMes(4002, 'draw.f', 'Missing file ps.lib')

      End



