C ================================================================
      Real*8 Function calEdge(xy1, xy2)
C ================================================================
C Routine computes distance between two points
C ================================================================
      Real*8 xy1(2), xy2(2)

      calEdge = dsqrt((xy1(1) - xy2(1)) ** 2 +
     &                (xy1(2) - xy2(2)) ** 2)
      Return
      End



C ================================================================
      Real*8 Function calNorm(xy1)
C ================================================================
C Routine calculates norm of vector xy1 
C ================================================================
      Real*8 xy1(2)

      calNorm = dsqrt(xy1(1) ** 2 + xy1(2) ** 2)
      Return
      End



C ================================================================
      Real*8 Function DotMul(a, b)
C ================================================================
C Routine computes scalar product of two vectors
C ================================================================
      Real*8 a(2), b(2)

      DotMul = a(1) * b(1) + a(2) * b(2)
      Return
      End



C ================================================================
      Real*8 Function VecMul(a, b)
C ================================================================
C Routine computes vector product a x b which is a number in 2D.
C ================================================================
      Real*8 a(2), b(2)

      VecMul = a(1) * b(2) - a(2) * b(1)
      Return
      End



C ================================================================
      Logical Function check1(i1, j)
C ================================================================
C check1 = TRUE if i1 belongs to the set j(3).
C ================================================================
      Integer j(3)

      check1 = .TRUE.
      If(i1.EQ.j(1)) Goto 1000
      If(i1.EQ.j(2)) Goto 1000
      If(i1.EQ.j(3)) Goto 1000
 
      check1 = .FALSE.
 1000 Return
      End



C ================================================================
      Logical Function check2(i1, j1, j2)
C ================================================================
C check2 = TRUE if i1 belongs to the set {j1, j2}.
C ================================================================
      check2 = .TRUE.
      If(i1.EQ.j1) Goto 1000
      If(i1.EQ.j2) Goto 1000

      check2 = .FALSE.
 1000 Return
      End


C ================================================================
      Logical Function check3(i1, i2, j1, j2)
C ================================================================
C check3 = TRUE if pair {i1, i2} coinsides with {j1, j2}.
C ================================================================
      check3 = .FALSE.
      If(i1.NE.j1 .AND. i1.NE.j2) Goto 1000
      If(i2.NE.j1 .AND. i2.NE.j2) Goto 1000

      check3 = .TRUE.
 1000 Return
      End


C ================================================================
      Subroutine swapii(i1, i2)
C ================================================================
C Routine swaps two integers 
C ================================================================
      i  = i1
      i1 = i2
      i2 = i

      Return
      End



C ================================================================
      Subroutine swapdd(d1, d2)
C ================================================================
C Routine swaps two real*8 numbers
C ================================================================
      Real*8 d, d1, d2
      d  = d1
      d1 = d2
      d2 = d

      Return
      End

