C ================================================================
C STEP 1: Examples of different tensors
C ================================================================
      Integer Function Ddiff(x, y, label, DATA, iSYS, Diff)
C ================================================================
      include 'fem2Dtri.fd'
C ================================================================
      Real*8  x, y, DATA(*), Diff(4, 4)
      Integer iSYS(*)
C ================================================================
      iSYS(1) = 2
      iSYS(2) = 2

      Do i = 1, 2
         Do j = 1, 2
            Diff(i, j) = 0D0
         End do
         Diff(i, i) = 1D0
      End do
c     Diff(2, 2) = 1D0
c     Diff(1, 1) = 1D0

      Ddiff = TENSOR_SYMMETRIC
      Ddiff = TENSOR_NULL

      Return
      End



C ================================================================
C STEP 2: Examples of essential boundary conditions
C ================================================================
      Integer Function Dbc(x, y, label, DATA, iSYS, eBC)
C ================================================================
      Include 'assemble.fd'
C ================================================================
      Real*8  x, y, DATA(*), eBC(*)
      Integer iSYS(*)

      Real*8  pi
      Data    pi/3.14159265358979D0/

C ================================================================
      iSYS(1) = 1
      iSYS(2) = 1

      If(x.EQ.0) Then
         Dbc = BC_NEUMANN
         eBC(1) = -dsin(pi * y) * pi  
      Else
         Dbc = BC_DIRICHLET
         eBC(1) = 0D0
      End if

      Dbc = BC_DIRICHLET
      eBC(1) = 0D0

      Return
      End



C ================================================================
C STEP 3: Examples of sourse data
C ================================================================
      Integer Function Drhs_scalar(x, y, label, DATA, iSYS, F)
C ================================================================
      Include 'fem2Dtri.fd'
C ================================================================
      Real*8  x, y, DATA(*), F(*)
      Integer iSYS(*)

      Real*8  pi
      Data    pi/3.14159265358979D0/

C ================================================================
      iSYS(1) = 1
      iSYS(2) = 1

C     F(1) = dsin(pi * x) * dsin(pi * y) * 2 * pi * pi 
      F(1) = 1D0

      Drhs_scalar = TENSOR_SCALAR

      Return
      End


C ================================================================
      Integer Function Drhs_vector(x, y, label, DATA, iSYS, F)
C ================================================================
      Include 'fem2Dtri.fd'
C ================================================================
      Real*8  x, y, DATA(*), F(*)
      Integer iSYS(*)

      iSYS(1) = 1
      iSYS(2) = 2
     
      F(1) = 1D0
      F(2) = 2D0

      Drhs_vector = TENSOR_GENERAL

      Return
      End 


C ================================================================
C STEP 4: Examples of exact solutions
C ================================================================
      Integer Function Dexact(x, y, label, DATA, iSYS, U)
C ================================================================
      Include 'fem2Dtri.fd'
C ================================================================
      Real*8  x, y, DATA(*), U(*)
      Integer iSYS(*)

      Real*8  pi
      Data    pi/3.14159265358979D0/

C ================================================================
      iSYS(1) = 1
      iSYS(2) = 1

      U(1) = dsin(pi * x) * dsin(pi * y) 

      Dexact = TENSOR_NULL

      Return
      End
