C ================================================================
      Subroutine FEM1Dedge(
C ================================================================
     &      XY1, XY2,  
     &      operatorA, FEMtypeA, operatorB, FEMtypeB, 
     &      label, D, DATA, order, 
     &      LDA, A, nRow, nCol)
C ================================================================
      include 'fem2Dtri.fd'
C ================================================================
C Routine inmplements a bilinear form on a mesh edge. 
C The notations are described in fem2Dtri.f
C ================================================================
      Real*8   XY1(2), XY2(2)

      Real*8   DATA(*)
      Integer  label, D
      EXTERNAL D

      Integer  FEMtypeA, FEMtypeB, operatorA, operatorB
      Integer  order, LDA

      Real*8   A(LDA, *)
C ================================================================
C group (Local variables)
      Real*8  U(2, 4, MaxPointGauss),    V(2, 4, MaxPointGauss)
      Real*8  Diff(2, 2, MaxPointGauss), DU(2, 4, MaxPointGauss)

      Real*8  w(MaxPointGauss), XYG(2, MaxPointGauss)
      Real*8  XYL(2, 1)

      Integer tensor, iSYS(2)
      Logical FEMtype, operator
C ================================================================
      DATA XYL/5D-1, 5D-1/
C ================================================================
      If(order.LE.0 .OR. order.GT.1) 
     &  Call errMes(2001, 'fem1Dedge', 'input data are wrong')

      FEMtype = FEMtypeA.EQ.FEMtypeB
      operator = operatorA.EQ.operatorB


c ... weights and points
      Call Weights1D(XY1, XY2, order, XYG, w, iGauss, iL)


c ... compute operatorA * FEMtypeA
      If(operatorA.EQ.IDEN) Then
         Call applyIDEN1D(iGauss, XYL, FEMtypeA, nfa, idim, U)
      Else
         Call errMes(2001, 'fem1Dedge', 'operatorA is not supported')
      End if
      If(nfa.GT.LDA) Call errMes(2001, 'fem1Dedge',
     &     'the local matrix leading dimension, LDA, is too small')


c ... compute operatorB * FEMtypeB
      nfb = nfa
      jdim = idim
      if(operator .AND. FEMtype) Goto 100

      If(operatorB.EQ.IDEN) Then
         Call applyIDEN1D(iGauss, XYL, FEMtypeB, nfb, jdim, V)
      Else
         Call errMes(2001, 'fem1Dedge', 'operatorB is not supported')
      End if
      If(nfb.GT.LDA) Call errMes(2001, 'fem1Dedge',
     &     'the local matrix second dimension, LDA, is too small')

 

c ... compute D * U
 100  iD = jdim
      jD = idim

      Do n = 1, iGauss
         tensor = D(XYG(1, n), XYG(2, n), label, 
     &                         DATA, iSYS, Diff(1, 1, n))
         If(tensor.EQ.TENSOR_NULL) Goto 200
      End do
      iD = iSYS(1)
      jD = iSYS(2)


 200  Continue
      If(tensor.EQ.TENSOR_NULL) Then
         If(idim.NE.jdim) Call errMes(2001, 
     &        'fem1Dedge', 'the operators A and B are not compatible')

         Do n = 1, iGauss
            Do i = 1, idim
               Do k = 1, nfa
                  DU(i, k, n) = U(i, k, n) * w(n)
               End do
            End do
         End do
      Else If(tensor.EQ.TENSOR_SCALAR) Then
         If(idim.NE.jdim) Call errMes(2001, 'fem1Dedge', 
     &        'the operators A and B are not compatible')

         Do n = 1, iGauss
            s = Diff(1, 1, n) * w(n) 
            Do i = 1, idim
               Do k = 1, nfa
                  DU(i, k, n) = U(i, k, n) * s
               End do
            End do
         End do
      Else If(tensor.EQ.TENSOR_SYMMETRIC .OR. 
     &        tensor.EQ.TENSOR_GENERAL) Then
         If(jD.NE.idim .OR. iD.NE.jdim) Call errMes(2001, 
     &        'fem1Dedge', 'operators A and B are not compatible')

         Do n = 1, iGauss
            Do i = 1, iD
               Do k = 1, nfa
                  s = 0D0
                  Do j = 1, jD
                     s = s + Diff(i, j, n) * U(j, k, n)
                  End do
                  DU(i, k, n) = s * w(n)
               End do
            End do
         End do
      Else
         Call errMes(2001, 'fem1Dedge', 
     &        'the user-defined tensor is not supported') 
      End if


c ... compute <D U, V>
      If(operator .AND. FEMtype .AND. tensor.NE.TENSOR_GENERAL) Then
         Do i = 1, nfa
            Do j = 1, i - 1
               A(i, j) = A(j, i)
            End do

            Do j = i, nfa
               s = 0D0
               Do k = 1, iD
                  Do n = 1, iGauss
                     s = s + DU(k, i, n) * U(k, j, n)
                  End do
                  A(i, j) = s
               End do
            End do
         End do
      Else If(operator .AND. FEMtype) Then
         Do i = 1, nfa
            Do j = 1, nfa
               s = 0D0
               Do k = 1, iD
                  Do n = 1, iGauss
                     s = s + DU(k, i, n) * U(k, j, n)
                  End do
                  A(i, j) = s
               End do
            End do
         End do
      Else 
         Do i = 1, nfa
            Do j = 1, nfb
               s = 0D0
               Do k = 1, iD
                  Do n = 1, iGauss
                     s = s + DU(k, i, n) * V(k, j, n)
                  End do
                  A(i, j) = s
               End do
            End do
         End do
      End if

      nRow = nfa
      nCol = nfb

      Return
      End



c ==============================================================
      Subroutine applyIDEN1D(iGauss, XYL, FEMtype, nfa, dim, U)
c ==============================================================
      include 'fem2Dtri.fd'
c ==============================================================
      Integer iGauss, FEMtype, nfa, dim
      Real*8  XYL(2, *), U(2, 4, *)
c ==============================================================
c Local variables 
      Real*8  vol, edge, calEdge, xyn(2), xym(2)
      Real*8  x, y, Lfun, s
c ==============================================================
      If(FEMtype.EQ.FEM_P0) Then
         nfa = 1
         dim = 1
         Do n = 1, iGauss
            U(1, 1, n) = 1D0
         End do
      Else If(FEMtype.EQ.FEM_P1) Then
         nfa = 2
         dim = 1
         Do n = 1, iGauss
            Do i = 1, nfa
               U(1, i, n) = XYL(i, n)
            End do
         End do
      Else
         nfa = 0
         dim = -FEMtype
         Call errMes(2001, 'fem1Dedge', 
     &        'unsupported operation for the given element type')
      End if
      Return
      End


c ==============================================================
      Subroutine Weights1D(XY1, XY2, order, XYG, w, iGauss, iLref)
c ==============================================================
      include 'fem2Dtri.fd'
c ==============================================================
      Real*8  XY1(2), XY2(2)
      Integer order

      Real*8  XYG(2, *), w(*), vol
      Integer iGauss, iLref
c ==============================================================
      vol = dsqrt((XY2(1) - XY1(1)) ** 2 + (XY2(2) - XY1(2)) ** 2) 

      If(order.LE.2) Then
         iGauss = 1
         iLref = 1
         w(1) = vol

         Do i = 1, 2
            XYG(i, 1) = (XY1(i) + XY2(i)) / 2
         End do
      End if
      Return
      End



