
C ================================================================
      SUBROUTINE TRISEC( X1,Y1, X2,Y2, X3,Y3, V1,V2,V3,
     &           VMIN, VSTEP, MESH, KX, Nunit )
C ================================================================
      REAL*4     V1,V2,V3
      REAL*4     VMIN, VSTEP, KX
      INTEGER*4  MESH

      REAL*4     VMAX, VISO
      REAL*4     X1,Y1, X2,Y2, X3,Y3
      INTEGER*4  XX1,YY1, XX2,YY2, XX3,YY3
      INTEGER*4  STT12, STT13

C ================================================================
      VMAX=MAX(V1,V2)
      VMAX=MAX(VMAX,V3)
      IF( MESH.EQ.1 ) THEN
          XX1=X1*KX
          YY1=Y1*KX
          XX2=X2*KX
          YY2=Y2*KX
          XX3=X3*KX
          YY3=Y3*KX
          WRITE(Nunit,'(I4,3I5,A)') XX1,YY1, XX2,YY2,' v'
          WRITE(Nunit,'(I4,3I5,A)') XX2,YY2, XX3,YY3,' v'
          WRITE(Nunit,'(I4,3I5,A)') XX1,YY1, XX3,YY3,' v'
          RETURN
      END IF
C
      VISO=VMIN+VSTEP*0.5
      DO WHILE( VISO.LE.VMAX )
         STT12=0
         STT13=0
         IF( V1.LT.VISO .AND. VISO.LE.V2 .OR.
     &       V1.GT.VISO .AND. VISO.GE.V2 ) THEN
             STT12=1
             XX1=(X1+(VISO-V1)/(V2-V1)*(X2-X1))*KX
             YY1=(Y1+(VISO-V1)/(V2-V1)*(Y2-Y1))*KX
         END IF
         IF( V1.LE.VISO .AND. VISO.LT.V3 .OR.
     &       V1.GE.VISO .AND. VISO.GT.V3 ) THEN
             STT13=1
             XX2=(X1+(VISO-V1)/(V3-V1)*(X3-X1))*KX
             YY2=(Y1+(VISO-V1)/(V3-V1)*(Y3-Y1))*KX
             IF( STT12.EQ.1 )
     &        WRITE(Nunit,'(I4,3I5,A)') XX1,YY1, XX2,YY2,' v'
         END IF
         IF( V2.LT.VISO .AND. VISO.LE.V3 .OR.
     &       V2.GT.VISO .AND. VISO.GE.V3 ) THEN
             XX3=(X2+(VISO-V2)/(V3-V2)*(X3-X2))*KX
             YY3=(Y2+(VISO-V2)/(V3-V2)*(Y3-Y2))*KX
             IF( STT12.EQ.1 )
     &        WRITE(Nunit,'(I4,3I5,A)') XX1,YY1, XX3,YY3,' v'
             IF( STT13.EQ.1 )
     &        WRITE(Nunit,'(I4,3I5,A)') XX2,YY2, XX3,YY3,' v'
         END IF
         VISO=VISO+VSTEP
      END DO
      RETURN
      END








   


