c ==============================================================
      Subroutine mulAgen(N, IA, JA, A, U, AU)
c ==============================================================
c  Computing  AU = A * U 
c ==============================================================
      Integer N, IA(*), JA(*)
      Real*8  A(*), U(*), AU(*)
c ==============================================================
      Do k = 1, N
         AU(k) = 0D0
      End do

      Do k = 1, N
         Do i = IA(k), IA(k + 1) - 1
            AU(k) = AU(k) + A(i) * U(JA(i))
         End do
      End do
      Return
      End


c ==============================================================
      Subroutine AMG2CSC(NA, IA, JA, A, NB, IB, JB, B)
c ==============================================================
c  Converting the AMG format (CSR) to the compressed 0-based 
C  column format (CSC).
C
C  *** Note: 1. size(IB) = max(JA) + 1
C            2. size(JB) = size(JA)
C            3. size(B) = size(A) 
c ==============================================================
      Integer NA, IA(*), JA(*)
      Integer NB, IB(*), JB(*)
      Real*8  A(*), B(*)

      M = IA(NA + 1) - 1

c ... compute the number of rows
      NB = 0
      Do i = 1, M
         NB = max(NB, JA(i))
      End do


c ... compute the number of non-zero elements in each row
      Do i = 1, NB
         IB(i) = 0
      End do

      Do i = 1, M
         j = JA(i)
         IB(j) = IB(j) + 1 
      End do 

      Do i = 1, NB
         IB(i + 1) = IB(i + 1) + IB(i)
      End do
      IB(NB + 1) = IB(NB) + 1


c ... copy matrix A to matrix B
      Do i = NA, 1, -1
         Do j = IA(i), IA(i + 1) - 1
            k = JA(j)

            l = IB(k)
            IB(k) = l - 1

            JB(l) = i
             B(l) = A(j)
         End do
      End do

      Do i = 1, NB
         IB(i) = IB(i) + 1
      End do

      Return
      End



c ==============================================================
      Subroutine CSC2AMG(NA, IA, JA, A, NB, IB, JB, B)
c ==============================================================
c  Converting the compressed 0-based column format (CSC) to the
C  AMG (row-wice) format.
C
C  *** Note: 1. size(IB) = max(JA) + 1
C            2. size(JB) = size(JA)
C            3. size(B) = size(A) 
c ==============================================================
      Integer NA, IA(*), JA(*)
      Integer NB, IB(*), JB(*)
      Real*8  A(*), B(*)

      Call AMG2CSC(NA, IA, JA, A, NB, IB, JB, B)

      Do 10 i = 1, NB
         j1 = IB(i)
         j2 = IB(i + 1) - 1

         Do j = j1, j2
            k = JB(j)
            If(k.EQ.i) Then
               Call swapii(JB(j), JB(j1)) 
               Call swapdd( B(j),  B(j1))
               Goto 10
            End if
         End do
 10   Continue

      Return
      End



c ==============================================================
      Subroutine comABgen(nA, IA, JA, A, nB, IB, JB, B, 
     &                    MaxC, IC, JC, C, nColB, iW)
c ==============================================================
c  Computing  C = A * B
c ==============================================================
      Integer IA(*), JA(*), IB(*), JB(*), IC(*), JC(*)
      Real*8  A(*), B(*), C(*)

      Integer iW(*)
c ==============================================================
      nC = 0
      iC(1) = 1

      Do n = 1, nColB
         iW(n) = 0
      End do
      
      Do i = 1, nA
         If(nC + nColB.GT.MaxC) Call errMes(1004, 
     &        'algebra', 'Not enough memory for the matrix')

         If(k.LE.nColB) Then
            nC = nC + 1
            JC(nC) = i
            iW(i) = nC
         End if

         Do k = IA(i), IA(i + 1) - 1
            Do l = IB(k), IB(k + 1) - 1
               j = JB(l)
               m = iW(j)
               If(m.NE.0) Then 
                  C(m) = C(m) + A(k) * B(l)
               Else
                  nC = nC +  1
                  JC(nC) = j
                  iW(j) = nC
                  C(nC) = A(k) * B(l)
               End if
            End do
         End do
         IC(i + 1) = nC + 1

         Do k = IC(i), nC 
            iW(JC(k)) = 0
         End do
      End do
      Return
      End
