#include<ctype.h>
#include<string.h>
#include<stdlib.h>

#include"draft2.h"
#include"struct2.h"
#include"tree2.h"
#include"memory2.h"
#include"user2.h"
#include"region2.h"
#include"debug2.h"
#include"error2.h"


StrucMesh2  mesh2;
extern StrucTree2  tree2;
extern int boolShow,boolDraft,boolFAF;
int  boolSize=0,boolNav=0,boolRegul=0;


char *readParameter( void )
{
   static int  n=0;
   static char Near s[128];
   static FILE *f;
   int  i,j,ii=1;
   int  c=0;

   if( n < 0 ){
      n = 0;
      return(NULL);
   }
   if(n==0){
      f=fopen(mesh2.parFileName,"r");
      if( f == NULL )
	errorExit2(1,"Cann't  open  file");
   }

   for(i=0,j=0;;i++){
      c=fgetc(f);
      if( c == EOF ){
	 if( j ){  n = -10;  goto  end_read;  }
	 else{  fclose(f); n = 0; return( NULL );  }
      }
      if( isspace(c) ){
	 if(ii)   continue;
	 else     goto  end_read;
      }
      else{ s[j] = c; ii = 0; j++; }
   }
end_read:
   s[j] = 0;
   n++;

   return  s;
}/*readParameter*/


extern int    boolDraftglobal, boolFAFglobal, mesh2nSmoothglobal;


void initParameter( void)
{
   char  c='a',*pc, *dummy=0;

   
   boolDraft = boolDraftglobal;
   boolFAF = boolFAFglobal;
   boolSize = 1;
   mesh2.nSmooth = mesh2nSmoothglobal;
   initUserParameters(dummy);
   return;
  
   pc = readParameter();
   while( pc ){
      c = tolower(*pc);   pc++;
      switch( c ){
      case 'f':
         c = tolower(*pc);   pc++;
	 switch ( c ){
	 case 'i':  strcpy(mesh2.inFileName,pc);    break;
	 case 'o':  strcpy(mesh2.outFileName,pc);   break;
         case 'u':  boolFAF = atoi(pc);   break;
         default:   printf("unrecognized  option"); break;
	 }/*switch*/
      break;
      case 'b':
	 c = tolower(*pc);   pc++;
	 switch ( c ){
         case 'd':  boolDraft= atoi(pc);break;
         case 'f':  boolSize = atoi(pc);break;
	 case 'g':  boolShow = atoi(pc);break;
         case 'n':  boolNav = atoi(pc);break;
         case 'r':  boolRegul = atoi(pc);break;
	 case 's':  mesh2.nSmooth = atoi(pc);break;
	 default:   printf("unrecognized  option");break;
	 }
      break;
      default:
         initUserParameters(pc-1);break;
      }/*switch*/
      pc = readParameter();
   }/* while */

   return;
}/*initParameter*/


void init( void )
{
/* printf(" Generator  of  unstructured  2-D  meshes.\n");
   printf(" (c) Copyright  1993-95.\n");
   printf(" LabNumMath ( INM ).\n");
   printf(" Version July, 18, 1995.\n");
*/
   mesh2.nPoint = 0;
   mesh2.nTria = 0;
   mesh2.nRegion = 1;
   mesh2.nRLine = 0;
   mesh2.iRLine = 0;
   mesh2.nSmooth = 5;
   strcpy(mesh2.outFileName,"");
   strcpy(mesh2.inFileName,"");
   strcpy(mesh2.debFileName,"debug");

   mesh2.debug = 1;
   tree2.nFace = 0;

   initMemory();
   initParameter();
   if( boolDraft )
     initDraft2();
#ifdef DEBUG2
   if( mesh2.debug )
     initDebug2();
#endif

//   tree2.root->flag = EMPTY;
	tree2.root->entrycount = 0;
	tree2.root->parent = 0;
	tree2.root->nodelist[0] = 0;
	tree2.root->nodelist[1] = 0;
	tree2.root->nodelist[2] = 0;
	tree2.root->nodelist[3] = 0;
	tree2.root->firstentry = 0;
   return;
}/*init*/


void addPoint( double x, double y )
{
   if( mesh2.nPoint >= mesh2.maxPoint )
     errorExit2(2,"mesh2.nPoint >= mesh2.maxPoint");
   mesh2.x[mesh2.nPoint] = x;
   mesh2.y[mesh2.nPoint] = y;
   mesh2.nPoint++;

   return;
}/*addPoint*/


void addTria( int v1, int v2, int v3, int lab )
{
   if( mesh2.nTria >= mesh2.maxTria )
     errorExit2(2,"mesh2.nTria >= mesh2.maxTria");
   mesh2.v1[mesh2.nTria] = v1;
   mesh2.v2[mesh2.nTria] = v2;
   mesh2.v3[mesh2.nTria] = v3;
   mesh2.label[mesh2.nTria] = lab;
   mesh2.nTria++;

   return;
}/*addTria*/


void addNeigbor( int v1, int v2 )
{
   int n;

   n = mesh2.neigbor[0][v1];
   if( n >= 0 ){
      if( n >= MAX_NEIGBOR2 )
	errorExit2(2,"n >= MAX_NEIGBOR2");
      mesh2.neigbor[0][v1]++;
      mesh2.neigbor[n+1][v1] = v2;
   }

   n = mesh2.neigbor[0][v2];
   if( n >= 0 ){
      if( n >= MAX_NEIGBOR2 )
	errorExit2(2,"n >= MAX_NEIGBOR2");
      mesh2.neigbor[0][v2]++;
      mesh2.neigbor[n+1][v2] = v1;
   }

   return;
}/*addNeigbor*/

extern int    nVRTglobal;
extern double *vrtglobal;
extern int    nTRIglobal, *triglobal, *labtriglobal;

void outMesh( void )
{
   int vv1,vv2,vv3,i;
   double x,y/*,s*/;
//   FILE *f;
//   char name[128];
//   char ext_p[]=".ps",ext_t[]=".tri",ext_v[]=".vrt";

   nVRTglobal = mesh2.nPoint;
   vrtglobal = (double*) malloc(sizeof(double)*(2*nVRTglobal));

   for(i=0;i<mesh2.nPoint;i++){
          x=*(mesh2.x+i);   y=*(mesh2.y+i);
          vrtglobal[2*i] = x;
          vrtglobal[2*i+1] = y;
   }

   nTRIglobal = mesh2.nTria;
   triglobal = (int*) malloc(sizeof(int)*(3*nTRIglobal));
   labtriglobal = (int*) malloc(sizeof(int)*(nTRIglobal));
   for(i=0;i<mesh2.nTria;i++){
          vv1=1+*(mesh2.v1+i);   vv2=1+*(mesh2.v2+i);   vv3=1+*(mesh2.v3+i);
          triglobal[3*i] = vv1;
          triglobal[3*i+1] = vv2;
          triglobal[3*i+2] = vv3;
          labtriglobal[i] = mesh2.label[i];
   }




/* strcpy(name,mesh2.outFileName); strcat(name,ext_v);
   f=fopen(name,"w");
   if( f == NULL )
     errorExit2(3,"can't open  file ");
   fprintf(f,"%8d",mesh2.nPoint);
   fprintf(f,"%8d",mesh2.nRegion);
   if( boolFAF ){
      fprintf(f,"%8d",mesh2.nPoint);
   }
   else
     for(i=0;i<mesh2.nRegion;i++){
        fprintf(f,"%8d",mesh2.nRPoint[i]);
     }
   fprintf(f,"\n\n");
   for(i=0;i<mesh2.nPoint;i++){
	  x=*(mesh2.x+i);   y=*(mesh2.y+i);
          if( boolSize ){
             s = sizeFace(x,y);
             fprintf(f,"%12.11lf %12.11lf %12.11lf\n",x,y,s);
          }
          else
	    fprintf(f,"%12.11lf %12.11lf\n",x,y);
   }
   fclose(f);  

   strcpy(name,mesh2.outFileName); strcat(name,ext_t);
   f=fopen(name,"w");
   if( f == NULL )
     errorExit2(3,"can't open  file ");
   fprintf(f,"%8d",mesh2.nTria);
   fprintf(f,"%8d",mesh2.nRegion);
   if( boolFAF ){
      fprintf(f,"%8d",mesh2.nTria);
   }
   else
     for(i=0;i<mesh2.nRegion;i++){
        fprintf(f,"%8d",mesh2.nRTria[i]);
     }
   fprintf(f,"\n\n");
   for(i=0;i<mesh2.nTria;i++){
	  vv1=1+*(mesh2.v1+i);   vv2=1+*(mesh2.v2+i);   vv3=1+*(mesh2.v3+i);
      fprintf(f,"%5d %5d %5d\n",vv1,vv2,vv3);
   }
   fclose(f);

   strcpy(name,mesh2.outFileName); strcat(name,ext_p);
   f=fopen(name,"w");
   if( f == NULL )
     errorExit2(3,"can't open  file ");

   fprintf(f,"10 10 translate\n");
   fprintf(f,"0.001 setlinewidth\n");
   fprintf(f,"/showTriangle{moveto lineto lineto lineto stroke}def\n");
   fprintf(f,"500 dup scale\n");
   for(i=0;i<mesh2.nTria;i++){
	  vv1=*(mesh2.v1+i);   vv2=*(mesh2.v2+i);   vv3=*(mesh2.v3+i);

	  x=*(mesh2.x+vv1);   y=*(mesh2.y+vv1);
	  fprintf(f,"%12.11lf%c%12.11lf%c",x,' ',y,' ');

	  x=*(mesh2.x+vv2);   y=*(mesh2.y+vv2);
	  fprintf(f,"%12.11lf%c%12.11lf%c",x,' ',y,' ');

	  x=*(mesh2.x+vv3);   y=*(mesh2.y+vv3);
	  fprintf(f,"%12.11lf%c%12.11lf%c",x,' ',y,' ');

	  x=*(mesh2.x+vv1);   y=*(mesh2.y+vv1);
	  fprintf(f,"%12.11lf%c%12.11lf%c",x,' ',y,' ');

	  fprintf(f,"showTriangle\n");
   }
   fprintf(f,"showpage\n");
   fclose(f); */

   if( boolNav )
     userOutMesh();

   return;
}/*outMesh*/





