      program main ! example of calls of mesh generator with segment data
      implicit none
      integer nvmax,ntmax,nbmax
c     nvmax   - maximum number of mesh nodes
c     ntmax   - maximum number of mesh triangles
c     nbmax   - maximum number of boundary edges
      parameter(nvmax=150000,ntmax=2*nvmax,nbmax=10000)

c mesh generator data specifying domain via in the segment format
      double precision vbr(2,16)
      integer          brd(2,16)
      integer          Nbr
      data             Nbr/16/   ! number of nodes at the boundary
      data             vbr/0,0.25, 0,0.375, 0,0.5, 0.17,0.5, 0.34,0.5, ! coordinates x,y of each node
     &                     0.5,0.5, 0.66,0.5, 0.83,0.5, 1,0.5, 
     &                     1,0.375, 1,0.25, 0.83,0.25, 0.66,0.25, 
     &                     0.5,0.25, 0.34,0.25, 0.17,0.25/
      data             brd/1,2, 2,3, 3,4, 4,5, 5,6, 6,7, 7,8, 8,9, 9,10, ! edges of the boundary mesh
     &                   10,11, 11,12, 12,13, 13,14, 14,15, 15,16, 16,1/
! attention: edges of brd should be contiguous and ordered clockwise if to look at the boundary from the domain

      integer          nv,nt,nb
      double precision vrt(2,nvmax)
      integer          material(ntmax),tri(3,ntmax),bnd(4,nbmax)



C Generate a mesh  starting  from boundary mesh
      call aft2dfront(
     &           Nbr, brd, Nbr, vbr,                         ! segment data
     &           nv, vrt,                                    ! mesh data on output
     &           nt, tri, material,
     &           nb, bnd)


      write(*,*) ' Number of triangles/vertices ',nt,nv 
      call graph(nv,vrt,nt,tri,'aft')
  
      end


      subroutine graph(nv,vrt,nt,tri,name)
      character*3 name
      integer nv,nt
      double precision vrt(2,*)
      integer          tri(3,*)
      real  kx
      double precision xymax(2),xymin(2), scale
      integer UNIT,CHAN
      integer k,l,i

      xymin(1)=vrt(1,1)
      xymin(2)=vrt(2,1)
      xymax(1)=vrt(1,1)
      xymax(2)=vrt(2,1)
      do i=2,nv
         xymin(1)=min(xymin(1),vrt(1,i))
         xymin(2)=min(xymin(2),vrt(2,i))
         xymax(1)=max(xymax(1),vrt(1,i))
         xymax(2)=max(xymax(2),vrt(2,i))
      end do
      scale = max(xymax(1)-xymin(1),xymax(2)-xymin(2))
      KX=500.0 / scale
      OPEN( UNIT=1, FILE=name//".ps" )
      WRITE(1,*) ' 10 10 translate 0 setlinewidth'
      WRITE(1,*)' /t{newpath moveto lineto lineto closepath stroke}def'
      do k=1,nt
        WRITE(1,*)(((vrt(i,tri(l,k))-xymin(i))*kx,i=1,2),l=1,3),' t'
      end do
      WRITE(1,*) ' showpage'
      close(1)
      return
      end

