      program main  ! example of calls of mesh generator with analytic geometry
      implicit none
      integer nvmax,ntmax,nbmax
c     nvmax   - maximum number of mesh nodes
c     ntmax   - maximum number of mesh triangles
c     nbmax   - maximum number of boundary edges
      parameter(nvmax=150000,ntmax=2*nvmax,nbmax=10000)

c mesh generator data specifying domain analytically

c rectangle
c     double precision bv(2,4),bltail(2,4) 
c     integer          Nbv,Nbl,bl(7,4)
c     data             Nbv/4/,Nbl/4/
c     data             bv/0.0,0.25, 0.0,0.5, 1.0,0.5, 1.0,0.25/  ! boundary nodes
c     data             bl/1,2,0,0,1,1,0, 3,4,0,0,2,1,0,          ! outer boundary edges
c    &                    2,3,0,0,3,1,0, 4,1,0,0,4,1,0/          ! outer boundary edges
c     data             bltail/0,0, 0,0, 0,0, 0,0/                ! curved data for each outer boundary edge

c complement of a wing NACA0012 to the unit square
      double precision bv(2,7),bltail(2,8)
      integer          Nbv,Nbl,bl(7,8)
      data             Nbv/7/,Nbl/8/
      data             bv/0,0, 0,1, 1,1, 1,0, .4,.5, .6,.5, 1,.5/       ! boundary nodes
      data             bl/1,2,0,-1,-1,1,0, 4,1,0,-1,-1,1,0,             ! outer boundary edges
     &                    2,3,0,-1,1,1,0,  7,4,0,-1,1,1,0,              ! outer boundary edges
     &                    3,7,0,-1,1,1,0,                               ! outer boundary edges
     &                    6,7,2,0,11,1,1,                               ! slit  boundary edges
     &                    6,5,1,-1,2,1,0,  5,6,1,-1,2,1,0/              ! wing  boundary edges
      data             bltail/0,0, 0,0, 0,0, 0,0, 0,0, 0,1, 0,.5, .5,1/ ! curved data for each outer boundary edge

      integer nv,nt,nb,nc
      double precision crv(2,nvmax), vrt(2,nvmax)
      integer          iFNC(nvmax),material(ntmax),
     &                 tri(3,ntmax),bnd(4,nbmax)
      double precision h

c to pass the name of the user function userBoundary (crv_model.c)  to the library 
      external userboundary              ! function in crv_model.c
      call registeruserfn( userboundary )! register the name to be used in the library

      h = 0.02                           !  mesh step of the quasi-uniform mesh to be generated
C Generate quasiuniform mesh with meshstep h
      call aft2dboundary( Nbv, bv, Nbl, bl, bltail,  h,     ! geomtric data
     &           nv, vrt,                                   ! mesh data on output
     &           nt, tri, material,
     &           nb, bnd,
     &           nc, crv, iFNC )
      write(*,*) 'mesh1: number of triangles/vertices ',nt,nv 
      call graph(nv,vrt,nt,tri,'aft')

  
      end
c---------------------------------------------------
      subroutine graph(nv,vrt,nt,tri,name)
      character*3 name
      integer nv,nt
      double precision vrt(2,*)
      integer          tri(3,*)
      real  kx
      double precision xymax(2),xymin(2), scale
      integer UNIT,CHAN
      integer k,l,i

      xymin(1)=vrt(1,1)
      xymin(2)=vrt(2,1)
      xymax(1)=vrt(1,1)
      xymax(2)=vrt(2,1)
      do i=2,nv
         xymin(1)=min(xymin(1),vrt(1,i))
         xymin(2)=min(xymin(2),vrt(2,i))
         xymax(1)=max(xymax(1),vrt(1,i))
         xymax(2)=max(xymax(2),vrt(2,i))
      end do
      scale = max(xymax(1)-xymin(1),xymax(2)-xymin(2))
      KX=500.0 / scale
      OPEN( UNIT=1, FILE=name//".ps" )
      WRITE(1,*) ' 10 10 translate 0 setlinewidth'
      WRITE(1,*)' /t{newpath moveto lineto lineto closepath stroke}def'
      do k=1,nt
        WRITE(1,*)(((vrt(i,tri(l,k))-xymin(i))*kx,i=1,2),l=1,3),' t'
      end do
      WRITE(1,*) ' showpage'
      close(1)
      return
      end

