      program main ! example of calls of mesh generator with segment data
      implicit none
      integer nvmax,ntmax,nbmax
c     nvmax   - maximum number of mesh nodes
c     ntmax   - maximum number of mesh triangles
c     nbmax   - maximum number of boundary edges
      parameter(nvmax=150000,ntmax=2*nvmax,nbmax=10000)

c mesh generator data specifying domain via in the segment format
      double precision vbr(2,nbmax)
      integer          Nbr,Nvr,brd(2,nbmax)


      integer          nv,nt,nb
      double precision vrt(2,nvmax)
      integer          material(ntmax),tri(3,ntmax),bnd(4,nbmax)

      integer          i,j,dummy

      open(1,file='../src/aniAFT/examples/front1') ! file input contains number of points
      read(1,*) Nvr, Nbr                ! and their coordinates
      do i = 1, Nvr
        read(1,*) (vbr(j,i),j=1,2)
      end do
      do i = 1, Nbr
        read(1,*) (brd(3-j,i),j=1,2)
      end do
      close(1)
C Generate a mesh  starting  from boundary mesh
      call aft2dfront(
     &           Nbr, brd, Nbr, vbr,                         ! segment data
c     &           0,dummy, Nbr, vbr,                         ! segment data
     &           nv, vrt,                                    ! mesh data on output
     &           nt, tri, material,
     &           nb, bnd)


      write(*,*) ' Number of triangles/vertices ',nt,nv 
      call graph(nv,vrt,nt,tri,'aft')

  
      end

      subroutine graph(nv,vrt,nt,tri,name)
      character*3 name
      integer nv,nt
      double precision vrt(2,*)
      integer          tri(3,*)
      real  kx
      double precision xymax(2),xymin(2), scale
      integer UNIT,CHAN
      integer k,l,i

      xymin(1)=vrt(1,1)
      xymin(2)=vrt(2,1)
      xymax(1)=vrt(1,1)
      xymax(2)=vrt(2,1)
      do i=2,nv
         xymin(1)=min(xymin(1),vrt(1,i))
         xymin(2)=min(xymin(2),vrt(2,i))
         xymax(1)=max(xymax(1),vrt(1,i))
         xymax(2)=max(xymax(2),vrt(2,i))
      end do
      scale = max(xymax(1)-xymin(1),xymax(2)-xymin(2))
      KX=500.0 / scale
      OPEN( UNIT=1, FILE=name//".ps" )
      WRITE(1,*) ' 10 10 translate 0 setlinewidth'
      WRITE(1,*)' /t{newpath moveto lineto lineto closepath stroke}def'
      do k=1,nt
        WRITE(1,*)(((vrt(i,tri(l,k))-xymin(i))*kx,i=1,2),l=1,3),' t'
      end do
      WRITE(1,*) ' showpage'
      close(1)
      return
      end
