c ==========================================================
      Program demo2 
c ==========================================================
c The adaptive iterative solution of the following bvp:
c -div D grad u = 1 in Omega
c             u = 0 on dOmega_D
c        du/dn  = 0 on dOmega_N
c where Omega = { x^2 + y^2 < 1  && (x<0 || y>0) }
c    dOmega_N = { x=0 && -1<y<0 }
c    dOmega_D = dOmega / dOmega_N
c    D = diag{10, 10}  for  x < 0
c        diag{1, 100}  for  x > 0
c ==========================================================
      implicit none
      integer nvmax,ntmax,nbmax,namax
c ... nvmax - maximum number of mesh nodes
c ... ntmax - maximum number of mesh triangles
c ... nbmax - maximum number of boundary edges
c ... namax - maximum number of non-zero matrix entries
      parameter(nvmax = 150 000, ntmax = 2*nvmax, nbmax = 10 000)
      parameter(namax = 900 000)

c ... work memory
      Integer   MaxWr, MaxWi
      Parameter(MaxWr = 1 000 000, MaxWi = 5 000 000)

      Integer  iW(MaxWi)
      Real*8   rW(MaxWr)

c ==========================================================
c   Library AFT 
c
c We define domain Omega and two materials
c    x<0 - material 1; 
c    x>0 - material 2.
c ==========================================================
      Real*8   bv(2,5), bltail(2,6)
      integer  Nbv, Nbl, bl(7,6)

      Data     Nbv/5/, Nbl/6/
      Data     bv/0,-1, -1,0, 0,1, 1,0, 0,0/           ! boundary nodes
      Data     bl/1,2,1,-1,1,1,0, 2,3,1,-1,2,1,0,      ! outer boundary edges
     &            3,4,1,-1,3,2,0, 4,5,0,-1,4,2,0,      ! outer boundary edges
     &            5,1,0,-1,5,1,0, 5,3,0,-1,6,2,1  /    ! outer boundary edges
      Data     bltail/1.5,1, 1,0.5, 0.5,0, 0,0,0,0,0,0/! curved outer boundary edges

      Integer  nv, nt, nb, nc
      Real*8   crv(2,nvmax), vrt(2,nvmax)
      Integer  iFNC(nvmax),material(ntmax),tri(3,ntmax),bnd(4,nbmax)
      Real*8   h


c ==========================================================
c   Library FEM
c ==========================================================
      include 'fem2Dtri.fd'
      include 'assemble.fd'

      Integer  IA(nvmax), JA(namax)
      Real*8    A(namax), DA(nvmax), RHS(nvmax), SOL(nvmax)

      Integer  IB(nvmax), JB(namax)
      Real*8    B(namax), RES(nvmax)

      Real*8   Aloc(MaxSize, MaxSize)
      Real*8   DATAFEM

      EXTERNAL Ddiff, Dbc, Drhs
      Real*8   Ddiff, Dbc, Drhs
      Integer  status, nRow, nCol


c ==========================================================
c   Library LU
c ==========================================================
      Integer  symbolic, numeric, sys
      Real*8   control(20), info(90)


c ==========================================================
c   Library ANI
c ==========================================================
      Integer   MaxSkipE, MaxQItr, nEStar
      Parameter(MaxSkipE = 100, MaxQItr = 50 000, nEStar = 4000)

      Real*8    Quality
      Parameter(Quality = 7D-1)

c ... the number of adaptive loops
      Integer   nLOOPs
      Parameter(nLOOPs = 3)

c ... IPV is the array of fixed (never touched) points.
      Integer   nPv, IPV(5), nFv, nEv, IFV, IEV
      Data      nPv/5/, IPV/1,2,3,4,5/,  nFv/0/, nEv/0/

      Real*8    rQuality
      Logical   flagAuto
      Integer   iPrint, iERR


c ==========================================================
c   Time measurements and othe local variables
c ==========================================================
      Real      ANItime, tmdata(2)
      Real*8    tm0, tm1, tmBF, tmLF, tmBC, tmLU, tmHA

      Integer   i, j, iLoop
      Real*8    rmax
      

c ==========================================================
c ... pass the user function userBoundary (forlibaft.c) 
      External userboundary               ! function in forlibaft.c
      Call registeruserfn( userboundary ) ! register the name in the library


c ... generate a quasi-uniform mesh with mesh step h
      Write(*,'(A)') '===> Start Library LIBAFT:' 
      h = 0.034                           

      Call aft2dboundary(
     &     Nbv, bv, Nbl, bl, bltail,  h,  ! input geometric data
     &     nv, vrt,                       ! output mesh data
     &     nt, tri, material,
     &     nb, bnd,
     &     nc, crv, iFNC )

      Write(*,*) '  number of triangles/vertices ',nt,nv 
      If(nv.gt.nvmax) Stop 'Too many nodes'
      If(nt.gt.ntmax) Stop 'Too many triangles'
      If(nb.gt.nbmax) Stop 'Too many boundary edges'
          

c ... draw the initial mesh 
      Call graph(nv,vrt,nt,tri,'aft')


c ... begin adaptive iterative loop
      Do iLoop = 1, nLOOPs
         tm0 = ANItime(tmdata)

c  ===   assemble the stifness matrix
         Write(*,'(/,A,I2,/,A)') '===> LOOP: ', iLoop,
     &                           '===> Start Library LIBFEM:'

c        this array will be used in the user subroutine Ddiff
c        DATAFEM(i) = 1.0 / i

c        no data is provided for the user subroutine Ddiff
         DATAFEM = 0

c        symmetric sparse matrix in a 0-based CSC format used in UMFPACK
c        status = IOR(MATRIX_SYMMETRIC, FORMAT_CSC)

c        general sparce matrix in the AMG format (modifed CSR format
c        where the diagonal element goes first)
         status = IOR(MATRIX_GENERAL, FORMAT_AMG)

         Call BilinearFormVolume(
     &        nv, nt, vrt, tri, material,
     &        GRAD, FEM_P1, GRAD, FEM_P1,
     &        Ddiff, DATAFEM, 1,
     &        status, nvmax, namax,
     &        IA, JA, DA, A, nRow, nCol,
     &        MaxWi, iW)

         tmBF = ANItime(tmdata)
         Write(*,'(A,I8)') '   number of non-zero entries:', 
     &                     IA(nRow + 1) - 1

c  ...   assemble the right-hand side
         Call LinearFormVolume(
     &        nv, nt, vrt, tri, material,
     &        FEM_P1,
     &        Drhs, DATAFEM, 2,
     &        RHS, nRow,
     &        MaxWi, iW)

         tmLF = ANItime(tmdata)
         Write(*,'(A,I12)') '   confirmed problem size:', nRow

c  ...   set up boundary conditions
         Call BoundaryConditions(
     &        nv, nb, nt, vrt, bnd, tri, 
     &        FEM_P1,
     &        Dbc, DATAFEM,
     &        IA, JA, DA, A, RHS, nRow,
     &        MaxWi, iW)

         tmBC = ANItime(tmdata)


c  ===   call the driver for LU factorization and solution
         Write(*,'(/,A)') '===> Start Library LIBLU:' 
         Call AMG2CSC(nRow,IA,JA,A, nCol,IB,JB,B)

c  ...   converting to the 0-based format
         Do i = 1, nCol + 1
            IB(i) = IB(i) - 1
         End do
         Do i = 1, IB(nCol + 1)  
            JB(i) = JB(i) - 1
         End do

c  ...   set up default control parameters & print only error messages
         Call umf4def(control)
         control(1) = 1

c  ...   pre-order and symbolic analysis
         Call umf4sym(nCol, nCol, IB,JB,B, symbolic,control,info)
         If(info(1) .lt. 0) Then
            Write(*,*) 'Error occurred in umf4sym: ', info(1)
            Stop
         End if
         Write(*,'(A,f14.2,A)') '   time of symbolic analysis:', 
     &      info(16), ' (sec)'

c  ...   numeric factorization
         Call umf4num(IB,JB,B, symbolic,numeric,control,info)
         If(info(1) .lt. 0) Then
            Write(*,*) 'Error occurred in umf4num: ', info(1)
            Stop
         End if

         Write(*,5003) info(66),
     &       (info (41) * info (4)) / 2**20,
     &       (info (42) * info (4)) / 2**20,
     &        info(43), info(44), info(45)

c  ...   free the symbolic analysis data
         Call umf4fsym(symbolic)

c  ...   solve Ax=b, without iterative refinement
         sys = 0
         Call umf4sol(sys, SOL, RHS, numeric, control, info)
         If(info(1) .lt. 0) Then
            Write(*,*) 'Error occurred in umf4sol: ', info(1)
            Stop
         End if

c  ...   free the numeric factorization data
         Call umf4fnum (numeric)
         tmLU = ANItime(tmdata)


c  ...   check the residual
         Call mulAgen(nRow, IA, JA, A, SOL, RES)
         rmax = 0
         Do i = 1, nRow
            rmax = max(rmax, RES(i) - RHS(i))
         End do
         Write(*,'(/,A,E12.6)') '   maximal norm of residual: ', rmax


c  ...   write solution isolines to ps-figure
         call isolines(SOL,nv,vrt,nt,tri,nb,bnd,'iso',20)


c  ===   generate the adaptive mesh
         Write(*,'(/,A)') '===> Start Library LIBGEN:' 
         tm1 = ANItime(tmdata)

         flagAuto = .TRUE.  ! default mesh generation options
c        status   = 1       ! forbid boundary triangles (see aniGEN/status.fd)
         status   = 0       ! no options
         iPrint   = 1       ! average level of output information


         Call mesh_solution(
c group (M)
     &        nv, nvmax, nb, nbmax, nt, ntmax, nPv,
     &        vrt, bnd, tri, IPV,
     &        crv, iFNC, 
     &        nEStar,
c group (D)
     &        nFv, nEv, IFV, IEV, material,
     &        flagAuto, status,
c group (Q)
     &        MaxSkipE, MaxQItr,
     &        SOL, Quality, rQuality,
c group (W)
     &        MaxWr, MaxWi, rW, iW,
     &        iPrint, iERR)

         tmHA = ANItime(tmdata)
         If(iERR.GT.1000) Call errMes(iERR, 'main',
     &                        'unspecified error if mesh_solution')

c  ...   draw the adapted mesh 
         Call graph(nv,vrt,nt,tri,'hba')

c  ...   draw solution isolines
         Call isolines(SOL,nv,vrt,nt,tri,nb,bnd,'his',20)

         Write(*,5002) tmBF - tm0, tmLF - tmBF, tmLU - tmBC, tmHA - tm1
      End do


      Stop 
 5002 Format(/,'Times:     Matrix        RHS         LU        HBA',/,
     &         F17.3, 3F11.3)

 5003 Format('   time for numeric factorization:', f9.2, ' (sec)',/,
     &       '   size of LU:    ', f10.2, ' (MB)', /,
     &       '   memory needed: ', f10.2, ' (MB)', /,
     &       '   flop count:    ', f10.0, /
     &       '   nnz (L):       ', f10.0, /
     &       '   nnz (U):       ', f10.0)
      End

