C ================================================================
C  Diffusion tensor             
C ================================================================
      Integer Function Ddiff(x, y, label, DATA, iSYS, Diff)
C ================================================================
      include 'fem2Dtri.fd'
C ================================================================
      Real*8  x, y, DATA(*), Diff(4, 4)
      Integer label, iSYS(*)
C ================================================================
      iSYS(1) = 2
      iSYS(2) = 2

      Do i = 1, 2
         Do j = 1, 2
            Diff(i, j) = 0D0
         End do
         if (label.eq.1) then  !isotropic in domain with material 1
            Diff(i, i) = 1D1
         else if (label.eq.2) then !anisotropic in domain with material 2
            if (i.eq.1) then
                Diff(i, i) = 1D0
            else
                Diff(i, i) = 1D2
            end if
         else 
            write(*,*) 'Ddiff: wrong label=', label
            stop
         end if
      End do

      Ddiff = TENSOR_SYMMETRIC

      Return
      End



C ================================================================
C Boundary condition
C ================================================================
      Integer Function Dbc(x, y, label, DATA, iSYS, eBC)
C ================================================================
      Include 'assemble.fd'
C ================================================================
      Real*8  x, y, DATA(*), eBC(*)
      Integer label, iSYS(*)

C ================================================================
      iSYS(1) = 1
      iSYS(2) = 1

      If (label.eq.5) Then !homogeneous Neumann on edges with label 5
         Dbc = BC_NEUMANN
         eBC(1)  = 0d0
      Else If (label.eq.6) Then !interior boundary edges with label 6 are ignored
         Dbc = BC_NULL   
         eBC(1)  = 0d0
      Else If ( label.ge.1 .and. label.le.4 ) Then !homogeneous Dirichlet on edges with labels 1-4
         Dbc = BC_DIRICHLET
         eBC(1)  = 0D0
      Else
         write(*,*) 'Dbc: wrong label=', label
         stop
      End if

      Return
      End



C ================================================================
C Right hand side
C ================================================================
      Integer Function Drhs(x, y, label, DATA, iSYS, F)
C ================================================================
      Include 'fem2Dtri.fd'
C ================================================================
      Real*8  x, y, DATA(*), F(*)
      Integer label, iSYS(*)


C ================================================================
      iSYS(1) = 1
      iSYS(2) = 1

      F(1) = 1D0

      Drhs = TENSOR_SCALAR

      Return
      End


