C =========================================================
c The program llustrate organization of an adaptive loop
c for building a mesh minimizing the interpolation error 
c for a given function (Func). The function is taken from 
C D'Azevedo's paper on optimal triangulations. 
C =========================================================


C =========================================================
      double precision function Func(xy)
C =========================================================
      implicit none
      double precision xy(2)
      double precision x0,y0
      x0 = 0.5
      y0 = -0.2
      Func = ((xy(1)-x0)**2-(dsqrt(1d1)*xy(2)-y0)**2)/
     &       ((xy(1)-x0)**2+(dsqrt(1d1)*xy(2)-y0)**2)**2

      return
      end


C =========================================================
      program main  
C =========================================================
      implicit none
      integer nvmax,ntmax,nbmax,namax
c nvmax   - maximum number of mesh nodes
c ntmax   - maximum number of mesh triangles
c nbmax   - maximum number of boundary edges
      parameter(nvmax=150000,ntmax=2*nvmax,nbmax=10000)
c working memory
      Integer   MaxWr, MaxWi
      Parameter(MaxWr =  1 000 000, MaxWi = 5 000 000)
      Integer iW(MaxWi)
      Real*8  rW(MaxWr)

C =========================================================
c define boundary edges for library LIBAFT
C =========================================================
c Nore: crv_model.c is not needed because the compputational
c domain is the unit square.
C =========================================================
      double precision bv(2,4),bltail(2,4)
      integer          Nbv,Nbl,bl(7,4)

      data             Nbv/4/,Nbl/4/
      data             bv/0,0, 0,1, 1,1, 1,0/                ! boundary nodes
      data             bl/1,2,0,-1,1,1,0, 2,3,0,-1,2,1,0,    ! outer boundary edges
     &                    3,4,0,-1,3,1,0, 4,1,0,-1,4,1,0/    ! outer boundary edges
      data             bltail/0,0, 0,0, 0,0, 0,0/            ! curved data for each outer boundary edge

      integer          nv,nt,nb,nc
      double precision crv(2,nvmax), vrt(2,nvmax)
      integer          iFNC(nvmax),material(ntmax),
     &                 tri(3,ntmax),bnd(4,nbmax)
      double precision h

c Function
      double precision U(nvmax), Func
      external         Func
c Errors
      double precision errInt, errGrd,
     &                 erInttri(ntmax),erGrdtri(ntmax)
      external         erInt, erGrd



C =========================================================
c set up control parameters for library LIBANI 
C =========================================================
      Integer   MaxSkipE, MaxQItr, nEStar
      Parameter(MaxSkipE = 100, MaxQItr = 50 000, nEStar = 600)
      Real*8    Quality
      Parameter(Quality = 7D-1)
      Integer   nLOOPs
      Parameter(nLOOPs = 5)

C =========================================================
c define other parameter reguired by the library LIBANI
C =========================================================
c IPV is array of fixed (never touched) points. For instance,
c they may be corner points. Here IPV is empty because fixed 
c points are recovered automatically from labels of boundary
c edges. If all boundary edges have the same label, corner 
c points must be given explicitly, as shown in two commented 
c lines.
C =========================================================
      Integer  nPv, IPV, nFv, nEv, IFV, IEV
      data            nPv/0/,  nFv/0/, nEv/0/
c     Integer  nPv, IPV(4), nFv, nEv, IFV, IEV
c     data     nPv/4/, IPV/1,2,3,4/,  nFv/0/, nEv/0/
      Real*8   rQuality
      Logical  flagAuto
      Integer  status, iPrint, iERR

c time measurement
      Real    ANItime, tmdata(2)
      Real*8  tm0,tm1,  tmAF,tmHA

c local
      integer i,j,iLoop,idummy
      

C =========================================================
c generate quasi-uniform mesh with mesh step h
C =========================================================
      tm0 = ANItime(tmdata)

      h = 0.03  

      call aft2dboundary( Nbv, bv, Nbl, bl, bltail,  h,     ! geomtric data
     &           nv, vrt,                                   ! mesh data on output
     &           nt, tri, material,
     &           nb, bnd,
     &           nc, crv, iFNC )

      tmAF = ANItime(tmdata)

      write(*,*) 'mesh1: number of triangles/vertices ', nt, nv 
      if(nv.gt.nvmax) stop ' too many nodes'
      if(nt.gt.ntmax) stop ' too many triangles'
      if(nb.gt.nbmax) stop ' too many boundary edges'
          

c make PostScript figure of the initial mesh, aft.ps
      call graph(nv,vrt,nt,tri,'aft')


C =========================================================
c make nLOOPs adaptive loops
C =========================================================
      Do iLoop = 1, nLOOPs
         Write(*, 5000) iLoop

c define the function at the nodes
         do i = 1, nv
            U(i) = Func(vrt(1,i))
         end do

c compute errors
         call erInt(U,nv,vrt,nt,tri,erInttri)
         call erGrd(U,nv,vrt,nt,tri,erGrdtri)
         call DSORT (erInttri, idummy, nt, 1, IERR)
         call DSORT (erGrdtri, idummy, nt, 1, IERR)

         errInt = erInttri(1)
         errGrd = erGrdtri(1)
         write(*,5003) 'Min : ', errInt, errGrd
         errInt = erInttri(nt)
         errGrd = erGrdtri(nt)
         write(*,5003) 'Max : ', errInt, errGrd
         i = (9*nt)/10
         errInt = erInttri(i)
         errGrd = erGrdtri(i)
c        write(*,5003) '90%: ', errInt, errGrd
         errInt = 0
         do i = 1,nt
            errInt = errInt  + erInttri(i)
            errGrd = errGrd  + erGrdtri(i)
         end do
         errInt = errInt/nt
         errGrd = errGrd/nt
         write(*,5003) 'Mean: ', errInt, errGrd


c make PosctScript file with isolines of mesh function U
         call isolines(U,nv,vrt,nt,tri,nb,bnd,'iso',20)


c start the clock
         tm1 = ANItime(tmdata)


c adapt the mesh
         flagAuto = .TRUE.  ! default mesh generation options
c        status   = 1       ! forbid boundary triangles (see status.fd)
         status   = 0       ! no special options for mesh generation 
         iPrint   = 1       ! average level of output information


         Call mesh_solution(
c group (M)
     &        nv, nvmax, nb, nbmax, nt, ntmax, nPv,
     &        vrt, bnd, tri, IPV,
     &        crv, iFNC, 
     &        nEStar,
c group (D)
     &        nFv, nEv, IFV, IEV, material,
     &        flagAuto, status,
c group (Q)
     &        MaxSkipE, MaxQItr,
     &        U, Quality, rQuality,
c group (W)
     &        MaxWr, MaxWi, rW, iW,
     &        iPrint, iERR)

         tmHA = ANItime(tmdata)
         If(iERR.GT.1000) Call errMes(iERR, 'main',
     &                      'unspecified error if aniSolutionShort')


c make PostScript figure of the adaptive mesh, hba.ps
         call graph(nv,vrt,nt,tri,'hba')

c make PosctScript file with isolines of interpolated mesh function U
         call isolines(U,nv,vrt,nt,tri,nb,bnd,'his',20)

         Write(*,5002)  tmAF - tm0, tmHA - tm1
      End do


      stop 
 5000 Format(/, '===== ', I2, 'th ADAPTIVE LOOP =====')
 5002 Format(/,'Time:         AFT        HBA',/, F17.3, 2F12.3)

 5003 Format(A,' max norm of error=',E9.3,',  H_1 norm of error=',E9.3)

      End


